/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.core;

import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;

public class AlternateAirport {
    private Double lat;
    private Double lon;
    private Integer elev;
    private String ident;
    private Double frequency;

    public AlternateAirport() {
    }

    public AlternateAirport(Airport airport, Double frequency) {
        this.lat = airport.getLat();
        this.lon = airport.getLon();
        this.elev = airport.getElev();
        this.ident = airport.getIdentOrName();
        this.frequency = frequency;
    }

    public AlternateAirport clone() {
        AlternateAirport a = new AlternateAirport();
        a.setElev(this.elev);
        a.setFrequency(this.frequency);
        a.setIdent(this.ident);
        a.setLat(this.lat);
        a.setLon(this.lon);
        return a;
    }

    public Double getLat() {
        return this.lat;
    }

    public void setLat(Double lat) {
        this.lat = lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public void setLon(Double lon) {
        this.lon = lon;
    }

    public Integer getElev() {
        return this.elev;
    }

    public void setElev(Integer elev) {
        this.elev = elev;
    }

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String ident) {
        this.ident = ident;
    }

    public Double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(Double frequency) {
        this.frequency = frequency;
    }

    public GpsPlace getGpsPlace() {
        GpsPlace place = new GpsPlace(this.lat, this.lon);
        place.setName(this.ident);
        if (this.elev != null) {
            place.setAlt(this.elev.doubleValue());
            return place;
        }
        return place;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AlternateAirport [lat=");
        builder.append(this.lat);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", elev=");
        builder.append(this.elev);
        builder.append(", ident=");
        builder.append(this.ident);
        builder.append(", frequency=");
        builder.append(this.frequency);
        builder.append("]");
        return builder.toString();
    }
}

