/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean.theme.airspace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.bean.theme.airspace.AirspacesColorTheme;
import main.java.guru.vfrflight.bean.theme.airspace.FsxAirspaceColorTheme;
import main.java.guru.vfrflight.bean.theme.airspace.OpenAipAirspaceColorTheme;
import main.java.guru.vfrflight.bean.theme.airspace.PazpAirspaceColorTheme;

public class AirspaceThemeFactory {
    public static final String PAZP_TYPE = "PAZP";
    public static final String FSX_TYPE = "FSX";
    public static final String OPEN_AIP_TYPE = "OPEN_AIP";
    private static final Map<String, AirspacesColorTheme> TYPE_MAPPINGS;

    private AirspaceThemeFactory() {
    }

    public static AirspacesColorTheme createTheme(String type) {
        if (TYPE_MAPPINGS.get(type) != null) {
            return TYPE_MAPPINGS.get(type);
        }
        return new OpenAipAirspaceColorTheme();
    }

    public static StringComboBoxItem[] createComboBoxValues() {
        StringComboBoxItem[] result = new StringComboBoxItem[TYPE_MAPPINGS.size()];
        int i = 0;
        for (Map.Entry<String, AirspacesColorTheme> pair : TYPE_MAPPINGS.entrySet()) {
            result[i] = new StringComboBoxItem(Messages.getInstance().get("settings_frame_map_airspaces_theme_" + pair.getKey().toLowerCase()), pair.getKey());
            ++i;
        }
        return result;
    }

    static {
        HashMap<String, AirspacesColorTheme> mp = new HashMap<String, AirspacesColorTheme>();
        mp.put(PAZP_TYPE, new PazpAirspaceColorTheme());
        mp.put(FSX_TYPE, new FsxAirspaceColorTheme());
        mp.put(OPEN_AIP_TYPE, new OpenAipAirspaceColorTheme());
        TYPE_MAPPINGS = Collections.unmodifiableMap(mp);
    }
}

