/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean.meteo;

import java.awt.image.BufferedImage;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBean;
import main.java.guru.vfrflight.bean.meteo.MeteoMapType;
import main.java.guru.vfrflight.util.DateUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.org.jdesktop.swingx.VirtualEarthTileFactoryInfo;
import main.java.org.jdesktop.swingx.mapviewer.TileFactoryInfo;

public class MeteoMapBeanUm1
implements MeteoMapBean {
    private static final String MAP_LEGENDS_PATH = "img/meteo/legend/";
    private MeteoMapType type = MeteoMapType.AUM1_CLOUD;
    private TileFactoryInfo previousTileFactory = new VirtualEarthTileFactoryInfo("Virtual Earth", VirtualEarthTileFactoryInfo.MAP, null, null);
    private final Calendar startingDate;
    private final String startingTime;
    private int forecastHour = 1;
    private boolean backgroundMap = false;
    private final Map<MeteoMapType, BufferedImage> mapLegends = new HashMap<MeteoMapType, BufferedImage>();
    private final List<MeteoMapType> mapTypes;

    public MeteoMapBeanUm1() {
        this.startingDate = Calendar.getInstance();
        this.startingDate.setTimeZone(TimeZone.getTimeZone("Europe/Warsaw"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String startingDateStr = df.format(this.startingDate.getTime());
        this.startingTime = startingDateStr + "T00%3A00%3A00Z";
        try {
            this.startingDate.setTime(df.parse(startingDateStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.mapTypes = new ArrayList<MeteoMapType>();
        for (MeteoMapType mapType : MeteoMapType.values()) {
            if (!mapType.isUm1()) continue;
            this.mapTypes.add(mapType);
        }
        this.loadMapLegends();
    }

    @Override
    public String getStartingDateWithHour() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(this.startingDate.getTime()) + "T00";
    }

    private void loadMapLegends() {
        for (MeteoMapType type : this.mapTypes) {
            File imgFile = new File(MAP_LEGENDS_PATH + (Object)((Object)type) + ".png");
            if (!imgFile.exists()) continue;
            this.mapLegends.put(type, UrlUtil.readImageFromDisk(imgFile.getAbsolutePath()));
        }
    }

    @Override
    public List<MeteoMapType> getMapTypes() {
        return this.mapTypes;
    }

    @Override
    public String getDateTimeForForecastHour() {
        int hoursAhead = this.forecastHour;
        GregorianCalendar calendarUtc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendarUtc.setTimeInMillis(this.startingDate.getTimeInMillis() + (long)(hoursAhead * 3600 * 1000));
        String format = "yyyy-MM-dd HH:mm";
        SimpleDateFormat df = new SimpleDateFormat(format);
        return DateUtil.formatUTCToLocal(df.format(calendarUtc.getTime()), format) + " " + this.getTimeZoneId(Calendar.getInstance());
    }

    private String getTimeZoneId(Calendar cal) {
        return cal.getTimeZone().getOffset(cal.getTimeInMillis()) == 0x6DDD00 ? "CEST" : "CET";
    }

    @Override
    public MeteoMapType getType() {
        return this.type;
    }

    @Override
    public void setType(MeteoMapType type) {
        this.type = type;
    }

    @Override
    public int getForecastHour() {
        return this.forecastHour;
    }

    @Override
    public void setForecastHour(int forecastHour) {
        this.forecastHour = forecastHour;
    }

    @Override
    public Map<MeteoMapType, BufferedImage> getMapLegends() {
        return this.mapLegends;
    }

    @Override
    public TileFactoryInfo getPreviousTileFactory() {
        return this.previousTileFactory;
    }

    public void setPreviousTileFactory(TileFactoryInfo previousTileFactory) {
        this.previousTileFactory = previousTileFactory;
    }

    @Override
    public String getLink() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://mapy.meteo.pl/geoserver/gwc/service/wms/?SERVICE=WMS&REQUEST=GetMap&VERSION=1.1.1&LAYERS=um%3");
        sb.append(this.type.toString());
        sb.append("&STYLES=&FORMAT=image%2Fpng&TRANSPARENT=false&HEIGHT=256&WIDTH=256&TIME=");
        sb.append(this.startingTime);
        sb.append("&TILED=true&ONADDMETHOD=false&DIM_FORECAST=");
        sb.append(this.forecastHour);
        sb.append("&SRS=EPSG%3A3857");
        return sb.toString();
    }

    @Override
    public boolean isBackgroundMap() {
        return this.backgroundMap;
    }

    @Override
    public void setBackgroundMap(boolean backgroundMap) {
        this.backgroundMap = backgroundMap;
    }
}

