/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean.filter;

import java.util.HashSet;
import java.util.Set;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.UnitUtil;

public class AirspaceFilter {
    private Set<AirspaceType> dontDrawAirspacesList = null;
    private Integer drawAirspaceRangeFrom = null;
    private Integer drawAirspaceRangeTo = null;
    private Integer drawAtAltitude = null;
    private volatile boolean restrictToZoom = true;

    public void clear() {
        this.dontDrawAirspacesList = null;
        this.drawAirspaceRangeFrom = null;
        this.drawAirspaceRangeTo = null;
        this.restrictToZoom = true;
    }

    public Integer getDrawAirspaceRangeFrom() {
        return this.drawAirspaceRangeFrom;
    }

    public void setDrawAirspaceRangeFrom(Integer drawAirspaceRangeFrom) {
        if (drawAirspaceRangeFrom != null) {
            drawAirspaceRangeFrom = (int)Math.round(UnitUtil.recalculateAltitude(drawAirspaceRangeFrom.intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
        }
        this.drawAirspaceRangeFrom = drawAirspaceRangeFrom;
    }

    public Integer getDrawAirspaceRangeTo() {
        return this.drawAirspaceRangeTo;
    }

    public void setDrawAirspaceRangeTo(Integer drawAirspaceRangeTo) {
        if (drawAirspaceRangeTo != null) {
            drawAirspaceRangeTo = (int)Math.round(UnitUtil.recalculateAltitude(drawAirspaceRangeTo.intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
        }
        this.drawAirspaceRangeTo = drawAirspaceRangeTo;
    }

    public Set<AirspaceType> getDontDrawAirspacesList() {
        if (this.dontDrawAirspacesList == null) {
            this.dontDrawAirspacesList = new HashSet<AirspaceType>();
        }
        return this.dontDrawAirspacesList;
    }

    public void setDontDrawAirspacesList(Set<AirspaceType> dontDrawAirspacesList) {
        this.dontDrawAirspacesList = dontDrawAirspacesList;
    }

    public boolean checkDontDrawList(AirspaceType type) {
        return this.getDontDrawAirspacesList().contains((Object)type);
    }

    public boolean checkDisplayAirspaceArea(AirspaceAreaDTO area) {
        return (area.getType() == null || !this.getDontDrawAirspacesList().contains((Object)area.getType())) && (!this.isDrawAtAltitude() && area.isBetween(this.getDrawAirspaceRangeFrom(), this.getDrawAirspaceRangeTo()) || this.isDrawAtAltitude() && area.containsPlaneAtAltitude(this.drawAtAltitude)) && (!this.restrictToZoom || MapFrame.getInstance().getMapViewer().getZoom() <= 12);
    }

    public boolean anySelected() {
        return this.dontDrawAirspacesList != null && this.dontDrawAirspacesList.size() > 0 || this.isDrawAtAltitude() || this.drawAirspaceRangeFrom != null || this.drawAirspaceRangeTo != null || !this.restrictToZoom;
    }

    public Integer getDrawAtAltitude() {
        return this.drawAtAltitude;
    }

    public void setDrawAtAltitude(Integer drawAtAltitude) {
        this.drawAtAltitude = drawAtAltitude;
    }

    public boolean isDrawAtAltitude() {
        return this.drawAtAltitude != null;
    }

    public boolean isRestrictToZoom() {
        return this.restrictToZoom;
    }

    public void setRestrictToZoom(boolean restrictToZoom) {
        this.restrictToZoom = restrictToZoom;
    }
}

