/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean.filter;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.UnitUtil;

public class AirportFilter {
    private volatile Boolean mountainous = null;
    private volatile Boolean withVor = null;
    private volatile Boolean hardened = null;
    private volatile Boolean withNdb = null;
    private volatile Boolean withIls = null;
    private volatile Boolean heli = null;
    private volatile Boolean withSkewedIls = null;
    private volatile Integer runwayLengthFrom = null;
    private volatile Integer runwayLengthTo = null;
    private volatile Integer elevationFrom = null;
    private volatile Integer elevationTo = null;
    private volatile boolean restrictToZoom = true;

    public void clear() {
        this.heli = null;
        this.mountainous = null;
        this.withVor = null;
        this.withNdb = null;
        this.withIls = null;
        this.hardened = null;
        this.withSkewedIls = null;
        this.runwayLengthFrom = null;
        this.runwayLengthTo = null;
        this.elevationFrom = null;
        this.elevationTo = null;
        this.restrictToZoom = true;
    }

    public Integer getRunwayLengthFrom() {
        return this.runwayLengthFrom;
    }

    public void setRunwayLengthFrom(Integer runwayLengthFrom) {
        this.runwayLengthFrom = runwayLengthFrom;
    }

    public Integer getRunwayLengthTo() {
        return this.runwayLengthTo;
    }

    public void setRunwayLengthTo(Integer runwayLengthTo) {
        this.runwayLengthTo = runwayLengthTo;
    }

    public Integer getElevationFrom() {
        return this.elevationFrom;
    }

    public void setElevationFrom(Integer elevationFrom) {
        if (elevationFrom != null) {
            elevationFrom = (int)Math.round(UnitUtil.recalculateAltitude(elevationFrom.intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
        }
        this.elevationFrom = elevationFrom;
    }

    public Integer getElevationTo() {
        return this.elevationTo;
    }

    public void setElevationTo(Integer elevationTo) {
        if (elevationTo != null) {
            elevationTo = (int)Math.round(UnitUtil.recalculateAltitude(elevationTo.intValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
        }
        this.elevationTo = elevationTo;
    }

    public Boolean getMountainous() {
        return this.mountainous;
    }

    public void setMountainous(Boolean mountainous) {
        this.mountainous = mountainous;
    }

    public Boolean getHeli() {
        return this.heli;
    }

    public void setHeli(Boolean heli) {
        this.heli = heli;
    }

    public Boolean getHardened() {
        return this.hardened;
    }

    public void setHardened(Boolean hardened) {
        this.hardened = hardened;
    }

    public Boolean getWithVor() {
        return this.withVor;
    }

    public void setWithVor(Boolean withVor) {
        this.withVor = withVor;
    }

    public Boolean getWithNdb() {
        return this.withNdb;
    }

    public void setWithNdb(Boolean withNdb) {
        this.withNdb = withNdb;
    }

    public Boolean getWithIls() {
        return this.withIls;
    }

    public void setWithIls(Boolean withIls) {
        this.withIls = withIls;
    }

    public boolean isRestrictToZoom() {
        return this.restrictToZoom;
    }

    public void setRestrictToZoom(boolean restrictToZoom) {
        this.restrictToZoom = restrictToZoom;
    }

    public Boolean getWithSkewedIls() {
        return this.withSkewedIls;
    }

    public void setWithSkewedIls(Boolean withSkewedIls) {
        this.withSkewedIls = withSkewedIls;
    }

    private boolean checkHeli(AirportDTO airport) {
        if (this.heli == null) {
            return true;
        }
        return this.heli.booleanValue() == airport.hasHeli();
    }

    private boolean checkMountainous(AirportDTO airport) {
        if (this.mountainous == null) {
            return true;
        }
        return this.mountainous.booleanValue() == airport.isMountainous();
    }

    private boolean checkSkewedIls(AirportDTO airport) {
        if (this.withSkewedIls == null) {
            return true;
        }
        return this.withSkewedIls.booleanValue() == airport.isSkewedIls();
    }

    private boolean checkWithVor(AirportDTO airport) {
        if (this.withVor == null) {
            return true;
        }
        return this.withVor.booleanValue() == airport.isVor();
    }

    private boolean checkWithNdb(AirportDTO airport) {
        if (this.withNdb == null) {
            return true;
        }
        return this.withNdb.booleanValue() == airport.isNdb();
    }

    private boolean checkWithIls(AirportDTO airport) {
        if (this.withIls == null) {
            return true;
        }
        return this.withIls.booleanValue() == airport.isIls();
    }

    private boolean checkHardened(AirportDTO airport) {
        if (this.hardened == null) {
            return true;
        }
        return this.hardened.booleanValue() == airport.isHardened();
    }

    private boolean checkRunwayLength(AirportDTO airport) {
        if (airport.getMainLength() == null || this.runwayLengthFrom == null && this.runwayLengthTo == null) {
            return true;
        }
        return (this.runwayLengthFrom == null || this.runwayLengthFrom != null && airport.getMainLength() >= this.runwayLengthFrom) && (this.runwayLengthTo == null || this.runwayLengthTo != null && airport.getMainLength() <= this.runwayLengthTo);
    }

    private boolean checkRunwayElevation(AirportDTO airport) {
        if (airport.getElevation() == null || this.elevationFrom == null && this.elevationTo == null) {
            return true;
        }
        return (this.elevationFrom == null || this.elevationFrom != null && airport.getElevation() >= this.elevationFrom) && (this.elevationTo == null || this.elevationTo != null && airport.getElevation() <= this.elevationTo);
    }

    public boolean check(AirportDTO airport) {
        return this.checkMountainous(airport) && this.checkHeli(airport) && this.checkWithIls(airport) && this.checkWithNdb(airport) && this.checkWithVor(airport) && this.checkRunwayLength(airport) && this.checkRunwayElevation(airport) && this.checkSkewedIls(airport) && this.checkHardened(airport);
    }

    public boolean checkDisplayAirport(AirportDTO airport) {
        return this.check(airport) && (!this.restrictToZoom || MapFrame.getInstance().getMapViewer().getZoom() <= 11);
    }

    public synchronized boolean anySelected() {
        return this.mountainous != null || this.withIls != null || this.withVor != null || this.withNdb != null || this.heli != null || this.runwayLengthFrom != null || this.runwayLengthTo != null || this.elevationFrom != null || this.elevationTo != null || this.hardened != null || this.withSkewedIls != null || !this.restrictToZoom;
    }
}

