/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ProxyBean {
    private String httpHost;
    private int httpPort;
    private String httpUserName;
    private String httpPassword;

    public ProxyBean() {
    }

    public ProxyBean(String httpHost, int httpPort) {
        this.httpHost = httpHost;
        this.httpPort = httpPort;
    }

    public ProxyBean(String httpHost, int httpPort, String httpUserName, String httpPassword) {
        this.httpHost = httpHost;
        this.httpPort = httpPort;
        this.httpUserName = httpUserName;
        this.httpPassword = httpPassword;
    }

    public void setGlobalProxy() {
        System.setProperty("http.proxyHost", this.getHttpHost());
        System.setProperty("http.proxyPort", String.valueOf(this.getHttpPort()));
        System.setProperty("https.proxyHost", this.getHttpHost());
        System.setProperty("https.proxyPort", String.valueOf(this.getHttpPort()));
        if (this.isUseHttpAuth()) {
            System.setProperty("http.proxyUser", this.getHttpUserName());
            System.setProperty("http.proxyPassword", this.getHttpPassword());
            System.setProperty("https.proxyUser", this.getHttpUserName());
            System.setProperty("https.proxyPassword", this.getHttpPassword());
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    String prot = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(prot + ".proxyHost", ProxyBean.this.httpHost);
                    String port = System.getProperty(prot + ".proxyPort", String.valueOf(ProxyBean.this.httpPort));
                    String user = System.getProperty(prot + ".proxyUser", ProxyBean.this.httpUserName);
                    String password = System.getProperty(prot + ".proxyPassword", ProxyBean.this.httpPassword);
                    if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, password.toCharArray());
                    }
                    return null;
                }
            });
        }
    }

    public boolean isUseHttpAuth() {
        return this.httpUserName != null && this.httpPassword != null;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public void setHttpHost(String httpHost) {
        this.httpHost = httpHost;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getHttpUserName() {
        return this.httpUserName;
    }

    public void setHttpUserName(String httpUserName) {
        this.httpUserName = httpUserName;
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public void setHttpPassword(String httpPassword) {
        this.httpPassword = httpPassword;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProxyBean [httpHost=");
        builder.append(this.httpHost);
        builder.append(", httpPort=");
        builder.append(this.httpPort);
        builder.append(", httpUserName=");
        builder.append(this.httpUserName);
        builder.append(", httpPassword=");
        builder.append(this.httpPassword);
        builder.append("]");
        return builder.toString();
    }
}

