/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.hsqldb.lib.StringUtil;

public class SimConnectTraffic {
    private GeoPosition pos;
    private double alt;
    private Double altDiffFt;
    private GeoPosition nextPositionIn10Sec;
    private double gs;
    private double trueHeading;
    private double verticalSpeed;
    private String name;
    private String secondName;
    private String route;
    private boolean onGround;

    public SimConnectTraffic(String name, String secondName, String route, double lat, double lon, double alt, double gs, double trueHeading, double verticalSpeed, boolean onGround) {
        this.pos = new GeoPosition(lat, lon);
        this.alt = alt;
        this.gs = gs;
        this.trueHeading = trueHeading;
        this.name = name;
        this.secondName = secondName;
        this.verticalSpeed = verticalSpeed;
        this.onGround = onGround;
        this.route = route;
    }

    public SimConnectTraffic() {
    }

    public GeoPosition getPos() {
        return this.pos;
    }

    public void setPos(GeoPosition pos) {
        this.pos = pos;
    }

    public double getAlt() {
        return this.alt;
    }

    public void setAlt(double alt) {
        this.alt = alt;
    }

    public double getGs() {
        return this.gs;
    }

    public void setGs(double gs) {
        this.gs = gs;
    }

    public double getTrueHeading() {
        return this.trueHeading;
    }

    public void setTrueHeading(double trueHeading) {
        this.trueHeading = trueHeading;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getAltDiffFt() {
        return this.altDiffFt;
    }

    public void setAltDiffFt(Double altDiffFt) {
        this.altDiffFt = altDiffFt;
    }

    public double getVerticalSpeed() {
        return this.verticalSpeed;
    }

    public void setVerticalSpeed(double verticalSpeed) {
        this.verticalSpeed = verticalSpeed;
    }

    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimConnectTraffic [pos=");
        builder.append(this.pos);
        builder.append(", alt=");
        builder.append(this.alt);
        builder.append(", altDiffFt=");
        builder.append(this.altDiffFt);
        builder.append(", nextPositionIn10Sec=");
        builder.append(this.nextPositionIn10Sec);
        builder.append(", gs=");
        builder.append(this.gs);
        builder.append(", trueHeading=");
        builder.append(this.trueHeading);
        builder.append(", verticalSpeed=");
        builder.append(this.verticalSpeed);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", secondName=");
        builder.append(this.secondName);
        builder.append(", route=");
        builder.append(this.route);
        builder.append(", onGround=");
        builder.append(this.onGround);
        builder.append("]");
        return builder.toString();
    }

    public String getSecondName() {
        return this.secondName;
    }

    public void setSecondName(String secondName) {
        this.secondName = secondName;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }

    public GeoPosition getNextPositionIn10Sec() {
        return this.nextPositionIn10Sec;
    }

    public void setNextPositionIn10Sec(GeoPosition nextPositionIn10Sec) {
        this.nextPositionIn10Sec = nextPositionIn10Sec;
    }

    public boolean isInside(GpsArea area) {
        return this.getPos().getLatitude() <= area.getMaxLat() && this.getPos().getLatitude() >= area.getMinLat() && this.getPos().getLongitude() >= area.getMinLon() && this.getPos().getLongitude() <= area.getMaxLon();
    }

    public String getInfo() {
        double vs = this.getVerticalSpeed();
        String vsUnit = "fpm";
        double alt = this.getAlt();
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            alt = UnitUtil.recalculateAltitude(alt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            if ("m".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                vs = UnitUtil.recalculateVerticalSpeed(vs, "fpm", "m/s", false);
                vsUnit = "m/s";
            }
        }
        double gs = this.getGs();
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        if (!StringUtil.isEmpty(this.getSecondName())) {
            builder.append(" " + this.getSecondName());
        }
        if (!StringUtil.isEmpty(this.getRoute())) {
            builder.append(" (" + this.getRoute() + ")");
        }
        builder.append(" [");
        builder.append(Math.round(alt));
        builder.append(SettingsBean.getInstance().getParamUnitsAltitude() + ", ");
        builder.append(Math.round(vs));
        builder.append(vsUnit + ", ");
        builder.append(Math.round(gs) + SettingsBean.getInstance().getParamUnitsSpeed() + "]");
        return builder.toString();
    }
}

