/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.api.ExtConnectBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.NumberUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class SimConnectBean
implements ExtConnectBean {
    private static final Logger log = Logger.getLogger(SimConnectBean.class);
    private Float userLat;
    private Float userLon;
    private Float userAlt;
    private Float userIndicatedAlt;
    private Float userGs;
    private Float userTrueHeading;
    private Float userMagHeading;
    private Float userAltAboveTerrain;
    private Float userVerticalSpeed;
    private Float userIndicatedSpeed;
    private Float userTas;
    private Float userPitch;
    private Float userBank;
    private Float gForce;
    private Float windVelocity;
    private Float windDirection;
    private Short flapsHandle;
    private Float yokeXPosition;
    private Float yokeYPosition;
    private Float rudderPeddalsPosition;
    private Float fps;
    private Boolean onGround = true;
    private Long timestamp;

    public SimConnectBean() {
    }

    public SimConnectBean(String row) {
        String[] data = row.split(";", -1);
        if (data.length >= 21) {
            int i = 0;
            if (!StringUtil.isEmpty(data[i])) {
                try {
                    this.setTimestamp(Long.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserLat(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserLon(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserAlt(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserIndicatedAlt(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserAltAboveTerrain(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            this.setOnGround("1".equals(data[++i]));
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserIndicatedSpeed(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserGs(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserMagHeading(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserTrueHeading(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserVerticalSpeed(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserBank(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setUserPitch(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setgForce(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setWindVelocity(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setWindDirection(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setYokeXPosition(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setYokeYPosition(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setRudderPeddalsPosition(Float.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            if (!StringUtil.isEmpty(data[++i])) {
                try {
                    this.setFlapsHandle(Short.valueOf(data[i]));
                }
                catch (NumberFormatException e) {
                    log.error(e, e);
                }
            }
            ++i;
            if (data.length >= 22) {
                if (!StringUtil.isEmpty(data[i])) {
                    try {
                        this.setUserTas(Float.valueOf(data[i]));
                    }
                    catch (NumberFormatException e) {
                        log.error(e, e);
                    }
                }
                ++i;
            }
            if (data.length >= 23) {
                if (!StringUtil.isEmpty(data[i])) {
                    try {
                        this.setFps(Float.valueOf(data[i]));
                    }
                    catch (NumberFormatException e) {
                        log.error(e, e);
                    }
                }
                ++i;
            }
        } else {
            log.error("Invalid data length: " + data.length);
        }
    }

    public SimConnectBean(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean positionEquals(ExtConnectBean bean) {
        if (bean == null) {
            return false;
        }
        if (!(bean instanceof SimConnectBean)) {
            return false;
        }
        return NumberUtil.floatEqualsFloat(this.userLat.floatValue(), bean.getUserLat().floatValue(), 5) && NumberUtil.floatEqualsFloat(this.userLon.floatValue(), bean.getUserLon().floatValue(), 5) && Math.round(this.userAlt.floatValue()) == Math.round(bean.getUserAlt().floatValue());
    }

    @Override
    public Float getUserLat() {
        return this.userLat;
    }

    public void setUserLat(Float userLat) {
        this.userLat = userLat;
    }

    @Override
    public Float getUserLon() {
        return this.userLon;
    }

    public void setUserLon(Float userLon) {
        this.userLon = userLon;
    }

    @Override
    public Float getUserAlt() {
        return this.userAlt;
    }

    public void setUserAlt(Float userAlt) {
        this.userAlt = userAlt;
    }

    @Override
    public Float getUserIndicatedAlt() {
        return this.userIndicatedAlt;
    }

    public void setUserIndicatedAlt(Float userIndicatedAlt) {
        this.userIndicatedAlt = userIndicatedAlt;
    }

    @Override
    public Float getUserGs() {
        return this.userGs;
    }

    public void setUserGs(Float userGs) {
        this.userGs = userGs;
    }

    @Override
    public Float getUserTrueHeading() {
        return this.userTrueHeading;
    }

    public void setUserTrueHeading(Float userTrueHeading) {
        this.userTrueHeading = userTrueHeading;
    }

    @Override
    public Float getUserMagHeading() {
        return this.userMagHeading;
    }

    @Override
    public Float getMagVariation() {
        if (this.userTrueHeading == null || this.userMagHeading == null) {
            return null;
        }
        float res = this.userTrueHeading.floatValue() - this.userMagHeading.floatValue();
        if (res < -150.0f) {
            res += 360.0f;
        } else if (res > 150.0f) {
            res -= 360.0f;
        }
        return Float.valueOf(res);
    }

    public void setUserMagHeading(Float userMagHeading) {
        this.userMagHeading = userMagHeading;
    }

    @Override
    public Float getUserAltAboveTerrain() {
        return this.userAltAboveTerrain;
    }

    public void setUserAltAboveTerrain(Float userAltAboveTerrain) {
        this.userAltAboveTerrain = userAltAboveTerrain;
    }

    @Override
    public Float getUserVerticalSpeed() {
        return this.userVerticalSpeed;
    }

    public void setUserVerticalSpeed(Float userVerticalSpeed) {
        this.userVerticalSpeed = userVerticalSpeed;
    }

    @Override
    public Float getUserIndicatedSpeed() {
        return this.userIndicatedSpeed;
    }

    public void setUserIndicatedSpeed(Float userIndicatedSpeed) {
        this.userIndicatedSpeed = userIndicatedSpeed;
    }

    @Override
    public Float getUserPitch() {
        return this.userPitch;
    }

    public void setUserPitch(Float userPitch) {
        this.userPitch = userPitch;
    }

    @Override
    public Float getUserBank() {
        return this.userBank;
    }

    public void setUserBank(Float userBank) {
        this.userBank = userBank;
    }

    @Override
    public Float getgForce() {
        return this.gForce;
    }

    public void setgForce(Float gForce) {
        this.gForce = gForce;
    }

    @Override
    public Float getWindVelocity() {
        return this.windVelocity;
    }

    public void setWindVelocity(Float windVelocity) {
        this.windVelocity = windVelocity;
    }

    @Override
    public Float getWindDirection() {
        return this.windDirection;
    }

    public void setWindDirection(Float windDirection) {
        this.windDirection = windDirection;
    }

    @Override
    public Short getFlapsHandle() {
        return this.flapsHandle;
    }

    public void setFlapsHandle(Short flapsHandle) {
        this.flapsHandle = flapsHandle;
    }

    @Override
    public Float getYokeXPosition() {
        return this.yokeXPosition;
    }

    public void setYokeXPosition(Float yokeXPosition) {
        this.yokeXPosition = yokeXPosition;
    }

    @Override
    public Float getYokeYPosition() {
        return this.yokeYPosition;
    }

    public void setYokeYPosition(Float yokeYPosition) {
        this.yokeYPosition = yokeYPosition;
    }

    @Override
    public Float getRudderPeddalsPosition() {
        return this.rudderPeddalsPosition;
    }

    public void setRudderPeddalsPosition(Float rudderPeddalsPosition) {
        this.rudderPeddalsPosition = rudderPeddalsPosition;
    }

    @Override
    public boolean isOnGround() {
        return Boolean.TRUE.equals(this.onGround);
    }

    public void setOnGround(Boolean onGround) {
        this.onGround = onGround;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public float getGroundLevel() {
        return this.userAlt.floatValue() - this.userAltAboveTerrain.floatValue();
    }

    @Override
    public boolean isInside(GpsArea area) {
        return (double)this.userLat.floatValue() <= area.getMaxLat() && (double)this.userLat.floatValue() >= area.getMinLat() && (double)this.userLon.floatValue() >= area.getMinLon() && (double)this.userLon.floatValue() <= area.getMaxLon();
    }

    public String getInfo() {
        double groundAlt = 0.0;
        double amslAlt = this.userAlt.floatValue();
        if (!this.onGround.booleanValue()) {
            groundAlt = this.userAltAboveTerrain.floatValue();
        }
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            groundAlt = UnitUtil.recalculateAltitude(groundAlt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
            amslAlt = UnitUtil.recalculateAltitude(amslAlt, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false);
        }
        double ias = this.userIndicatedSpeed.floatValue();
        double gs = this.userGs.floatValue();
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            ias = UnitUtil.recalculateSpeed(ias, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
            gs = UnitUtil.recalculateSpeed(gs, "kt", SettingsBean.getInstance().getParamUnitsSpeed(), false);
        }
        String vSpeed = null;
        vSpeed = !"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude()) ? String.valueOf(UnitUtil.recalculateVerticalSpeed(this.userVerticalSpeed.floatValue(), "fpm", "m/s", true)) : String.valueOf(Math.round(this.userVerticalSpeed.floatValue()));
        StringBuilder builder = new StringBuilder();
        builder.append(Math.round(groundAlt));
        builder.append("/");
        builder.append(Math.round(amslAlt));
        builder.append(SettingsBean.getInstance().getParamUnitsAltitude() + ", ");
        builder.append(Math.round(ias));
        builder.append("/");
        builder.append(Math.round(gs));
        builder.append(SettingsBean.getInstance().getParamUnitsSpeed() + ", ");
        builder.append(vSpeed);
        builder.append("ft".equals(SettingsBean.getInstance().getParamUnitsAltitude()) ? "fpm" : "m/s");
        builder.append(" @ " + FormatUtil.formatTimestamp(this.timestamp));
        return builder.toString();
    }

    @Override
    public SimConnectBean clone() {
        SimConnectBean s = new SimConnectBean();
        s.setUserAlt(this.userAlt);
        s.setUserAltAboveTerrain(this.userAltAboveTerrain);
        s.setUserGs(this.userGs);
        s.setUserLat(this.userLat);
        s.setUserLon(this.userLon);
        s.setUserMagHeading(this.userMagHeading);
        s.setUserTrueHeading(this.userTrueHeading);
        s.setUserVerticalSpeed(this.userVerticalSpeed);
        s.setUserIndicatedSpeed(this.userIndicatedSpeed);
        s.setUserIndicatedAlt(this.userIndicatedAlt);
        s.setTimestamp(this.timestamp);
        s.setUserBank(this.userBank);
        s.setUserPitch(this.userPitch);
        s.setgForce(this.gForce);
        s.setFlapsHandle(this.flapsHandle);
        s.setRudderPeddalsPosition(this.rudderPeddalsPosition);
        s.setWindDirection(this.windDirection);
        s.setWindVelocity(this.windVelocity);
        s.setYokeXPosition(this.yokeXPosition);
        s.setYokeYPosition(this.yokeYPosition);
        s.setOnGround(this.onGround);
        s.setUserTas(this.userTas);
        s.setFps(this.fps);
        return s;
    }

    @Override
    public Float getUserTas() {
        return this.userTas;
    }

    public void setUserTas(Float userTas) {
        this.userTas = userTas;
    }

    @Override
    public GpsPlace getGpsPlace() {
        if (this.userLat == null || this.userLon == null) {
            return null;
        }
        if (this.userAlt == null) {
            return this.GpsPlace(this.userLat, this.userLon);
        }
        return new GpsPlace(this.userLat.floatValue(), this.userLon.floatValue(), this.userAlt.floatValue());
    }

    private GpsPlace GpsPlace(Float userLat2, Float userLon2) {
        return null;
    }

    @Override
    public boolean hasData() {
        return this.getUserLat() != null && this.getUserLon() != null;
    }

    @Override
    public Float getFps() {
        return this.fps;
    }

    public void setFps(Float fps) {
        this.fps = fps;
    }
}

