/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.DrawShapeModeBean;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.JvmParamsBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.RecentList;
import main.java.guru.vfrflight.bean.auth.ProxyBean;
import main.java.guru.vfrflight.bean.combo.item.StringComboBoxItem;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.bean.theme.ColorTheme;
import main.java.guru.vfrflight.bean.theme.DefaultColorTheme;
import main.java.guru.vfrflight.bean.theme.airspace.AirspaceThemeFactory;
import main.java.guru.vfrflight.bean.theme.airspace.AirspacesColorTheme;
import main.java.guru.vfrflight.core.EngineLossBean;
import main.java.guru.vfrflight.core.PlaneProfile;
import main.java.guru.vfrflight.core.RouteCreatorBean;
import main.java.guru.vfrflight.core.SimConnectConfigBean;
import main.java.guru.vfrflight.core.TerrainLayerBean;
import main.java.guru.vfrflight.core.VerticalProfileBean;
import main.java.guru.vfrflight.core.WnBProfile;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.type.AirspaceType;
import main.java.guru.vfrflight.gui.flightplan.HintDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.connect.SimulatorVersion;
import main.java.guru.vfrflight.gui.task.api.ExtConnectTask;
import main.java.guru.vfrflight.helper.DropboxHelper;
import main.java.guru.vfrflight.helper.DropboxHelperImpl;
import main.java.guru.vfrflight.pdf.sections.type.PdfSectionType;
import main.java.guru.vfrflight.sql.facade.ParamFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.PlaneProfileUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.WnBProfileUtil;
import main.java.guru.vfrflight.util.bean.FlightGearConnectConfigBean;
import main.java.guru.vfrflight.util.bean.FsxP3DConnectConfigBean;
import main.java.guru.vfrflight.util.bean.HgtZipFilesMapping;
import main.java.guru.vfrflight.util.bean.PdfConfigBean;
import main.java.guru.vfrflight.util.bean.XPConnectConfigBean;
import main.java.guru.vfrflight.util.geo.DeclinationCalculator;
import main.java.guru.vfrflight.util.geo.FsxP3DCalculator;
import main.java.guru.vfrflight.util.geo.RealWorldCalculator;
import main.java.guru.vfrflight.weather.core.Station;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class SettingsBean
implements Serializable {
    private static final long serialVersionUID = -1058333638796660199L;
    private static final Logger log = Logger.getLogger(SettingsBean.class);
    private String fileOpenPath = ".";
    private String flightPlansPath = ".";
    private String vfrFilesPath = ".";
    private String pdfFilesPath = ".";
    private boolean htmlResultForceChromeBackgroundColorsPrint = true;
    private boolean htmlResultOpenInBrowserAfterExport = true;
    private boolean showGpsCoordsAsNumericValues = true;
    private int paramLanguage = 1;
    private int paramUndoHistorySize = 5;
    private String paramLookAndFeel = null;
    private String paramUnitsDistance = "nm";
    private String paramUnitsSpeed = "kt";
    private String paramUnitsWindSpeed = "kt";
    private String paramUnitsAltitude = "ft";
    private String paramUnitsFuel = "l";
    private boolean paramGpsMapOverlay = true;
    private boolean paramThreeRowsLayout = false;
    private boolean paramShowWarnings = true;
    private boolean paramShowScaleOnMap = true;
    private boolean paramShowWelcomeScreen = true;
    private boolean paramShowTermsOfUseScreen = true;
    private boolean paramGEExportStickyToTerrain = true;
    private boolean paramIncludeSecondsInTimeCalculations = true;
    private boolean paramUseMapDecimalCoords = false;
    private int paramSidePanelWidth = 615;
    private boolean paramFirstRun = true;
    private Point initMapFramePosition;
    private boolean initMapFrameFullScreen = true;
    private Dimension initMapFrameSize;
    private Integer initMapZoom;
    private Integer initMapType;
    private GeoPosition initMapPosition;
    private int paramMapRegionSelected = 0;
    private RecentList<String> recentLoadedFiles = new RecentList(10);
    private String paramCities1000Url = "http://download.geonames.org/export/dump/cities1000.zip";
    private String paramNavaidsUrl = "http://www.ourairports.com/data/navaids.csv";
    private String paramAirportsUrl = "http://www.ourairports.com/data/airports.csv";
    private Date paramLastUpdateCheck = null;
    private String trueTrackPrefix = null;
    private String magTrackPrefix = null;
    private String magHdgPrefix = null;
    private List<PlaneProfile> planeProfiles = null;
    private List<WnBProfile> wnbProfiles = null;
    private ColorTheme colorTheme = new DefaultColorTheme();
    private String paramAirspacesColorTheme = "OPEN_AIP";
    private AirspacesColorTheme airspacesColorTheme;
    private String measurementLineDistanceUnit = "nm";
    private boolean offlineMode = false;
    private boolean stickyMode = true;
    private boolean drawAllVors = true;
    private boolean drawRadialsFromVors = false;
    private boolean drawElevations = true;
    private boolean drawTerrainElevations = false;
    private boolean drawMeteoImageMesh = true;
    private boolean drawMagneticDeclinations = false;
    private boolean drawAllIls = true;
    private boolean drawAirportTaxiways = true;
    private boolean showOnlyEnrouteIls = false;
    private boolean drawAllNdbs = true;
    private boolean drawCities = false;
    private boolean drawObstacles = true;
    private boolean drawAllAirports = true;
    private boolean drawRunwayExtensions = false;
    private boolean drawVfrPoints = true;
    private boolean drawAllUserPoints = true;
    private boolean drawAllIfrPoints = false;
    private boolean drawAllIfrRoutes = false;
    private boolean drawMapGrid = false;
    private boolean drawTextLabels = true;
    private Double textLabelsRotationAngle = null;
    private boolean drawAirspacesListUnderCursor = false;
    private boolean drawAirspacesIds = false;
    private boolean drawMapObjectsListUnderCursor = false;
    private boolean drawUserTrack = true;
    private boolean drawWeather = true;
    private boolean drawAirspaces = true;
    private boolean drawAirspaceReservations = true;
    private boolean paramMapMouseGoogleStyle = true;
    private boolean paramFsxP3dMode = false;
    private boolean paramImportMagvarShowWarning = true;
    private int mapMouseMove = this.paramMapMouseGoogleStyle ? 16 : 8;
    private int mapMouseMeasurementLine = this.paramMapMouseGoogleStyle ? 8 : 16;
    private PdfConfigBean pdfConfigBean = new PdfConfigBean();
    private XPConnectConfigBean xpConnectConfigBean = new XPConnectConfigBean();
    private FsxP3DConnectConfigBean fsxP3DConnectConfigBean = new FsxP3DConnectConfigBean();
    private FlightGearConnectConfigBean flightGearConnectConfigBean = new FlightGearConnectConfigBean();
    private ProxyBean proxyBean = new ProxyBean();
    private boolean paramUseProxy = false;
    private int[] mapPriority = Constants.DEFAULT_MAP_PRIORITY;
    private Map<Integer, Integer> mapPriorities;
    private ExtConnectTask extConnectTask;
    private boolean followUserPosition = false;
    private TerrainLayerBean terrainLayerBean = new TerrainLayerBean();
    private VerticalProfileBean verticalProfileBean = new VerticalProfileBean();
    private EngineLossBean engineLossBean = new EngineLossBean();
    private Color[] colorsPalette;
    private Color[] grayPalette;
    private GpsArea mapObjectsUserRegion = null;
    private DrawShapeModeBean drawShapeModeBean = new DrawShapeModeBean();
    private volatile SimConnectConfigBean simConnectConfigBean = new SimConnectConfigBean();
    private int renderingHintsQuality = 0;
    private JvmParamsBean jvmParamsBean;
    private Level consoleLogLevel = Level.ERROR;
    private Level fileLogLevel = Level.ERROR;
    private boolean calculateRouteInRealTime = true;
    private boolean paramUseMultipleCores = true;
    private boolean showVor = true;
    private boolean showWindSock = true;
    private boolean showCrsAndDist = true;
    private int routeFontSizeModificator = 0;
    private boolean[] hintsDontShow = new boolean[HintDialog.HINT_TEXT.length];
    private DropboxHelper dropboxBean = new DropboxHelperImpl();
    private HgtZipFilesMapping[] hgtZipFilesMappings = ElevationsUtil.readHgtZipFilesMappings();
    private boolean touchScreenMode = false;
    private boolean appExportAvailable = false;
    private final Map<String, List<Station>> weatherCache = new HashMap<String, List<Station>>();
    private boolean drawLandmarkLabels = true;
    private boolean showMapRadials = true;
    private boolean drawDirectionArrows = false;
    private final RouteCreatorBean routeCreatorBean = new RouteCreatorBean();
    private static volatile SettingsBean instance = null;
    private DeclinationCalculator fsxP3DDeclCalc = new FsxP3DCalculator();
    private DeclinationCalculator realDeclCalc = new RealWorldCalculator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SettingsBean getInstance() {
        if (instance != null) return instance;
        Class<SettingsBean> clazz = SettingsBean.class;
        synchronized (SettingsBean.class) {
            if (instance != null) return instance;
            instance = new SettingsBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Date getParamLastUpdateCheck() {
        return this.paramLastUpdateCheck;
    }

    public void setParamLastUpdateCheck(Date paramLastUpdateCheck) {
        this.paramLastUpdateCheck = paramLastUpdateCheck;
    }

    public String getParamAirportsUrl() {
        return this.paramAirportsUrl;
    }

    public void setParamAirportsUrl(String paramAirportsUrl) {
        this.paramAirportsUrl = paramAirportsUrl;
    }

    public String getParamNavaidsUrl() {
        return this.paramNavaidsUrl;
    }

    public void setParamNavaidsUrl(String paramNavaidsUrl) {
        this.paramNavaidsUrl = paramNavaidsUrl;
    }

    public String getParamCities1000Url() {
        return this.paramCities1000Url;
    }

    public void setParamCities1000Url(String paramCities1000Url) {
        this.paramCities1000Url = paramCities1000Url;
    }

    public boolean isHtmlResultForceChromeBackgroundColorsPrint() {
        return this.htmlResultForceChromeBackgroundColorsPrint;
    }

    public void setHtmlResultForceChromeBackgroundColorsPrint(boolean htmlResultForceChromeBackgroundColorsPrint) {
        this.htmlResultForceChromeBackgroundColorsPrint = htmlResultForceChromeBackgroundColorsPrint;
    }

    public boolean isHtmlResultOpenInBrowserAfterExport() {
        return this.htmlResultOpenInBrowserAfterExport;
    }

    public void setHtmlResultOpenInBrowserAfterExport(boolean htmlResultOpenInBrowserAfterExport) {
        this.htmlResultOpenInBrowserAfterExport = htmlResultOpenInBrowserAfterExport;
    }

    public boolean isShowGpsCoordsAsNumericValues() {
        return this.showGpsCoordsAsNumericValues;
    }

    public void setShowGpsCoordsAsNumericValues(boolean showGpsCoordsAsNumericValues) {
        this.showGpsCoordsAsNumericValues = showGpsCoordsAsNumericValues;
    }

    public String getFileOpenPath() {
        return this.fileOpenPath;
    }

    public void setFileOpenPath(String fileOpenPath) {
        this.fileOpenPath = fileOpenPath;
    }

    public void loadParams() {
        Properties props = new Properties();
        InputStream is = null;
        File f = new File("settings.properties");
        try {
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            is = null;
        }
        if (is == null) {
            is = this.getClass().getResourceAsStream("settings.properties");
        }
        try {
            if (is != null) {
                props.load(is);
            }
            try {
                this.paramLanguage = Integer.valueOf(props.getProperty("language", String.valueOf(1)));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value paramLanguage");
            }
            try {
                this.paramMapRegionSelected = Integer.valueOf(props.getProperty("mapRegionSelected", "0"));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value paramMapRegionSelected");
            }
            this.touchScreenMode = !"false".equals(props.getProperty("touchScreenMode", "false"));
            this.flightPlansPath = props.getProperty("flightPlansPath");
            this.vfrFilesPath = props.getProperty("vfrFilesPath");
            this.pdfFilesPath = props.getProperty("pdfFilesPath");
            this.paramLookAndFeel = props.getProperty("lookAndFeel");
            this.paramAirspacesColorTheme = props.getProperty("airspacesColorTheme", "OPEN_AIP");
            this.airspacesColorTheme = AirspaceThemeFactory.createTheme(this.paramAirspacesColorTheme);
            this.paramUnitsDistance = props.getProperty("unitsDistance", "nm");
            this.paramUnitsSpeed = props.getProperty("unitsSpeed", "kt");
            this.paramUnitsWindSpeed = props.getProperty("unitsWindSpeed", "kt");
            this.paramUnitsAltitude = props.getProperty("unitsAltitude", "ft");
            this.paramUnitsFuel = props.getProperty("unitsFuel", "l");
            try {
                this.paramLastUpdateCheck = new SimpleDateFormat("yyyy-MM-dd").parse(props.getProperty("lastUpdateCheck", "2014-01-01"));
            }
            catch (ParseException e) {
                log.error("Couldn't parse date value paramLastUpdateCheck", e);
                try {
                    this.paramLastUpdateCheck = new SimpleDateFormat("yyyy-MM-dd").parse("2014-01-01");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            try {
                this.renderingHintsQuality = Integer.valueOf(props.getProperty("renderingQuality", String.valueOf(0)));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value renderingHintsQuality", e);
                this.renderingHintsQuality = 0;
            }
            Integer recentLoadedFilesNum = null;
            try {
                recentLoadedFilesNum = Integer.valueOf(props.getProperty("recentLoadedFilesNum", "0"));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value recentLoadedFilesNum", e);
            }
            if (recentLoadedFilesNum != null && recentLoadedFilesNum > 0) {
                for (int i = 1; i <= recentLoadedFilesNum; ++i) {
                    this.recentLoadedFiles.add(props.getProperty("recentLoadedFile." + i, ""));
                }
            }
            this.paramGpsMapOverlay = !"false".equals(props.getProperty("showGpsMapOverlay", "true"));
            this.paramThreeRowsLayout = !"false".equals(props.getProperty("threeRowsLayout", "false"));
            this.paramShowScaleOnMap = !"false".equals(props.getProperty("showScaleOnMap", "true"));
            this.paramShowWarnings = !"false".equals(props.getProperty("showWarnings", "true"));
            this.paramShowWelcomeScreen = !"false".equals(props.getProperty("showWelcomeScreen", "true"));
            this.paramShowTermsOfUseScreen = !"false".equals(props.getProperty("showTermsOfUseScreen", "true"));
            this.paramGEExportStickyToTerrain = !"false".equals(props.getProperty("geExportStickyToTerrain", "true"));
            this.paramIncludeSecondsInTimeCalculations = !"false".equals(props.getProperty("includeSecondsInTimeCalculations", "false"));
            this.paramUseMapDecimalCoords = !"false".equals(props.getProperty("useMapDecimalCoords", "false"));
            this.paramUseMultipleCores = !"false".equals(props.getProperty("useMultipleCores", "true"));
            this.setParamMapMouseGoogleStyle(!"false".equals(props.getProperty("mapMouseGoogleStyle", "true")));
            this.setParamFsxP3dMode(!"false".equals(props.getProperty("fsxP3DMode", "false")));
            this.setParamImportMagvarShowWarning(!"false".equals(props.getProperty("importMagvarShowWarning", "true")));
            this.pdfConfigBean.setHalfSize(!"false".equals(props.getProperty("pdfHalfSize", "false")));
            this.pdfConfigBean.setIncludeEta(!"false".equals(props.getProperty("pdfIncludeEta", "true")));
            this.pdfConfigBean.setIncludeFilledEta(!"false".equals(props.getProperty("pdfIncludeFilledEta", "true")));
            this.pdfConfigBean.setIncludeEmptyAta(!"false".equals(props.getProperty("pdfIncludeEmptyAta", "true")));
            this.pdfConfigBean.setIncludeLandmarksInCalculationResults(!"false".equals(props.getProperty("pdfIncludeLandmarksInCalcResults", "true")));
            this.pdfConfigBean.setIncludeVorRadialsInCalculationResults(!"false".equals(props.getProperty("pdfIncludeVorRadialsInCalcResults", "false")));
            this.pdfConfigBean.setOneMapPerLegDrawVorRadials(!"false".equals(props.getProperty("pdfOneMapPerLegDrawVorRadials", "true")));
            this.pdfConfigBean.setOneMapPerLegDrawWind(!"false".equals(props.getProperty("pdfOneMapPerLegDrawWind", "true")));
            this.pdfConfigBean.setOneMapPerLegIncludeVorRadialsTable(!"false".equals(props.getProperty("pdfOneMapPerLegIncludeVorRadialsTable", "true")));
            this.xpConnectConfigBean.setLocalhost(!"false".equals(props.getProperty("xpcLocalhost", "true")));
            this.xpConnectConfigBean.setXplaneIp(props.getProperty("xpcIp"));
            this.xpConnectConfigBean.setXplaneMainDir(props.getProperty("xpcXplaneMainDir"));
            try {
                this.xpConnectConfigBean.setXplanePort(Integer.valueOf(props.getProperty("xpcPort")));
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
            this.fsxP3DConnectConfigBean.setLocalhost(!"false".equals(props.getProperty("fsxP3DcLocalhost", "true")));
            this.fsxP3DConnectConfigBean.setIp(props.getProperty("fsxP3DcIp"));
            this.fsxP3DConnectConfigBean.setRemoteIp(props.getProperty("fsxP3DcRemoteIp"));
            if (props.getProperty("fsxP3DcSimVer") != null) {
                this.fsxP3DConnectConfigBean.setSimulatorVersion(SimulatorVersion.valueOf(props.getProperty("fsxP3DcSimVer")));
            }
            try {
                this.fsxP3DConnectConfigBean.setPort(Integer.valueOf(props.getProperty("fsxP3DcPort")));
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
            if (props.getProperty("pdfSections", null) != null) {
                ArrayList<PdfSectionType> typesList = new ArrayList<PdfSectionType>();
                String txt = props.getProperty("pdfSections", "");
                String[] txtSplit = txt.split(",");
                for (int i = 0; i < txtSplit.length; ++i) {
                    if (StringUtil.isEmpty(txtSplit[i])) continue;
                    try {
                        typesList.add(PdfSectionType.valueOf(txtSplit[i]));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid pdfSections pdf section type [" + txtSplit[i] + "]", e);
                    }
                }
                this.pdfConfigBean.setLayout(typesList);
            }
            boolean bl = this.paramUseProxy = !"false".equals(props.getProperty("useProxy", "false"));
            if (this.paramUseProxy) {
                this.proxyBean.setHttpHost(props.getProperty("proxyHost"));
                try {
                    this.proxyBean.setHttpPort(Integer.valueOf(props.getProperty("proxyPort")));
                }
                catch (NumberFormatException e) {
                    log.error("Couldn't parse int value proxyPort", e);
                }
                String username = props.getProperty("proxyUser");
                String password = props.getProperty("proxyPassword");
                if (username != null && password != null) {
                    this.proxyBean.setHttpUserName(username);
                    this.proxyBean.setHttpPassword(password);
                }
                this.proxyBean.setGlobalProxy();
            }
            this.getSimConnectConfigBean().setMixtureLean(!"false".equals(props.getProperty("scEngFailMixtureLean", "true")));
            this.getSimConnectConfigBean().setThrottleCutOff(!"false".equals(props.getProperty("scEngFailThrottleCutOff", "true")));
            this.getSimConnectConfigBean().setTraceUserPosition(!"false".equals(props.getProperty("scTraceUserPosition", "true")));
            this.getSimConnectConfigBean().setSaveUserTrack(!"false".equals(props.getProperty("scSaveUserTrack", "true")));
            this.getSimConnectConfigBean().setGetFps(!"false".equals(props.getProperty("scSaveFps", "false")));
            this.getSimConnectConfigBean().setTraceTraffic(!"false".equals(props.getProperty("scShowAiTraffic", "true")));
            this.getSimConnectConfigBean().setTrafficShowOnlyInAir(!"false".equals(props.getProperty("scShowAiTrafficOnlyInTheAir", "true")));
            this.getSimConnectConfigBean().setTrafficShowOnlyIn2kAltitudeRange(!"false".equals(props.getProperty("scShowAiTrafficOnlyWithinAltRange", "false")));
            if (props.getProperty("scAiTrafficRadius") != null) {
                try {
                    this.getSimConnectConfigBean().setTrafficRadius(Integer.valueOf(props.getProperty("scAiTrafficRadius")));
                }
                catch (NumberFormatException e) {
                    log.error("Couldn't parse int value scAiTrafficRadius", e);
                }
            }
            this.getSimConnectConfigBean().setIntervalBoostAtLowAlt(!"false".equals(props.getProperty("scIntervalBoost", "false")));
            try {
                this.getSimConnectConfigBean().setProbability(Integer.valueOf(props.getProperty("scEngFailProbability", "0")));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value scEngFailProbability", e);
            }
            try {
                this.getSimConnectConfigBean().setInterval(Integer.valueOf(props.getProperty("scInterval", "1000")));
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value scInterval", e);
            }
            this.initMapFrameFullScreen = !"false".equals(props.getProperty("initMapFrameFullScreen", "true"));
            try {
                String x = props.getProperty("initMapFramePositionX", null);
                String y = props.getProperty("initMapFramePositionY", null);
                if (x != null && y != null) {
                    Point p = new Point();
                    p.setLocation(Double.valueOf(x), Double.valueOf(y));
                    this.initMapFramePosition = p;
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value initMapFramePosition", e);
            }
            try {
                String width = props.getProperty("initMapFrameWidth", null);
                String height = props.getProperty("initMapFrameHeight", null);
                if (width != null && height != null) {
                    this.initMapFrameSize = new Dimension(Integer.valueOf(width), Integer.valueOf(height));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value initMapFrameSize", e);
            }
            try {
                if (props.getProperty("initMapZoom", null) != null) {
                    this.initMapZoom = Integer.valueOf(props.getProperty("initMapZoom", null));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value initMapZoom", e);
            }
            try {
                if (props.getProperty("initMapType", null) != null) {
                    this.initMapType = Integer.valueOf(props.getProperty("initMapType", null));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value initMapType", e);
            }
            try {
                String lat = props.getProperty("initMapLat", null);
                String lon = props.getProperty("initMapLon", null);
                if (lat != null && lon != null) {
                    this.initMapPosition = new GeoPosition(Double.valueOf(lat), Double.valueOf(lon));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value initMapPosition", e);
            }
            String mapPriorities = props.getProperty("mapPriorities");
            if (mapPriorities != null) {
                try {
                    String[] spl = mapPriorities.split(",");
                    for (int i = 0; i < spl.length; ++i) {
                        this.mapPriority[i] = Integer.valueOf(spl[i]);
                    }
                    this.calculateMapPriorities();
                }
                catch (NumberFormatException e) {
                    log.error("Couldn't parse int value for mapPriorities", e);
                }
            }
            try {
                if (props.getProperty("optimalElevationsNumber", null) != null) {
                    this.getTerrainLayerBean().setOptimalElevationsNum(Integer.valueOf(props.getProperty("optimalElevationsNumber", null)));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value optimalElevationsNumber", e);
            }
            if (props.getProperty("pathToHgtFiles", null) != null) {
                this.getTerrainLayerBean().setPathToHgtFiles(props.getProperty("pathToHgtFiles", null));
            }
            if (props.getProperty("paramNameSidePanelWidth", null) != null) {
                try {
                    this.paramSidePanelWidth = Integer.valueOf(props.getProperty("paramNameSidePanelWidth", null));
                }
                catch (NumberFormatException e) {
                    log.error("Couldn't parse int value for paramSidePanelWidth", e);
                }
            }
            try {
                if (props.getProperty("optimalDistance", null) != null) {
                    this.getVerticalProfileBean().setOptimalDistance(Double.valueOf(props.getProperty("optimalDistance", null)));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse int value optimalDistance", e);
            }
            try {
                String[] split;
                if (props.getProperty("mapObjectsUserRegion", null) != null && (split = props.getProperty("mapObjectsUserRegion", null).split(";")).length == 4) {
                    double maxLat = Double.valueOf(split[0]);
                    double minLon = Double.valueOf(split[1]);
                    double minLat = Double.valueOf(split[2]);
                    double maxLon = Double.valueOf(split[3]);
                    this.mapObjectsUserRegion = new GpsArea(new GpsPlace(maxLat, minLon), new GpsPlace(minLat, maxLon));
                }
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse values for mapObjectsUserRegion", e);
            }
            if (this.mapObjectsUserRegion == null && this.paramMapRegionSelected == 1) {
                this.paramMapRegionSelected = 0;
            }
            if (props.getProperty("mapDisplayShowTextLabels", null) != null) {
                this.setDrawTextLabels(!"false".equals(props.getProperty("mapDisplayShowTextLabels", "true")));
            }
            if (props.getProperty("mapDisplayShowAllVors", null) != null) {
                this.setDrawAllVors(!"false".equals(props.getProperty("mapDisplayShowAllVors", "true")));
            }
            if (props.getProperty("mapDisplayShowAllNdbs", null) != null) {
                this.setDrawAllNdbs(!"false".equals(props.getProperty("mapDisplayShowAllNdbs", "true")));
            }
            if (props.getProperty("mapDisplayShowAllAirports", null) != null) {
                this.setDrawAllAirports(!"false".equals(props.getProperty("mapDisplayShowAllAirports", "true")));
            }
            if (props.getProperty("mapDisplayShowRunwayExtensions", null) != null) {
                this.setDrawRunwayExtensions(!"false".equals(props.getProperty("mapDisplayShowRunwayExtensions", "true")));
            }
            if (props.getProperty("mapDisplayShowAirportsTaxiways", null) != null) {
                this.setDrawAirportTaxiways(!"false".equals(props.getProperty("mapDisplayShowAirportsTaxiways", "true")));
            }
            if (props.getProperty("mapDisplayShowAllIls", null) != null) {
                this.setDrawAllIls(!"false".equals(props.getProperty("mapDisplayShowAllIls", "true")));
            }
            if (props.getProperty("mapDisplayShowElevations", null) != null) {
                this.setDrawElevations(!"false".equals(props.getProperty("mapDisplayShowElevations", "true")));
            }
            if (props.getProperty("mapDisplayShowTerrainElevations", null) != null) {
                this.setDrawTerrainElevations(!"false".equals(props.getProperty("mapDisplayShowTerrainElevations", "false")));
            }
            if (props.getProperty("mapDisplayShowMagneticDeclinations", null) != null) {
                this.setDrawMagneticDeclinations(!"false".equals(props.getProperty("mapDisplayShowMagneticDeclinations", "false")));
            }
            if (props.getProperty("mapDisplayShowAirspaces", null) != null) {
                this.setDrawAirspaces(!"false".equals(props.getProperty("mapDisplayShowAirspaces", "true")));
            }
            if (props.getProperty("mapDisplayShowVfrPoints", null) != null) {
                this.setDrawVfrPoints(!"false".equals(props.getProperty("mapDisplayShowVfrPoints", "true")));
            }
            if (props.getProperty("mapDisplayShowIfrPoints", null) != null) {
                this.setDrawAllIfrPoints(!"false".equals(props.getProperty("mapDisplayShowIfrPoints", "true")));
            }
            if (props.getProperty("mapDisplayShowIfrRoutes", null) != null) {
                this.setDrawAllIfrRoutes(!"false".equals(props.getProperty("mapDisplayShowIfrRoutes", "true")));
            }
            if (props.getProperty("mapDisplayShowAllUserPoints", null) != null) {
                this.setDrawAllUserPoints(!"false".equals(props.getProperty("mapDisplayShowAllUserPoints", "true")));
            }
            if (props.getProperty("mapDisplayShowUserTrack", null) != null) {
                this.setDrawUserTrack(!"false".equals(props.getProperty("mapDisplayShowUserTrack", "true")));
            }
            if (props.getProperty("mapDisplayShowMapGrid", null) != null) {
                this.setDrawMapGrid(!"false".equals(props.getProperty("mapDisplayShowMapGrid", "true")));
            }
            if (props.getProperty("mapDisplayShowWeather", null) != null) {
                this.setDrawWeather(!"false".equals(props.getProperty("mapDisplayShowWeather", "true")));
            }
            if (props.getProperty("mapDisplayShowObstacles", null) != null) {
                this.setDrawObstacles(!"false".equals(props.getProperty("mapDisplayShowObstacles", "true")));
            }
            if (props.getProperty("mapDisplayShowCities", null) != null) {
                this.setDrawCities(!"false".equals(props.getProperty("mapDisplayShowCities", "true")));
            }
            if (props.getProperty("mapDisplayDontDrawAirspacesList", null) != null) {
                HashSet<AirspaceType> airspaceTypesList = new HashSet<AirspaceType>();
                String txt = props.getProperty("mapDisplayDontDrawAirspacesList", "");
                String[] txtSplit = txt.split(",");
                for (int i = 0; i < txtSplit.length; ++i) {
                    if (StringUtil.isEmpty(txtSplit[i])) continue;
                    try {
                        airspaceTypesList.add(AirspaceType.valueOf(txtSplit[i]));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Invalid mapDisplayDontDrawAirspacesList airspace type [" + txtSplit[i] + "]", e);
                    }
                }
                MapObjectsBean.getInstance().getAirspaceFilter().setDontDrawAirspacesList(airspaceTypesList);
            }
            this.paramFirstRun = !"false".equals(props.getProperty("firstRun", "true"));
            this.jvmParamsBean = VfrUtil.readLaunch4jIni();
            for (int i = 0; i < this.hintsDontShow.length; ++i) {
                if (props.getProperty(HintDialog.HINT_TEXT[i], null) == null) continue;
                this.hintsDontShow[i] = "true".equals(props.getProperty(HintDialog.HINT_TEXT[i], null));
            }
        }
        catch (IOException e) {
            log.error("Couldn't load properties file", e);
        }
        this.planeProfiles = PlaneProfileUtil.loadProfiles("conf/profiles.xml");
        this.wnbProfiles = WnBProfileUtil.loadProfiles("conf/wnbs.xml");
    }

    public void saveParams() {
        Properties props = new Properties();
        if (this.getFlightPlansPath() != null) {
            props.setProperty("flightPlansPath", this.getFlightPlansPath());
        }
        if (this.getVfrFilesPath() != null) {
            props.setProperty("vfrFilesPath", this.getVfrFilesPath());
        }
        if (this.getPdfFilesPath() != null) {
            props.setProperty("pdfFilesPath", this.getPdfFilesPath());
        }
        props.setProperty("initMapFrameFullScreen", MapFrame.getInstance().isFullScreen() ? "true" : "false");
        props.setProperty("initMapFramePositionX", String.valueOf(MapFrame.getInstance().getLocation().getX()));
        props.setProperty("initMapFramePositionY", String.valueOf(MapFrame.getInstance().getLocation().getY()));
        props.setProperty("initMapFrameWidth", String.valueOf((int)MapFrame.getInstance().getSize().getWidth()));
        props.setProperty("initMapFrameHeight", String.valueOf((int)MapFrame.getInstance().getSize().getHeight()));
        props.setProperty("initMapZoom", String.valueOf(MapFrame.getInstance().getMapViewer().getZoom()));
        props.setProperty("initMapType", String.valueOf(MapFrame.getInstance().getMapTypeIndex()));
        props.setProperty("initMapLat", String.valueOf(MapFrame.getInstance().getMapViewer().getCenterPosition().getLatitude()));
        props.setProperty("initMapLon", String.valueOf(MapFrame.getInstance().getMapViewer().getCenterPosition().getLongitude()));
        props.setProperty("language", String.valueOf(this.paramLanguage));
        props.setProperty("mapRegionSelected", String.valueOf(this.paramMapRegionSelected));
        props.setProperty("unitsDistance", this.paramUnitsDistance);
        props.setProperty("unitsSpeed", this.paramUnitsSpeed);
        props.setProperty("unitsWindSpeed", this.paramUnitsWindSpeed);
        props.setProperty("unitsAltitude", this.paramUnitsAltitude);
        props.setProperty("unitsFuel", this.paramUnitsFuel);
        props.setProperty("renderingQuality", String.valueOf(this.renderingHintsQuality));
        props.setProperty("lastUpdateCheck", new SimpleDateFormat("yyyy-MM-dd").format(this.paramLastUpdateCheck));
        props.setProperty("airspacesColorTheme", this.paramAirspacesColorTheme);
        if (this.paramLookAndFeel != null) {
            props.setProperty("lookAndFeel", this.paramLookAndFeel);
        }
        props.setProperty("recentLoadedFilesNum", String.valueOf(this.recentLoadedFiles.size()));
        for (int i = 0; i < this.recentLoadedFiles.size(); ++i) {
            props.setProperty("recentLoadedFile." + (i + 1), (String)this.recentLoadedFiles.get(i));
        }
        props.setProperty("showGpsMapOverlay", this.paramGpsMapOverlay ? "true" : "false");
        props.setProperty("threeRowsLayout", this.paramThreeRowsLayout ? "true" : "false");
        props.setProperty("showScaleOnMap", this.paramShowScaleOnMap ? "true" : "false");
        props.setProperty("showWarnings", this.paramShowWarnings ? "true" : "false");
        props.setProperty("showWelcomeScreen", this.paramShowWelcomeScreen ? "true" : "false");
        props.setProperty("showTermsOfUseScreen", this.paramShowTermsOfUseScreen ? "true" : "false");
        props.setProperty("geExportStickyToTerrain", this.paramGEExportStickyToTerrain ? "true" : "false");
        props.setProperty("useMapDecimalCoords", this.paramUseMapDecimalCoords ? "true" : "false");
        props.setProperty("useMultipleCores", this.paramUseMultipleCores ? "true" : "false");
        props.setProperty("includeSecondsInTimeCalculations", this.paramIncludeSecondsInTimeCalculations ? "true" : "false");
        props.setProperty("mapMouseGoogleStyle", this.paramMapMouseGoogleStyle ? "true" : "false");
        props.setProperty("fsxP3DMode", this.paramFsxP3dMode ? "true" : "false");
        props.setProperty("importMagvarShowWarning", this.paramImportMagvarShowWarning ? "true" : "true");
        props.setProperty("pdfHalfSize", this.pdfConfigBean.isHalfSize() ? "true" : "false");
        props.setProperty("pdfIncludeEmptyAta", this.pdfConfigBean.isIncludeEmptyAta() ? "true" : "false");
        props.setProperty("pdfIncludeEta", this.pdfConfigBean.isIncludeEta() ? "true" : "false");
        props.setProperty("pdfIncludeFilledEta", this.pdfConfigBean.isIncludeFilledEta() ? "true" : "false");
        props.setProperty("pdfIncludeLandmarksInCalcResults", this.pdfConfigBean.isIncludeLandmarksInCalculationResults() ? "true" : "false");
        props.setProperty("pdfIncludeVorRadialsInCalcResults", this.pdfConfigBean.isIncludeVorRadialsInCalculationResults() ? "true" : "false");
        props.setProperty("pdfOneMapPerLegDrawVorRadials", this.pdfConfigBean.isOneMapPerLegDrawVorRadials() ? "true" : "false");
        props.setProperty("pdfOneMapPerLegDrawWind", this.pdfConfigBean.isOneMapPerLegDrawWind() ? "true" : "false");
        props.setProperty("pdfOneMapPerLegIncludeVorRadialsTable", this.pdfConfigBean.isOneMapPerLegIncludeVorRadialsTable() ? "true" : "false");
        props.setProperty("xpcLocalhost", this.xpConnectConfigBean.isLocalhost() ? "true" : "false");
        props.setProperty("xpcIp", StringUtil.nullToEmpty(this.xpConnectConfigBean.getXplaneIp()));
        props.setProperty("xpcXplaneMainDir", StringUtil.nullToEmpty(this.xpConnectConfigBean.getXplaneMainDir()));
        props.setProperty("xpcPort", String.valueOf(this.xpConnectConfigBean.getXplanePort()));
        props.setProperty("fsxP3DcLocalhost", this.fsxP3DConnectConfigBean.isLocalhost() ? "true" : "false");
        props.setProperty("fsxP3DcIp", StringUtil.nullToEmpty(this.fsxP3DConnectConfigBean.getIp()));
        props.setProperty("fsxP3DcRemoteIp", StringUtil.nullToEmpty(this.fsxP3DConnectConfigBean.getRemoteIp()));
        props.setProperty("fsxP3DcPort", String.valueOf(this.fsxP3DConnectConfigBean.getPort()));
        props.setProperty("fsxP3DcSimVer", String.valueOf((Object)this.fsxP3DConnectConfigBean.getSimulatorVersion()));
        StringBuilder sb = new StringBuilder();
        for (PdfSectionType pdfSectionType : this.pdfConfigBean.getLayout()) {
            sb.append(pdfSectionType.toString());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        props.setProperty("pdfSections", sb.toString());
        props.setProperty("useProxy", this.paramUseProxy ? "true" : "false");
        if (this.paramUseProxy) {
            props.setProperty("proxyHost", this.proxyBean.getHttpHost());
            props.setProperty("proxyPort", String.valueOf(this.proxyBean.getHttpPort()));
            if (this.proxyBean.isUseHttpAuth()) {
                props.setProperty("proxyUser", this.proxyBean.getHttpUserName());
                props.setProperty("proxyPassword", this.proxyBean.getHttpPassword());
            }
        }
        props.setProperty("scEngFailMixtureLean", this.getSimConnectConfigBean().isMixtureLean() ? "true" : "false");
        props.setProperty("scEngFailThrottleCutOff", this.getSimConnectConfigBean().isThrottleCutOff() ? "true" : "false");
        props.setProperty("scTraceUserPosition", this.getSimConnectConfigBean().isTraceUserPosition() ? "true" : "false");
        props.setProperty("scEngFailProbability", String.valueOf(this.getSimConnectConfigBean().getProbability()));
        props.setProperty("scInterval", String.valueOf(this.getSimConnectConfigBean().getInterval()));
        props.setProperty("scSaveUserTrack", this.getSimConnectConfigBean().isSaveUserTrack() ? "true" : "false");
        props.setProperty("scSaveFps", this.getSimConnectConfigBean().isGetFps() ? "true" : "false");
        props.setProperty("scShowAiTraffic", this.getSimConnectConfigBean().isTraceTraffic() ? "true" : "false");
        props.setProperty("scShowAiTrafficOnlyInTheAir", this.getSimConnectConfigBean().isTrafficShowOnlyInAir() ? "true" : "false");
        props.setProperty("scShowAiTrafficOnlyWithinAltRange", this.getSimConnectConfigBean().isTrafficShowOnlyIn2kAltitudeRange() ? "true" : "false");
        if (this.getSimConnectConfigBean().getTrafficRadius() != null) {
            props.setProperty("scAiTrafficRadius", this.getSimConnectConfigBean().getTrafficRadius().toString());
        }
        props.setProperty("scIntervalBoost", this.getSimConnectConfigBean().isIntervalBoostAtLowAlt() ? "true" : "false");
        sb = new StringBuilder();
        for (int i = 0; i < this.getMapPriority().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getMapPriority()[i]);
        }
        props.setProperty("mapPriorities", sb.toString());
        props.setProperty("optimalElevationsNumber", String.valueOf(this.getTerrainLayerBean().getOptimalElevationsNum()));
        props.setProperty("optimalDistance", String.valueOf(this.getVerticalProfileBean().getOptimalDistance()));
        props.setProperty("pathToHgtFiles", this.getTerrainLayerBean().getPathToHgtFiles());
        if (this.mapObjectsUserRegion != null) {
            String txt = this.mapObjectsUserRegion.getMaxLat() + ";" + this.mapObjectsUserRegion.getMinLon() + ";" + this.mapObjectsUserRegion.getMinLat() + ";" + this.mapObjectsUserRegion.getMaxLon();
            props.setProperty("mapObjectsUserRegion", txt);
        }
        props.setProperty("mapDisplayShowTextLabels", this.isDrawTextLabels() ? "true" : "false");
        props.setProperty("mapDisplayShowAllVors", this.isDrawAllVors() ? "true" : "false");
        props.setProperty("mapDisplayShowAllNdbs", this.isDrawAllNdbs() ? "true" : "false");
        props.setProperty("mapDisplayShowAllAirports", this.isDrawAllAirports() ? "true" : "false");
        props.setProperty("mapDisplayShowRunwayExtensions", this.isDrawRunwayExtensions() ? "true" : "false");
        props.setProperty("mapDisplayShowAirportsTaxiways", this.isDrawAirportTaxiways() ? "true" : "false");
        props.setProperty("mapDisplayShowAllIls", this.isDrawAllIls() ? "true" : "false");
        props.setProperty("mapDisplayShowElevations", this.isDrawElevations() ? "true" : "false");
        props.setProperty("mapDisplayShowTerrainElevations", this.isDrawTerrainElevations() ? "true" : "false");
        props.setProperty("mapDisplayShowMagneticDeclinations", this.isDrawMagneticDeclinations() ? "true" : "false");
        props.setProperty("mapDisplayShowAirspaces", this.isDrawAirspaces() ? "true" : "false");
        props.setProperty("mapDisplayShowVfrPoints", this.isDrawVfrPoints() ? "true" : "false");
        props.setProperty("mapDisplayShowIfrPoints", this.isDrawAllIfrPoints() ? "true" : "false");
        props.setProperty("mapDisplayShowIfrRoutes", this.isDrawAllIfrRoutes() ? "true" : "false");
        props.setProperty("mapDisplayShowAllUserPoints", this.isDrawAllUserPoints() ? "true" : "false");
        props.setProperty("mapDisplayShowUserTrack", this.isDrawUserTrack() ? "true" : "false");
        props.setProperty("mapDisplayShowMapGrid", this.isDrawMapGrid() ? "true" : "false");
        props.setProperty("mapDisplayShowCities", this.isDrawCities() ? "true" : "false");
        props.setProperty("mapDisplayShowWeather", this.isDrawWeather() ? "true" : "false");
        props.setProperty("mapDisplayShowObstacles", this.isDrawObstacles() ? "true" : "false");
        props.setProperty("firstRun", this.isParamFirstRun() ? "true" : "false");
        sb = new StringBuilder();
        for (AirspaceType airspaceType : MapObjectsBean.getInstance().getAirspaceFilter().getDontDrawAirspacesList()) {
            sb.append(airspaceType.toString());
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        props.setProperty("mapDisplayDontDrawAirspacesList", sb.toString());
        for (int i = 0; i < this.hintsDontShow.length; ++i) {
            props.setProperty(HintDialog.HINT_TEXT[i], this.hintsDontShow[i] ? "true" : "false");
        }
        props.setProperty("touchScreenMode", this.isTouchScreenMode() ? "true" : "false");
        props.setProperty("paramNameSidePanelWidth", String.valueOf(this.paramSidePanelWidth));
        File f = new File("settings.properties");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            props.store(fileOutputStream, null);
        }
        catch (FileNotFoundException e) {
            log.error("Couldn't save param file", e);
        }
        catch (IOException e) {
            log.error("Couldn't save param file", e);
        }
    }

    public int getParamLanguage() {
        return this.paramLanguage;
    }

    public void setParamLanguage(int paramLanguage) {
        this.paramLanguage = paramLanguage;
    }

    public String getParamUnitsDistance() {
        return this.paramUnitsDistance;
    }

    public void setParamUnitsDistance(String paramUnitsDistance) {
        this.paramUnitsDistance = paramUnitsDistance;
    }

    public String getParamUnitsSpeed() {
        return this.paramUnitsSpeed;
    }

    public void setParamUnitsSpeed(String paramUnitsSpeed) {
        this.paramUnitsSpeed = paramUnitsSpeed;
    }

    public String getParamUnitsAltitude() {
        return this.paramUnitsAltitude;
    }

    public void setParamUnitsAltitude(String paramUnitsAltitude) {
        this.paramUnitsAltitude = paramUnitsAltitude;
    }

    public RecentList<String> getRecentLoadedFiles() {
        return this.recentLoadedFiles;
    }

    public void setRecentLoadedFiles(RecentList<String> recentLoadedFiles) {
        this.recentLoadedFiles = recentLoadedFiles;
    }

    public String getParamUnitsFuel() {
        return this.paramUnitsFuel;
    }

    public void setParamUnitsFuel(String paramUnitsFuel) {
        this.paramUnitsFuel = paramUnitsFuel;
    }

    public String getParamUnitsWindSpeed() {
        return this.paramUnitsWindSpeed;
    }

    public void setParamUnitsWindSpeed(String paramUnitsWindSpeed) {
        this.paramUnitsWindSpeed = paramUnitsWindSpeed;
    }

    public boolean isParamShowScaleOnMap() {
        return this.paramShowScaleOnMap;
    }

    public void setParamShowScaleOnMap(boolean paramShowScaleOnMap) {
        this.paramShowScaleOnMap = paramShowScaleOnMap;
    }

    public String getLanguageCode() {
        return Constants.LANGUAGE_CODES[this.paramLanguage];
    }

    public int getParamUndoHistorySize() {
        return this.paramUndoHistorySize;
    }

    public void setParamUndoHistorySize(int paramUndoHistorySize) {
        this.paramUndoHistorySize = paramUndoHistorySize;
    }

    public boolean isParamShowWelcomeScreen() {
        return this.paramShowWelcomeScreen;
    }

    public void setParamShowWelcomeScreen(boolean paramShowWelcomeScreen) {
        this.paramShowWelcomeScreen = paramShowWelcomeScreen;
    }

    public String getMagHdgPrefix() {
        if (this.magHdgPrefix == null) {
            this.setDefaultMagHdgPrefix();
        }
        return this.magHdgPrefix;
    }

    public String getMagTrackPrefix() {
        if (this.magTrackPrefix == null) {
            this.setDefaultMagTrackPrefix();
        }
        return this.magTrackPrefix;
    }

    public String getTrueTrackPrefix() {
        if (this.trueTrackPrefix == null) {
            this.setDefaultTrueTrackPrefix();
        }
        return this.trueTrackPrefix;
    }

    public void setMagHdgPrefix(String magHdgPrefix) {
        this.magHdgPrefix = magHdgPrefix;
    }

    public void setTrueTrackPrefix(String trueTrackPrefix) {
        this.trueTrackPrefix = trueTrackPrefix;
    }

    public void setMagTrackPrefix(String magTrackPrefix) {
        this.magTrackPrefix = magTrackPrefix;
    }

    public void setDefaultTrueTrackPrefix() {
        this.setTrueTrackPrefix(Messages.getInstance().get("true_track_prefix"));
    }

    public void setDefaultMagTrackPrefix() {
        this.setMagTrackPrefix(Messages.getInstance().get("mag_track_prefix"));
    }

    public void setDefaultMagHdgPrefix() {
        this.setMagHdgPrefix(Messages.getInstance().get("mag_hdg_prefix"));
    }

    public List<PlaneProfile> getPlaneProfiles() {
        if (this.planeProfiles == null) {
            this.planeProfiles = new ArrayList<PlaneProfile>();
        }
        return this.planeProfiles;
    }

    public void setPlaneProfiles(List<PlaneProfile> planeProfiles) {
        this.planeProfiles = planeProfiles;
    }

    public ColorTheme getColorTheme() {
        return this.colorTheme;
    }

    public void setColorTheme(ColorTheme colorTheme) {
        this.colorTheme = colorTheme;
    }

    public String getMeasurementLineDistanceUnit() {
        return this.measurementLineDistanceUnit;
    }

    public void setMeasurementLineDistanceUnit(String measurementLineDistanceUnit) {
        this.measurementLineDistanceUnit = measurementLineDistanceUnit;
    }

    public boolean isOfflineMode() {
        return this.offlineMode;
    }

    public void setOfflineMode(boolean offlineMode) {
        this.offlineMode = offlineMode;
    }

    public boolean isDrawAirspaces() {
        return this.drawAirspaces;
    }

    public void setDrawAirspaces(boolean drawAirspaces) {
        this.drawAirspaces = drawAirspaces;
    }

    public StringComboBoxItem[] getDistanceValuesCombo() {
        StringComboBoxItem[] DISTANCE_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("settings_frame_nautical_miles"), "nm"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_kilometers"), "km"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_statute_miles"), "sm"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_feet"), "ft"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_yards"), "yd")};
        return DISTANCE_VALUES_COMBO;
    }

    public StringComboBoxItem[] getConnectionValuesCombo() {
        StringComboBoxItem[] VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("main_frame_menu_sim_connect_fsx_p3d"), "fsx_p3d"), new StringComboBoxItem(Messages.getInstance().get("main_frame_menu_sim_connect_xplane"), "xplane"), new StringComboBoxItem(Messages.getInstance().get("main_frame_menu_sim_connect_flightgear"), "flightgear"), new StringComboBoxItem(Messages.getInstance().get("main_frame_menu_sim_connect_gps"), "gps"), new StringComboBoxItem(Messages.getInstance().get("main_frame_menu_sim_connect_nmea_log_file"), "nmea_log")};
        return VALUES_COMBO;
    }

    public StringComboBoxItem[] getAltitudeValuesCombo() {
        StringComboBoxItem[] ALTITUDE_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("settings_frame_feet"), "ft"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_meters"), "m")};
        return ALTITUDE_VALUES_COMBO;
    }

    public StringComboBoxItem[] getSpeedValuesCombo() {
        StringComboBoxItem[] SPEED_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("settings_frame_knots"), "kt"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_kilometers_per_hour"), "km/h"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_statute_miles_per_hour"), "mph")};
        return SPEED_VALUES_COMBO;
    }

    public StringComboBoxItem[] getWindSpeedValuesCombo() {
        StringComboBoxItem[] WIND_SPEED_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("settings_frame_knots"), "kt"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_meters_per_second"), "m/s")};
        return WIND_SPEED_VALUES_COMBO;
    }

    public StringComboBoxItem[] getFuelValuesCombo() {
        StringComboBoxItem[] FUEL_VALUES_COMBO = new StringComboBoxItem[]{new StringComboBoxItem(Messages.getInstance().get("settings_frame_liters"), "l"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_kilograms"), "kg"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_us_gallons"), "gal"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_uk_gallons"), "impgal"), new StringComboBoxItem(Messages.getInstance().get("settings_frame_pounds"), "lbs")};
        return FUEL_VALUES_COMBO;
    }

    public boolean isStickyMode() {
        return this.stickyMode;
    }

    public void setStickyMode(boolean stickyMode) {
        this.stickyMode = stickyMode;
    }

    public boolean isDrawAllNdbs() {
        return this.drawAllNdbs;
    }

    public void setDrawAllNdbs(boolean drawAllNdbs) {
        this.drawAllNdbs = drawAllNdbs;
    }

    public boolean isDrawAllIls() {
        return this.drawAllIls;
    }

    public void setDrawAllIls(boolean drawAllIls) {
        this.drawAllIls = drawAllIls;
    }

    public boolean isDrawAllVors() {
        return this.drawAllVors;
    }

    public void setDrawAllVors(boolean drawAllVors) {
        this.drawAllVors = drawAllVors;
    }

    public boolean isDrawAllAirports() {
        return this.drawAllAirports;
    }

    public void setDrawAllAirports(boolean drawAllAirports) {
        this.drawAllAirports = drawAllAirports;
    }

    public PdfConfigBean getPdfConfigBean() {
        return this.pdfConfigBean;
    }

    public void setPdfConfigBean(PdfConfigBean pdfConfigBean) {
        this.pdfConfigBean = pdfConfigBean;
    }

    public boolean isDrawAllUserPoints() {
        return this.drawAllUserPoints;
    }

    public void setDrawAllUserPoints(boolean drawAllUserPoints) {
        this.drawAllUserPoints = drawAllUserPoints;
    }

    public boolean isParamGEExportStickyToTerrain() {
        return this.paramGEExportStickyToTerrain;
    }

    public void setParamGEExportStickyToTerrain(boolean paramGEExportStickyToTerrain) {
        this.paramGEExportStickyToTerrain = paramGEExportStickyToTerrain;
    }

    public int getMapMouseMove() {
        return this.mapMouseMove;
    }

    public void setMapMouseMove(int mapMouseMove) {
        this.mapMouseMove = mapMouseMove;
    }

    public int getMapMouseMeasurementLine() {
        return this.mapMouseMeasurementLine;
    }

    public void setMapMouseMeasurementLine(int mapMouseMeasurementLine) {
        this.mapMouseMeasurementLine = mapMouseMeasurementLine;
    }

    public boolean isParamMapMouseGoogleStyle() {
        return this.paramMapMouseGoogleStyle;
    }

    public boolean isParamShowTermsOfUseScreen() {
        return this.paramShowTermsOfUseScreen;
    }

    public void setParamShowTermsOfUseScreen(boolean paramShowTermsOfUseScreen) {
        this.paramShowTermsOfUseScreen = paramShowTermsOfUseScreen;
    }

    public void setParamMapMouseGoogleStyle(boolean paramMapMouseGoogleStyle) {
        this.mapMouseMove = paramMapMouseGoogleStyle ? 16 : 8;
        this.mapMouseMeasurementLine = paramMapMouseGoogleStyle ? 8 : 16;
        this.paramMapMouseGoogleStyle = paramMapMouseGoogleStyle;
    }

    public boolean isParamIncludeSecondsInTimeCalculations() {
        return this.paramIncludeSecondsInTimeCalculations;
    }

    public void setParamIncludeSecondsInTimeCalculations(boolean paramIncludeSecondsInTimeCalculations) {
        this.paramIncludeSecondsInTimeCalculations = paramIncludeSecondsInTimeCalculations;
    }

    public List<WnBProfile> getWnbProfiles() {
        if (this.wnbProfiles == null) {
            this.wnbProfiles = new ArrayList<WnBProfile>();
        }
        return this.wnbProfiles;
    }

    public void setWnbProfiles(List<WnBProfile> wnbProfiles) {
        this.wnbProfiles = wnbProfiles;
    }

    public ProxyBean getProxyBean() {
        return this.proxyBean;
    }

    public void setProxyBean(ProxyBean proxyBean) {
        this.proxyBean = proxyBean;
    }

    public boolean isParamUseProxy() {
        return this.paramUseProxy;
    }

    public void setParamUseProxy(boolean paramUseProxy) {
        this.paramUseProxy = paramUseProxy;
    }

    public boolean isDrawElevations() {
        return this.drawElevations;
    }

    public void setDrawElevations(boolean drawElevations) {
        this.drawElevations = drawElevations;
    }

    public boolean isParamUseMapDecimalCoords() {
        return this.paramUseMapDecimalCoords;
    }

    public void setParamUseMapDecimalCoords(boolean paramUseMapDecimalCoords) {
        this.paramUseMapDecimalCoords = paramUseMapDecimalCoords;
    }

    public GpsArea getParamMapRegionSelectedArea() {
        if (this.paramMapRegionSelected == 0) {
            return new GpsArea(90.0, -180.0, -90.0, 180.0);
        }
        if (this.paramMapRegionSelected == 1) {
            return this.getMapObjectsUserRegion();
        }
        return Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()];
    }

    public int getParamMapRegionSelected() {
        return this.paramMapRegionSelected;
    }

    public void setParamMapRegionSelected(int paramMapRegionSelected) {
        this.paramMapRegionSelected = paramMapRegionSelected;
    }

    public boolean isAirportsTableFromFsxP3d() {
        ParamFacade paramFacade = new ParamFacade(DBUtil.getDataSource());
        return "FSXP3D".equals(paramFacade.findParamByName("SRC_AIRPORTS_TABLE"));
    }

    public boolean isNavaidsTableFromFsxP3d() {
        ParamFacade paramFacade = new ParamFacade(DBUtil.getDataSource());
        return "FSXP3D".equals(paramFacade.findParamByName("SRC_NAVAIDS_TABLE"));
    }

    public boolean isImportFromFsxP3d() {
        return this.isAirportsTableFromFsxP3d() || this.isNavaidsTableFromFsxP3d();
    }

    public boolean isImportFromOpenAip() {
        ParamFacade paramFacade = new ParamFacade(DBUtil.getDataSource());
        return "OPEN_AIP".equals(paramFacade.findParamByName("SRC_NAVAIDS_TABLE")) || "OPEN_AIP".equals(paramFacade.findParamByName("SRC_AIRPORTS_TABLE"));
    }

    public void setAirportsTableSource(String src) {
        ParamFacade paramFacade = new ParamFacade(DBUtil.getDataSource());
        paramFacade.insertOrUpdateParam("SRC_AIRPORTS_TABLE", src);
    }

    public void setNavaidsTableSource(String src) {
        ParamFacade paramFacade = new ParamFacade(DBUtil.getDataSource());
        paramFacade.insertOrUpdateParam("SRC_NAVAIDS_TABLE", src);
    }

    public Point getInitMapFramePosition() {
        return this.initMapFramePosition;
    }

    public void setInitMapFramePosition(Point initMapFramePosition) {
        this.initMapFramePosition = initMapFramePosition;
    }

    public boolean isInitMapFrameFullScreen() {
        return this.initMapFrameFullScreen;
    }

    public void setInitMapFrameFullScreen(boolean initMapFrameFullScreen) {
        this.initMapFrameFullScreen = initMapFrameFullScreen;
    }

    public Dimension getInitMapFrameSize() {
        return this.initMapFrameSize;
    }

    public void setInitMapFrameSize(Dimension initMapFrameSize) {
        this.initMapFrameSize = initMapFrameSize;
    }

    public Integer getInitMapZoom() {
        return this.initMapZoom;
    }

    public void setInitMapZoom(Integer initMapZoom) {
        this.initMapZoom = initMapZoom;
    }

    public Integer getInitMapType() {
        return this.initMapType;
    }

    public void setInitMapType(Integer initMapType) {
        this.initMapType = initMapType;
    }

    public GeoPosition getInitMapPosition() {
        return this.initMapPosition;
    }

    public void setInitMapPosition(GeoPosition initMapPosition) {
        this.initMapPosition = initMapPosition;
    }

    public int[] getMapPriority() {
        return this.mapPriority;
    }

    public void setMapPriority(int[] mapPriority) {
        this.mapPriority = mapPriority;
        this.calculateMapPriorities();
    }

    public void calculateMapPriorities() {
        this.mapPriorities = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.mapPriority.length; ++i) {
            this.mapPriorities.put(this.mapPriority[i], this.mapPriority.length - 1 - i);
        }
    }

    public Map<Integer, Integer> getMapPriorities() {
        if (this.mapPriorities == null) {
            this.calculateMapPriorities();
        }
        return this.mapPriorities;
    }

    public void setMapPriorities(Map<Integer, Integer> mapPriorities) {
        this.mapPriorities = mapPriorities;
    }

    public boolean isParamFsxP3dMode() {
        return this.paramFsxP3dMode;
    }

    public void setParamFsxP3dMode(boolean paramFsxP3dMode) {
        this.paramFsxP3dMode = paramFsxP3dMode;
    }

    public boolean isParamImportMagvarShowWarning() {
        return this.paramImportMagvarShowWarning;
    }

    public void setParamImportMagvarShowWarning(boolean paramImportMagvarShowWarning) {
        this.paramImportMagvarShowWarning = paramImportMagvarShowWarning;
    }

    public boolean isConnectedToSim() {
        return this.extConnectTask != null && this.extConnectTask.isRunning();
    }

    public boolean isConnectedToSimAndHasData() {
        return this.isConnectedToSim() && SimConnectUtil.getInstance().getExtConnectBean() != null && SimConnectUtil.getInstance().getExtConnectBean().hasData();
    }

    public boolean isFollowUserPosition() {
        return this.followUserPosition;
    }

    public void setFollowUserPosition(boolean followUserPosition) {
        this.followUserPosition = followUserPosition;
    }

    public boolean isDrawAllIfrPoints() {
        return this.drawAllIfrPoints;
    }

    public void setDrawAllIfrPoints(boolean drawAllIfrPoints) {
        this.drawAllIfrPoints = drawAllIfrPoints;
    }

    public boolean isDrawAllIfrRoutes() {
        return this.drawAllIfrRoutes;
    }

    public void setDrawAllIfrRoutes(boolean drawAllIfrRoutes) {
        this.drawAllIfrRoutes = drawAllIfrRoutes;
    }

    public Color[] getColorsPalette() {
        if (this.colorsPalette == null) {
            this.colorsPalette = VfrUtil.generateColorsPalette(512);
        }
        return this.colorsPalette;
    }

    public void setColorsPalette(Color[] colorsPalette) {
        this.colorsPalette = colorsPalette;
    }

    public Color[] getGrayPalette() {
        if (this.grayPalette == null) {
            this.grayPalette = VfrUtil.generateGrayPalette(512);
        }
        return this.grayPalette;
    }

    public void setGrayPalette(Color[] grayPalette) {
        this.grayPalette = grayPalette;
    }

    public TerrainLayerBean getTerrainLayerBean() {
        return this.terrainLayerBean;
    }

    public void setTerrainLayerBean(TerrainLayerBean terrainLayerBean) {
        this.terrainLayerBean = terrainLayerBean;
    }

    public VerticalProfileBean getVerticalProfileBean() {
        return this.verticalProfileBean;
    }

    public void setVerticalProfileBean(VerticalProfileBean verticalProfileBean) {
        this.verticalProfileBean = verticalProfileBean;
    }

    public GpsArea getMapObjectsUserRegion() {
        return this.mapObjectsUserRegion;
    }

    public void setMapObjectsUserRegion(GpsArea mapObjectsUserRegion) {
        this.mapObjectsUserRegion = mapObjectsUserRegion;
    }

    public SimConnectConfigBean getSimConnectConfigBean() {
        return this.simConnectConfigBean;
    }

    public void setSimConnectConfigBean(SimConnectConfigBean simConnectConfigBean) {
        this.simConnectConfigBean = simConnectConfigBean;
    }

    public boolean isShowOnlyEnrouteIls() {
        return this.showOnlyEnrouteIls;
    }

    public void setShowOnlyEnrouteIls(boolean showOnlyEnrouteIls) {
        this.showOnlyEnrouteIls = showOnlyEnrouteIls;
    }

    public boolean isDrawMapGrid() {
        return this.drawMapGrid;
    }

    public void setDrawMapGrid(boolean drawMapGrid) {
        this.drawMapGrid = drawMapGrid;
    }

    public boolean isDrawAirspacesListUnderCursor() {
        return this.drawAirspacesListUnderCursor;
    }

    public void setDrawAirspacesListUnderCursor(boolean drawAirspacesListUnderCursor) {
        this.drawAirspacesListUnderCursor = drawAirspacesListUnderCursor;
    }

    public boolean isDrawMapObjectsListUnderCursor() {
        return this.drawMapObjectsListUnderCursor;
    }

    public void setDrawMapObjectsListUnderCursor(boolean drawMapObjectsListUnderCursor) {
        this.drawMapObjectsListUnderCursor = drawMapObjectsListUnderCursor;
    }

    public boolean isDrawTextLabels() {
        return this.drawTextLabels;
    }

    public void setDrawTextLabels(boolean drawTextLabels) {
        this.drawTextLabels = drawTextLabels;
    }

    public boolean isDrawAirspacesIds() {
        return this.drawAirspacesIds;
    }

    public void setDrawAirspacesIds(boolean drawAirspacesIds) {
        this.drawAirspacesIds = drawAirspacesIds;
    }

    public boolean isDrawUserTrack() {
        return this.drawUserTrack;
    }

    public void setDrawUserTrack(boolean drawUserTrack) {
        this.drawUserTrack = drawUserTrack;
    }

    public DrawShapeModeBean getDrawShapeModeBean() {
        return this.drawShapeModeBean;
    }

    public void setDrawShapeModeBean(DrawShapeModeBean drawShapeModeBean) {
        this.drawShapeModeBean = drawShapeModeBean;
    }

    public boolean isParamFirstRun() {
        return this.paramFirstRun;
    }

    public void setParamFirstRun(boolean paramFirstRun) {
        this.paramFirstRun = paramFirstRun;
    }

    public int getRenderingHintsQuality() {
        return this.renderingHintsQuality;
    }

    public void setRenderingHintsQuality(int renderingHintsQuality) {
        this.renderingHintsQuality = renderingHintsQuality;
    }

    public JvmParamsBean getJvmParamsBean() {
        return this.jvmParamsBean;
    }

    public void setJvmParamsBean(JvmParamsBean jvmParamsBean) {
        this.jvmParamsBean = jvmParamsBean;
    }

    public Level getConsoleLogLevel() {
        return this.consoleLogLevel;
    }

    public void setConsoleLogLevel(Level consoleLogLevel) {
        this.consoleLogLevel = consoleLogLevel;
    }

    public Level getFileLogLevel() {
        return this.fileLogLevel;
    }

    public void setFileLogLevel(Level fileLogLevel) {
        this.fileLogLevel = fileLogLevel;
    }

    public boolean isLogLevelTrace() {
        return Level.TRACE.equals(this.fileLogLevel);
    }

    public boolean isLogLevelDebug() {
        return Level.DEBUG.equals(this.fileLogLevel);
    }

    public boolean isDrawCities() {
        return this.drawCities;
    }

    public void setDrawCities(boolean drawCities) {
        this.drawCities = drawCities;
    }

    public boolean isCalculateRouteInRealTime() {
        return this.calculateRouteInRealTime;
    }

    public void setCalculateRouteInRealTime(boolean calculateRouteInRealTime) {
        this.calculateRouteInRealTime = calculateRouteInRealTime;
    }

    public boolean calculateRouteInRealTime() {
        return this.calculateRouteInRealTime && FlightPlanBean.getInstance().getRoute().couldBeCalculateInRealTime();
    }

    public boolean isParamShowWarnings() {
        return this.paramShowWarnings;
    }

    public void setParamShowWarnings(boolean paramShowWarnings) {
        this.paramShowWarnings = paramShowWarnings;
    }

    public boolean isParamUseMultipleCores() {
        return this.paramUseMultipleCores;
    }

    public void setParamUseMultipleCores(boolean paramUseMultipleCores) {
        this.paramUseMultipleCores = paramUseMultipleCores;
    }

    public boolean isShowVor() {
        return this.showVor;
    }

    public void setShowVor(boolean showVor) {
        this.showVor = showVor;
    }

    public boolean isShowWindSock() {
        return this.showWindSock;
    }

    public void setShowWindSock(boolean showWindSock) {
        this.showWindSock = showWindSock;
    }

    public boolean isShowCrsAndDist() {
        return this.showCrsAndDist;
    }

    public void setShowCrsAndDist(boolean showCrsAndDist) {
        this.showCrsAndDist = showCrsAndDist;
    }

    public int getRouteFontSizeModificator() {
        return this.routeFontSizeModificator;
    }

    public void setRouteFontSizeModificator(int routeFontSizeModificator) {
        this.routeFontSizeModificator = routeFontSizeModificator;
    }

    public boolean[] getHintsDontShow() {
        return this.hintsDontShow;
    }

    public void setHintsDontShow(boolean[] hintsDontShow) {
        this.hintsDontShow = hintsDontShow;
    }

    public DropboxHelper getDropboxBean() {
        return this.dropboxBean;
    }

    public void setDropboxBean(DropboxHelper dropboxBean) {
        this.dropboxBean = dropboxBean;
    }

    public boolean isDrawMagneticDeclinations() {
        return this.drawMagneticDeclinations;
    }

    public void setDrawMagneticDeclinations(boolean drawMagneticDeclinations) {
        this.drawMagneticDeclinations = drawMagneticDeclinations;
    }

    public boolean isDrawMeteoImageMesh() {
        return this.drawMeteoImageMesh;
    }

    public void setDrawMeteoImageMesh(boolean drawMeteoImageMesh) {
        this.drawMeteoImageMesh = drawMeteoImageMesh;
    }

    public boolean isDrawWeather() {
        return this.drawWeather;
    }

    public void setDrawWeather(boolean drawWeather) {
        this.drawWeather = drawWeather;
    }

    public boolean isDrawTerrainElevations() {
        return this.drawTerrainElevations;
    }

    public void setDrawTerrainElevations(boolean drawTerrainElevations) {
        this.drawTerrainElevations = drawTerrainElevations;
    }

    public int getParamSidePanelWidth() {
        return this.paramSidePanelWidth;
    }

    public void setParamSidePanelWidth(int paramSidePanelWidth) {
        this.paramSidePanelWidth = paramSidePanelWidth;
    }

    public DeclinationCalculator getDeclinationCalculator() {
        return this.paramFsxP3dMode ? this.fsxP3DDeclCalc : this.realDeclCalc;
    }

    public boolean isDrawObstacles() {
        return this.drawObstacles;
    }

    public void setDrawObstacles(boolean drawObstacles) {
        this.drawObstacles = drawObstacles;
    }

    public boolean isDrawVfrPoints() {
        return this.drawVfrPoints;
    }

    public void setDrawVfrPoints(boolean drawVfrPoints) {
        this.drawVfrPoints = drawVfrPoints;
    }

    public boolean isDrawAirspaceReservations() {
        return this.drawAirspaceReservations;
    }

    public void setDrawAirspaceReservations(boolean drawAirspaceReservations) {
        this.drawAirspaceReservations = drawAirspaceReservations;
    }

    public boolean isDrawRadialsFromVors() {
        return this.drawRadialsFromVors;
    }

    public void setDrawRadialsFromVors(boolean drawRadialsFromVors) {
        this.drawRadialsFromVors = drawRadialsFromVors;
    }

    public boolean isDrawAirportTaxiways() {
        return this.drawAirportTaxiways;
    }

    public void setDrawAirportTaxiways(boolean drawAirportTaxiways) {
        this.drawAirportTaxiways = drawAirportTaxiways;
    }

    public AirspacesColorTheme getAirspacesColorTheme() {
        return this.airspacesColorTheme;
    }

    public void setAirspacesColorTheme(AirspacesColorTheme airspacesColorTheme) {
        this.airspacesColorTheme = airspacesColorTheme;
    }

    public String getParamAirspacesColorTheme() {
        return this.paramAirspacesColorTheme;
    }

    public void setParamAirspacesColorTheme(String paramAirspacesColorTheme) {
        this.paramAirspacesColorTheme = paramAirspacesColorTheme;
    }

    public String getParamLookAndFeel() {
        return this.paramLookAndFeel;
    }

    public void setParamLookAndFeel(String paramLookAndFeel) {
        this.paramLookAndFeel = paramLookAndFeel;
    }

    public HgtZipFilesMapping[] getHgtZipFilesMappings() {
        return this.hgtZipFilesMappings;
    }

    public void setHgtZipFilesMappings(HgtZipFilesMapping[] hgtZipFilesMappings) {
        this.hgtZipFilesMappings = hgtZipFilesMappings;
    }

    public EngineLossBean getEngineLossBean() {
        return this.engineLossBean;
    }

    public void setEngineLossBean(EngineLossBean engineLossBean) {
        this.engineLossBean = engineLossBean;
    }

    public String getFlightPlansPath() {
        return this.flightPlansPath;
    }

    public void setFlightPlansPath(String flightPlansPath) {
        this.flightPlansPath = flightPlansPath;
    }

    public ExtConnectTask getExtConnectTask() {
        return this.extConnectTask;
    }

    public void setExtConnectTask(ExtConnectTask extConnectTask) {
        this.extConnectTask = extConnectTask;
    }

    public boolean isTouchScreenMode() {
        return this.touchScreenMode;
    }

    public void setTouchScreenMode(boolean touchScreenMode) {
        this.touchScreenMode = touchScreenMode;
    }

    public boolean isDrawRunwayExtensions() {
        return this.drawRunwayExtensions;
    }

    public void setDrawRunwayExtensions(boolean drawRunwayExtensions) {
        this.drawRunwayExtensions = drawRunwayExtensions;
    }

    public boolean isAppExportAvailable() {
        return this.appExportAvailable;
    }

    public void setAppExportAvailable(boolean appExportAvailable) {
        this.appExportAvailable = appExportAvailable;
    }

    public Double getTextLabelsRotationAngle() {
        return this.textLabelsRotationAngle;
    }

    public void setTextLabelsRotationAngle(Double textLabelsRotationAngle) {
        this.textLabelsRotationAngle = textLabelsRotationAngle;
    }

    public String getVfrFilesPath() {
        return this.vfrFilesPath;
    }

    public void setVfrFilesPath(String vfrFilesPath) {
        this.vfrFilesPath = vfrFilesPath;
    }

    public String getPdfFilesPath() {
        return this.pdfFilesPath;
    }

    public void setPdfFilesPath(String pdfFilesPath) {
        this.pdfFilesPath = pdfFilesPath;
    }

    public XPConnectConfigBean getXpConnectConfigBean() {
        return this.xpConnectConfigBean;
    }

    public void setXpConnectConfigBean(XPConnectConfigBean xpConnectConfigBean) {
        this.xpConnectConfigBean = xpConnectConfigBean;
    }

    public boolean isParamGpsMapOverlay() {
        return this.paramGpsMapOverlay;
    }

    public void setParamGpsMapOverlay(boolean paramGpsMapOverlay) {
        this.paramGpsMapOverlay = paramGpsMapOverlay;
    }

    public RouteCreatorBean getRouteCreatorBean() {
        return this.routeCreatorBean;
    }

    public Map<String, List<Station>> getWeatherCache() {
        return this.weatherCache;
    }

    public boolean isParamThreeRowsLayout() {
        return this.paramThreeRowsLayout;
    }

    public void setParamThreeRowsLayout(boolean paramThreeRowsLayout) {
        this.paramThreeRowsLayout = paramThreeRowsLayout;
    }

    public boolean isDrawLandmarkLabels() {
        return this.drawLandmarkLabels;
    }

    public void setDrawLandmarkLabels(boolean drawLandmarkLabels) {
        this.drawLandmarkLabels = drawLandmarkLabels;
    }

    public boolean isShowMapRadials() {
        return this.showMapRadials;
    }

    public void setShowMapRadials(boolean showMapRadials) {
        this.showMapRadials = showMapRadials;
    }

    public boolean isDrawDirectionArrows() {
        return this.drawDirectionArrows;
    }

    public void setDrawDirectionArrows(boolean drawDirectionArrows) {
        this.drawDirectionArrows = drawDirectionArrows;
    }

    public FlightGearConnectConfigBean getFlightGearConnectConfigBean() {
        return this.flightGearConnectConfigBean;
    }

    public void setFlightGearConnectConfigBean(FlightGearConnectConfigBean flightGearConnectConfigBean) {
        this.flightGearConnectConfigBean = flightGearConnectConfigBean;
    }

    public FsxP3DConnectConfigBean getFsxP3DConnectConfigBean() {
        return this.fsxP3DConnectConfigBean;
    }

    public void setFsxP3DConnectConfigBean(FsxP3DConnectConfigBean fsxP3DConnectConfigBean) {
        this.fsxP3DConnectConfigBean = fsxP3DConnectConfigBean;
    }
}

