/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;
import main.java.guru.vfrflight.util.GraphicsUtil;
import org.apache.log4j.Logger;

public class ResourcesBean
implements Serializable {
    private static final Logger log = Logger.getLogger(ResourcesBean.class);
    private static final long serialVersionUID = -2246501602422974648L;
    private BufferedImage contextMenuIcon;
    private Cursor[] mouseCursorRotate = new Cursor[24];
    private Cursor[] mouseCursorResize = new Cursor[24];
    private Cursor mouseCursorMove = null;
    private static volatile ResourcesBean instance = null;

    private ResourcesBean() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourcesBean getInstance() {
        if (instance != null) return instance;
        Class<ResourcesBean> clazz = ResourcesBean.class;
        synchronized (ResourcesBean.class) {
            if (instance != null) return instance;
            instance = new ResourcesBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public BufferedImage getContextMenuIcon() {
        if (this.contextMenuIcon == null) {
            try {
                this.contextMenuIcon = ImageIO.read(new File("img/gui/context_menu.png"));
            }
            catch (IOException e) {
                log.error(e, e);
            }
        }
        return this.contextMenuIcon;
    }

    public void setContextMenuIcon(BufferedImage contextMenuIcon) {
        this.contextMenuIcon = contextMenuIcon;
    }

    public Cursor[] getMouseCursorRotate() {
        if (this.mouseCursorRotate == null) {
            int i = 0;
            for (int angle = 0; angle < 360; angle += 15) {
                this.mouseCursorRotate[i] = GraphicsUtil.getRotatedCursor("img/mouse/rotate.png", angle - 90);
                ++i;
            }
        }
        return this.mouseCursorRotate;
    }

    public void setMouseCursorRotate(Cursor[] mouseCursorRotate) {
        this.mouseCursorRotate = mouseCursorRotate;
    }

    public Cursor[] getMouseCursorResize() {
        if (this.mouseCursorResize == null) {
            int i = 0;
            for (int angle = 0; angle < 360; angle += 15) {
                this.mouseCursorResize[i] = GraphicsUtil.getRotatedCursor("img/mouse/resize.png", angle + 90);
                ++i;
            }
        }
        return this.mouseCursorResize;
    }

    public void setMouseCursorResize(Cursor[] mouseCursorResize) {
        this.mouseCursorResize = mouseCursorResize;
    }

    public Cursor getMouseCursorMove() {
        if (this.mouseCursorMove == null) {
            this.mouseCursorMove = GraphicsUtil.getCursor("img/mouse/move.png");
        }
        return this.mouseCursorMove;
    }

    public void setMouseCursorMove(Cursor mouseCursorMove) {
        this.mouseCursorMove = mouseCursorMove;
    }
}

