/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.sql.LatLonObject;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.StringUtil;

public class MapObjectsWrapper<T> {
    private Map<String, Set<T>> objects;

    public MapObjectsWrapper(Set<T> objects) {
        this.createObjectsMap(objects);
    }

    public Set<T> getObjects(GpsArea area) {
        HashSet<T> resultSet = new HashSet<T>();
        if (this.objects != null) {
            LatLonRange range = new LatLonRange(area);
            for (int lat = range.getLatMin(); lat <= range.getLatMax(); ++lat) {
                for (int lon = range.getLonMin(); lon <= range.getLonMax(); ++lon) {
                    Set<T> objs = this.objects.get(this.getBucketKey(lat, lon));
                    if (objs == null) continue;
                    resultSet.addAll(objs);
                }
            }
        }
        return resultSet;
    }

    private void createObjectsMap(Set<T> objects) {
        if (this.objects == null) {
            this.objects = new HashMap<String, Set<T>>();
        } else {
            this.objects.clear();
        }
        if (objects != null) {
            for (T o : objects) {
                String key = StringUtil.nullToEmpty(this.getBucketKey(o));
                if (this.objects.get(key) == null) {
                    HashSet objectsSet = new HashSet();
                    this.objects.put(key, objectsSet);
                }
                this.objects.get(key).add(o);
            }
        }
    }

    private String getBucketKey(T obj) {
        if (!(obj instanceof LatLonObject)) {
            return null;
        }
        LatLonObject o = (LatLonObject)obj;
        return this.getBucketKey(o.getLat(), o.getLon());
    }

    private String getBucketKey(double lat, double lon) {
        return String.valueOf((int)Math.floor(GpsUtil.normalizeLatitude(lat))) + ":" + String.valueOf((int)Math.floor(GpsUtil.normalizeLongitude(lon)));
    }

    private class LatLonRange {
        final int latMin;
        final int latMax;
        final int lonMin;
        final int lonMax;

        LatLonRange(GpsArea area) {
            if (area != null) {
                this.latMin = (int)Math.floor(area.getMinLat());
                this.latMax = (int)Math.floor(area.getMaxLat());
                this.lonMin = (int)Math.floor(area.getMinLon());
                this.lonMax = (int)Math.floor(area.getMaxLon());
            } else {
                this.latMin = -90;
                this.latMax = 90;
                this.lonMin = -180;
                this.lonMax = 180;
            }
        }

        int getLatMin() {
            return this.latMin;
        }

        int getLatMax() {
            return this.latMax;
        }

        int getLonMin() {
            return this.lonMin;
        }

        int getLonMax() {
            return this.lonMax;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[latMin=");
            builder.append(this.latMin);
            builder.append(", latMax=");
            builder.append(this.latMax);
            builder.append(", lonMin=");
            builder.append(this.lonMin);
            builder.append(", lonMax=");
            builder.append(this.lonMax);
            builder.append("]");
            return builder.toString();
        }
    }
}

