/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import main.java.guru.vfrflight.bean.MapObjectsWrapper;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.filter.AirportFilter;
import main.java.guru.vfrflight.bean.filter.AirspaceFilter;
import main.java.guru.vfrflight.bean.filter.ObstacleFilter;
import main.java.guru.vfrflight.bean.filter.TerrainLayerFilter;
import main.java.guru.vfrflight.bean.filter.UserPointsFilter;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBean;
import main.java.guru.vfrflight.bean.meteo.MeteoMapBeanUm4;
import main.java.guru.vfrflight.core.AirspaceReservation;
import main.java.guru.vfrflight.core.MouseCursorInfo;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirportTaxiDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.dto.CityDTO;
import main.java.guru.vfrflight.core.dto.ElevationDTO;
import main.java.guru.vfrflight.core.dto.IfrPointDTO;
import main.java.guru.vfrflight.core.dto.IfrRouteDTO;
import main.java.guru.vfrflight.core.dto.IlsDTO;
import main.java.guru.vfrflight.core.dto.NavaidDTO;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.dto.RadialFromVorDTO;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.core.dto.UserPointDTO;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.MeteoImageMesh;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.map.NamedWaypoint;
import main.java.guru.vfrflight.gui.map.shape.MapShape;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.weather.core.Station;
import main.java.org.jdesktop.swingx.JXMapViewer;

public class MapObjectsBean
implements Serializable {
    private static final long serialVersionUID = -850656388619986765L;
    private AirspaceAreaDTO[] airspaces;
    private boolean airspacesRefreshRunning = false;
    private MapObjectsWrapper<NavaidDTO> vors;
    private MapObjectsWrapper<ElevationDTO> elevations;
    private IlsDTO[] ils;
    private MapObjectsWrapper<IfrPointDTO> ifrPoints;
    private IfrRouteDTO[] ifrRoutes;
    private MapObjectsWrapper<NavaidDTO> ndbs;
    private MapObjectsWrapper<CityDTO> cities;
    private MapObjectsWrapper<AirportDTO> airports;
    private AirportTaxiDTO[] airportTaxis;
    private MapObjectsWrapper<UserPointDTO> userPoints;
    private TerrainMesh[] terrainMesh;
    private GpsArea terrainMeshArea;
    private MapObjectsWrapper<NamedWaypoint> magneticDeclinations;
    private MeteoImageMesh[] meteoImageMesh;
    private List<Station> stations;
    private MapObjectsWrapper<ObstacleDTO> obstacles;
    private MapObjectsWrapper<VfrPointDTO> vfrPoints;
    private AirspaceReservation[] airspaceReservations;
    private MapShape[] highlightedMapShapes;
    private MapShape highlightedMapShape;
    private GpsPlace newWaypoint;
    private RunwayExtensionDTO[] runwayExtensions;
    private RadialFromVorDTO[] radialsFromVors;
    private GpsPlace[] radialsFromVorsIntersections;
    private LineSegment[] engineLossSegments;
    private TerrainElevationDTO[] terrainElevations;
    private List<MouseCursorInfo> textUnderCursor;
    private GpsPlace touchScreenModeCursorPosition;
    private AirspaceFilter airspaceFilter = new AirspaceFilter();
    private AirportFilter airportFilter = new AirportFilter();
    private ObstacleFilter obstacleFilter = new ObstacleFilter();
    private TerrainLayerFilter terrainLayerFilter = new TerrainLayerFilter();
    private UserPointsFilter userPointsFilter = new UserPointsFilter();
    private MeteoMapBean meteoMapBean = new MeteoMapBeanUm4();
    private static volatile MapObjectsBean instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapObjectsBean getInstance() {
        if (instance != null) return instance;
        Class<MapObjectsBean> clazz = MapObjectsBean.class;
        synchronized (MapObjectsBean.class) {
            if (instance != null) return instance;
            instance = new MapObjectsBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MapObjectsBean() {
    }

    public List<AirspaceAreaDTO> getViolatedAirspaceAreas2D(JXMapViewer map, List<RoutePlace> points) {
        LinkedList<AirspaceAreaDTO> results = new LinkedList<AirspaceAreaDTO>();
        if (this.getAirspaces() != null) {
            ArrayList<LineSegment> segments = new ArrayList<LineSegment>(points.size() - 1);
            for (int i = 1; i < points.size(); ++i) {
                segments.add(new LineSegment(points.get(i - 1), points.get(i)));
            }
            GpsArea rectangleOver = GpsUtil.getRectangleOverSegments(segments);
            block1: for (AirspaceAreaDTO area : this.getAirspaces()) {
                if (!this.getAirspaceFilter().checkDisplayAirspaceArea(area) || !rectangleOver.isInside(area.getRectangleOver()) && !area.getRectangleOver().isInside(rectangleOver)) continue;
                for (LineSegment segment : segments) {
                    if (!MapUtil.isSegmentIsInsideAirspaceArea(map, segment, area)) continue;
                    results.add(area);
                    continue block1;
                }
            }
        }
        return results;
    }

    public AirspaceAreaDTO[] getAirspaces() {
        return this.airspaces;
    }

    public void setAirspaces(AirspaceAreaDTO[] airspaces) {
        this.airspaces = airspaces;
    }

    public Set<NavaidDTO> getNdbs(GpsArea area) {
        if (this.ndbs == null) {
            return new HashSet<NavaidDTO>();
        }
        return this.ndbs.getObjects(area);
    }

    public void setNdbs(Set<NavaidDTO> ndbs) {
        this.ndbs = new MapObjectsWrapper<NavaidDTO>(ndbs);
    }

    public Set<NavaidDTO> getVors(GpsArea area) {
        if (this.vors == null) {
            return new HashSet<NavaidDTO>();
        }
        return this.vors.getObjects(area);
    }

    public void setVors(Set<NavaidDTO> vors) {
        this.vors = new MapObjectsWrapper<NavaidDTO>(vors);
    }

    public Set<CityDTO> getCities(GpsArea area) {
        if (this.cities == null) {
            return new HashSet<CityDTO>();
        }
        return this.cities.getObjects(area);
    }

    public void setCities(Set<CityDTO> cities) {
        this.cities = new MapObjectsWrapper<CityDTO>(cities);
    }

    public Set<AirportDTO> getAirports(GpsArea area) {
        if (this.airports == null) {
            return new HashSet<AirportDTO>();
        }
        return this.airports.getObjects(area);
    }

    public void setAirports(Set<AirportDTO> airports) {
        this.airports = new MapObjectsWrapper<AirportDTO>(airports);
    }

    public Set<UserPointDTO> getUserPoints(GpsArea area) {
        if (this.userPoints == null) {
            return new HashSet<UserPointDTO>();
        }
        return this.userPoints.getObjects(area);
    }

    public void setUserPoints(Set<UserPointDTO> userPoints) {
        this.userPoints = new MapObjectsWrapper<UserPointDTO>(userPoints);
    }

    public Set<ElevationDTO> getElevations(GpsArea area) {
        if (this.elevations == null) {
            return new HashSet<ElevationDTO>();
        }
        return this.elevations.getObjects(area);
    }

    public void setElevations(Set<ElevationDTO> elevations) {
        this.elevations = new MapObjectsWrapper<ElevationDTO>(elevations);
    }

    public TerrainMesh[] getTerrainMesh() {
        return this.terrainMesh;
    }

    public boolean isTerrainMesh() {
        return this.terrainMesh != null && this.terrainMesh.length > 0;
    }

    public void setTerrainMesh(TerrainMesh[] terrainMesh) {
        this.terrainMesh = terrainMesh;
    }

    public void calculateTerrainMesh(float opacity, Short absoluteMin, Short absoluteMax) {
        short min = Short.MAX_VALUE;
        short max = Short.MIN_VALUE;
        for (int i = 0; i < this.terrainMesh.length; ++i) {
            if (this.terrainMesh[i].getValue() > max) {
                max = this.terrainMesh[i].getValue();
            }
            if (this.terrainMesh[i].getValue() >= min) continue;
            min = this.terrainMesh[i].getValue();
        }
        for (int i = 0; i < this.terrainMesh.length; ++i) {
            this.terrainMesh[i].calculateRectangleOver();
            int color = VfrUtil.getColorIndex(this.terrainMesh[i].getValue(), min, max, absoluteMin, absoluteMax);
            this.terrainMesh[i].setColor(new Color((float)SettingsBean.getInstance().getColorsPalette()[color].getRed() / 255.0f, (float)SettingsBean.getInstance().getColorsPalette()[color].getGreen() / 255.0f, (float)SettingsBean.getInstance().getColorsPalette()[color].getBlue() / 255.0f, opacity));
        }
        if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
            min = (short)Math.round(UnitUtil.recalculateAltitude(min, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
            max = (short)Math.round(UnitUtil.recalculateAltitude(max, "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false));
        }
        MapFrame.getInstance().getMapViewer().setElevationScaleMin(min);
        MapFrame.getInstance().getMapViewer().setElevationScaleMax(max);
        MapFrame.getInstance().getMapViewer().setDrawElevationScale(true);
    }

    public Set<IfrPointDTO> getIfrPoints(GpsArea area) {
        if (this.ifrPoints == null) {
            return new HashSet<IfrPointDTO>();
        }
        return this.ifrPoints.getObjects(area);
    }

    public void setIfrPoints(Set<IfrPointDTO> ifrPoints) {
        this.ifrPoints = new MapObjectsWrapper<IfrPointDTO>(ifrPoints);
    }

    public IfrRouteDTO[] getIfrRoutes() {
        return this.ifrRoutes;
    }

    public void setIfrRoutes(IfrRouteDTO[] ifrRoutes) {
        this.ifrRoutes = ifrRoutes;
    }

    public GpsArea getTerrainMeshArea() {
        return this.terrainMeshArea;
    }

    public void setTerrainMeshArea(GpsArea terrainMeshArea) {
        this.terrainMeshArea = terrainMeshArea;
    }

    public IlsDTO[] getIls() {
        return this.ils;
    }

    public void setIls(IlsDTO[] ils) {
        this.ils = ils;
    }

    public boolean isAirspacesRefreshRunning() {
        return this.airspacesRefreshRunning;
    }

    public void setAirspacesRefreshRunning(boolean isAirspacesRefreshRunning) {
        this.airspacesRefreshRunning = isAirspacesRefreshRunning;
    }

    public Set<NamedWaypoint> getMagneticDeclinations(GpsArea area) {
        if (this.magneticDeclinations == null) {
            return new HashSet<NamedWaypoint>();
        }
        return this.magneticDeclinations.getObjects(area);
    }

    public void setMagneticDeclinations(Set<NamedWaypoint> magneticDeclinations) {
        this.magneticDeclinations = new MapObjectsWrapper<NamedWaypoint>(magneticDeclinations);
    }

    public MeteoImageMesh[] getMeteoImageMesh() {
        return this.meteoImageMesh;
    }

    public void setMeteoImageMesh(MeteoImageMesh[] meteoImageMesh) {
        this.meteoImageMesh = meteoImageMesh;
    }

    public List<Station> getStations() {
        if (this.stations == null) {
            this.stations = new ArrayList<Station>();
        }
        return this.stations;
    }

    public boolean hasMetar() {
        for (Station st : this.getStations()) {
            if (st.getReport() == null || st.getReport().getMetar() == null) continue;
            return true;
        }
        return false;
    }

    public void setStations(List<Station> stations) {
        this.stations = stations;
    }

    public AirspaceFilter getAirspaceFilter() {
        return this.airspaceFilter;
    }

    public void setAirspaceFilter(AirspaceFilter airspaceFilter) {
        this.airspaceFilter = airspaceFilter;
    }

    public AirportFilter getAirportFilter() {
        return this.airportFilter;
    }

    public void setAirportFilter(AirportFilter airportFilter) {
        this.airportFilter = airportFilter;
    }

    public TerrainElevationDTO[] getTerrainElevations() {
        return this.terrainElevations;
    }

    public void setTerrainElevations(TerrainElevationDTO[] terrainElevation) {
        this.terrainElevations = terrainElevation;
    }

    public Set<ObstacleDTO> getObstacles(GpsArea area) {
        if (this.obstacles == null) {
            return new HashSet<ObstacleDTO>();
        }
        return this.obstacles.getObjects(area);
    }

    public void setObstacles(Set<ObstacleDTO> obstacles) {
        this.obstacles = new MapObjectsWrapper<ObstacleDTO>(obstacles);
    }

    public Set<VfrPointDTO> getVfrPoints(GpsArea area) {
        if (this.vfrPoints == null) {
            return new HashSet<VfrPointDTO>();
        }
        return this.vfrPoints.getObjects(area);
    }

    public void setVfrPoints(Set<VfrPointDTO> vfrPoints) {
        this.vfrPoints = new MapObjectsWrapper<VfrPointDTO>(vfrPoints);
    }

    public AirspaceReservation[] getAirspaceReservations() {
        return this.airspaceReservations;
    }

    public void setAirspaceReservations(AirspaceReservation[] airspaceReservations) {
        this.airspaceReservations = airspaceReservations;
    }

    public MapShape[] getHighlightedMapShapes() {
        return this.highlightedMapShapes;
    }

    public void setHighlightedMapShapes(MapShape[] highlightedMapShapes) {
        this.highlightedMapShapes = highlightedMapShapes;
    }

    public void setHighlightedMapShape(MapShape highlightedMapShape) {
        this.highlightedMapShape = highlightedMapShape;
    }

    public ObstacleFilter getObstacleFilter() {
        return this.obstacleFilter;
    }

    public void setObstacleFilter(ObstacleFilter obstacleFilter) {
        this.obstacleFilter = obstacleFilter;
    }

    public RadialFromVorDTO[] getRadialsFromVors() {
        return this.radialsFromVors;
    }

    public void setRadialsFromVors(RadialFromVorDTO[] radialsFromVors) {
        this.radialsFromVors = radialsFromVors;
    }

    public GpsPlace[] getRadialsFromVorsIntersections() {
        return this.radialsFromVorsIntersections;
    }

    public void setRadialsFromVorsIntersections(GpsPlace[] radialsFromVorsIntersections) {
        this.radialsFromVorsIntersections = radialsFromVorsIntersections;
    }

    public MapShape getHighlightedMapShape() {
        return this.highlightedMapShape;
    }

    public void selectRadialsFromVors(List<RadialFromVorDTO> radials) {
        if (this.radialsFromVors != null) {
            for (RadialFromVorDTO radial : this.radialsFromVors) {
                radial.setSelected(false);
                for (RadialFromVorDTO radialToSelect : radials) {
                    if (!radial.getUniqueId().equals(radialToSelect.getUniqueId())) continue;
                    radial.setSelected(true);
                }
            }
        }
    }

    public AirportTaxiDTO[] getAirportTaxis() {
        return this.airportTaxis;
    }

    public void setAirportTaxis(AirportTaxiDTO[] airportTaxis) {
        this.airportTaxis = airportTaxis;
    }

    public GpsPlace getNewWaypoint() {
        return this.newWaypoint;
    }

    public void setNewWaypoint(GpsPlace newWaypoint) {
        this.newWaypoint = newWaypoint;
    }

    public TerrainLayerFilter getTerrainLayerFilter() {
        return this.terrainLayerFilter;
    }

    public void setTerrainLayerFilter(TerrainLayerFilter terrainLayerFilter) {
        this.terrainLayerFilter = terrainLayerFilter;
    }

    public LineSegment[] getEngineLossSegments() {
        return this.engineLossSegments;
    }

    public void setEngineLossSegments(LineSegment[] engineLossSegments) {
        this.engineLossSegments = engineLossSegments;
    }

    public MeteoMapBean getMeteoMapBean() {
        return this.meteoMapBean;
    }

    public void setMeteoMapBean(MeteoMapBean meteoMapBean) {
        this.meteoMapBean = meteoMapBean;
    }

    public List<MouseCursorInfo> getTextUnderCursor() {
        if (this.textUnderCursor == null) {
            this.textUnderCursor = new ArrayList<MouseCursorInfo>();
        }
        return this.textUnderCursor;
    }

    public void setTextUnderCursor(List<MouseCursorInfo> textUnderCursor) {
        this.textUnderCursor = textUnderCursor;
    }

    public GpsPlace getTouchScreenModeCursorPosition() {
        return this.touchScreenModeCursorPosition;
    }

    public void setTouchScreenModeCursorPosition(GpsPlace touchScreenModeCursorPosition) {
        this.touchScreenModeCursorPosition = touchScreenModeCursorPosition;
    }

    public RunwayExtensionDTO[] getRunwayExtensions() {
        return this.runwayExtensions;
    }

    public void setRunwayExtensions(RunwayExtensionDTO[] runwayExtensions) {
        this.runwayExtensions = runwayExtensions;
    }

    public UserPointsFilter getUserPointsFilter() {
        return this.userPointsFilter;
    }

    public void setUserPointsFilter(UserPointsFilter userPointsFilter) {
        this.userPointsFilter = userPointsFilter;
    }
}

