/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import main.java.guru.vfrflight.core.MapRadials;
import main.java.guru.vfrflight.core.MeteoReport;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.SegmentLandmark;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.weather.core.Report;

public class FlightPlanBean
implements Serializable {
    private static final long serialVersionUID = -2694708789019663924L;
    private Route route;
    private String file;
    private List<GpsPlace> calculationDialogDrawRadialsVors;
    private Map<String, Report> awiacjaImgwCache;
    private static volatile FlightPlanBean instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FlightPlanBean getInstance() {
        if (instance != null) return instance;
        Class<FlightPlanBean> clazz = FlightPlanBean.class;
        synchronized (FlightPlanBean.class) {
            if (instance != null) return instance;
            instance = new FlightPlanBean();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setInstance(FlightPlanBean newInstance) {
        instance = newInstance;
    }

    public Route getRoute() {
        if (this.route == null) {
            this.route = new Route();
        }
        return this.route;
    }

    public Map<String, Report> getAwiacjaImgwCache() {
        if (this.awiacjaImgwCache == null) {
            this.awiacjaImgwCache = new HashMap<String, Report>();
        }
        return this.awiacjaImgwCache;
    }

    public void setAwiacjaImgwCache(Map<String, Report> awiacjaImgwCache) {
        this.awiacjaImgwCache = awiacjaImgwCache;
    }

    public void setRoute(Route route) {
        this.route = route;
    }

    private FlightPlanBean() {
    }

    public void clear() {
        this.route = new Route();
        this.file = null;
        this.awiacjaImgwCache = null;
        this.calculationDialogDrawRadialsVors = null;
    }

    public void selectSegment(int i) {
        for (int q = 0; q < this.getRoute().getSegments().size(); ++q) {
            RouteSegment s = this.getRoute().getSegments().get(q);
            if (q == i) {
                s.setSelected(true);
                continue;
            }
            s.setSelected(false);
        }
    }

    public void selectPoint(int i) {
        for (int q = 0; q < this.getRoute().getPoints().size(); ++q) {
            RoutePlace newWp = this.getRoute().getPoints().get(q);
            if (q == i) {
                newWp.setSelected(true);
                continue;
            }
            newWp.setSelected(false);
        }
        if (i >= 0) {
            this.selectVor(-1);
            this.selectLandmark(-1);
            this.selectMapRadial(-1);
        }
    }

    public int getSelectedPoint() {
        for (int q = 0; q < this.getRoute().getPoints().size(); ++q) {
            RoutePlace wp = this.getRoute().getPoints().get(q);
            if (!wp.isSelected()) continue;
            return q;
        }
        return -1;
    }

    public int getSelectedMapRadial() {
        for (int q = 0; q < this.getRoute().getMapRadials().size(); ++q) {
            if (!this.getRoute().getMapRadials().get(q).isSelected()) continue;
            return q;
        }
        return -1;
    }

    public int getSelectedVor() {
        for (int q = 0; q < this.getRoute().getVors().size(); ++q) {
            RoutePlace wp = this.getRoute().getVors().get(q);
            if (!wp.isSelected()) continue;
            return q;
        }
        return -1;
    }

    public void selectVor(int i) {
        for (int q = 0; q < this.getRoute().getVors().size(); ++q) {
            RoutePlace newWp = this.getRoute().getVors().get(q);
            if (q == i) {
                newWp.setSelected(true);
                continue;
            }
            newWp.setSelected(false);
        }
        if (i >= 0) {
            this.selectPoint(-1);
            this.selectLandmark(-1);
            this.selectMapRadial(-1);
        }
    }

    public void selectMapRadial(int i) {
        for (int q = 0; q < this.getRoute().getMapRadials().size(); ++q) {
            MapRadials newWp = this.getRoute().getMapRadials().get(q);
            if (q == i) {
                newWp.setSelected(true);
                continue;
            }
            newWp.setSelected(false);
        }
        if (i >= 0) {
            this.selectPoint(-1);
            this.selectLandmark(-1);
            this.selectVor(-1);
        }
    }

    public void selectLandmark(int i) {
        for (int q = 0; q < this.getRoute().getLandmarks().size(); ++q) {
            SegmentLandmark landmark = this.getRoute().getLandmarks().get(q);
            if (q == i) {
                landmark.setSelected(true);
                continue;
            }
            landmark.setSelected(false);
        }
        if (i >= 0) {
            this.selectPoint(-1);
            this.selectVor(-1);
            this.selectMapRadial(-1);
        }
    }

    public int getSelectedLandmark() {
        for (int q = 0; q < this.getRoute().getLandmarks().size(); ++q) {
            SegmentLandmark wp = this.getRoute().getLandmarks().get(q);
            if (!wp.isSelected()) continue;
            return q;
        }
        return -1;
    }

    public void removeSelectedLandmark() {
        int idx = this.getSelectedLandmark();
        if (idx >= 0 && idx < this.getRoute().getLandmarks().size()) {
            this.getRoute().getLandmarks().remove(idx);
        }
    }

    public void selectMeteoReport(int i) {
        for (int q = 0; q < this.getRoute().getMeteoReports().size(); ++q) {
            MeteoReport newWp = this.getRoute().getMeteoReports().get(q);
            if (q == i) {
                newWp.setSelected(true);
                continue;
            }
            newWp.setSelected(false);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public boolean isEmpty() {
        return this.getRoute().getPoints().size() == 0;
    }

    public void unselectAll() {
        this.selectLandmark(-1);
        this.selectVor(-1);
        this.selectPoint(-1);
        this.selectMapRadial(-1);
        this.selectSegment(-1);
    }

    public FlightPlanBean clone() {
        FlightPlanBean fpb = new FlightPlanBean();
        if (this.awiacjaImgwCache != null) {
            fpb.setAwiacjaImgwCache(new HashMap<String, Report>(this.awiacjaImgwCache));
        }
        fpb.setFile(this.file);
        fpb.setRoute(this.route != null ? this.route.clone() : null);
        if (this.calculationDialogDrawRadialsVors != null) {
            fpb.setCalculationDialogDrawRadialsVors(new ArrayList<GpsPlace>(this.calculationDialogDrawRadialsVors));
        }
        return fpb;
    }

    public List<GpsPlace> getCalculationDialogDrawRadialsVors() {
        if (this.calculationDialogDrawRadialsVors == null) {
            this.calculationDialogDrawRadialsVors = new ArrayList<GpsPlace>();
        }
        return this.calculationDialogDrawRadialsVors;
    }

    public void setCalculationDialogDrawRadialsVors(List<GpsPlace> calculationDialogDrawRadialsVors) {
        this.calculationDialogDrawRadialsVors = calculationDialogDrawRadialsVors;
    }
}

