/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.gui.flightplan.SplashScreenDialog;
import main.java.guru.vfrflight.gui.flightplan.TermsOfUseDialog;
import main.java.guru.vfrflight.gui.lookandfeel.LookAndFeelUtil;
import main.java.guru.vfrflight.gui.task.VfrInitTask;
import main.java.guru.vfrflight.gui.task.VfrShutdownTask;
import main.java.guru.vfrflight.util.UrlUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class VfrMain {
    private static final Logger log = Logger.getLogger(VfrMain.class);

    public static void main(String[] args) {
        VfrUtil.setGlobalExceptionHandler();
        for (String s : args) {
            if ("-offline".equals(s) || "-o".equals(s)) {
                SettingsBean.getInstance().setOfflineMode(true);
                continue;
            }
            if ("-debug".equals(s) || "-d".equals(s)) {
                SettingsBean.getInstance().setConsoleLogLevel(Level.INFO);
                SettingsBean.getInstance().setFileLogLevel(Level.DEBUG);
                continue;
            }
            if (!"-trace".equals(s) && !"-t".equals(s)) continue;
            SettingsBean.getInstance().setConsoleLogLevel(Level.INFO);
            SettingsBean.getInstance().setFileLogLevel(Level.TRACE);
        }
        VfrUtil.configureLoggers(SettingsBean.getInstance().getFileLogLevel(), SettingsBean.getInstance().getConsoleLogLevel());
        VfrUtil.readLaunch4jIni();
        VfrMain.initStart();
    }

    public static void initStart() {
        Thread t;
        log.info("Starting on OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ", build " + VfrUtil.getBuildNumber() + ", java " + System.getProperty("java.version"));
        SettingsBean.getInstance().loadParams();
        LookAndFeelUtil.initLookAndFeelTheme();
        Messages.getInstance().loadResources(SettingsBean.getInstance().getParamLanguage());
        if (!SettingsBean.getInstance().isOfflineMode() && UrlUtil.isOffline()) {
            log.info("Couldn't access Internet, setting offline mode");
            SettingsBean.getInstance().setOfflineMode(true);
        }
        SplashScreenDialog.getInstance().start();
        boolean continueToApp = true;
        if (SettingsBean.getInstance().isParamShowTermsOfUseScreen()) {
            TermsOfUseDialog termsOfUse = new TermsOfUseDialog();
            termsOfUse.setVisible(true);
            int chosenLang = Constants.LANGUAGE_MAPPINGS.get(termsOfUse.getLanguage().toUpperCase());
            if (chosenLang != SettingsBean.getInstance().getParamLanguage()) {
                SettingsBean.getInstance().setParamLanguage(chosenLang);
                Messages.getInstance().loadResources(SettingsBean.getInstance().getParamLanguage());
            }
            continueToApp = termsOfUse.isContinueToApp();
        }
        if (continueToApp) {
            t = new Thread(new VfrInitTask());
            t.start();
        } else {
            t = new Thread(new VfrShutdownTask());
            t.start();
        }
    }

    public static void initFinished() {
        SplashScreenDialog.getInstance().stop();
        SettingsBean.getInstance().setParamFirstRun(false);
    }

    public static void exit() {
        System.exit(0);
    }
}

