/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight;

import java.util.Arrays;
import java.util.LinkedList;

public class Path {
    private static final String PATH_SEPARATOR = "/";
    private static final String PARENT_COMMAND = "..";
    private LinkedList<String> pathStructure = new LinkedList();

    public Path(String path) {
        this.pathStructure = Path.explodePath(path);
    }

    public String getPath() {
        if (this.pathStructure.size() == 0) {
            return PATH_SEPARATOR;
        }
        String path = Path.implodePath(this.pathStructure);
        return path.substring(0, path.length() - 1);
    }

    public Path cd(String newPath) {
        LinkedList<String> path = Path.explodePath(newPath);
        LinkedList<String> resultPath = new LinkedList<String>(this.pathStructure);
        for (String el : path) {
            if (PARENT_COMMAND.equals(el)) {
                resultPath.removeLast();
                continue;
            }
            resultPath.addLast(el);
        }
        return new Path(Path.implodePath(resultPath));
    }

    private static LinkedList<String> explodePath(String path) {
        return new LinkedList<String>(Arrays.asList(path.split(PATH_SEPARATOR)));
    }

    private static String implodePath(LinkedList<String> path) {
        StringBuilder sb = new StringBuilder();
        for (String el : path) {
            sb.append(el);
            sb.append(PATH_SEPARATOR);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        Path path = new Path("/a/b/c/d");
        System.out.println(path.cd("../x").getPath());
    }
}

