/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.resources;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import main.java.guru.vfrflight.util.StringUtil;
import org.apache.log4j.Logger;

public class Messages {
    private static final Logger log = Logger.getLogger(Messages.class);
    private static volatile Messages instance = null;
    private ResourceBundle resourceBundle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Messages getInstance() {
        if (instance != null) return instance;
        Class<Messages> clazz = Messages.class;
        synchronized (Messages.class) {
            if (instance != null) return instance;
            instance = new Messages();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Messages() {
    }

    public ResourceBundle getResources(int language) {
        Locale locale = null;
        locale = language == 0 ? new Locale("pl", "PL") : (language == 2 ? new Locale("it", "IT") : (language == 3 ? new Locale("pt", "PT") : (language == 4 ? new Locale("de", "DE") : (language == 5 ? new Locale("es", "ES") : (language == 6 ? new Locale("nl", "NL") : new Locale("en", "EN"))))));
        return ResourceBundle.getBundle("messages", locale);
    }

    public void loadResources(int language) {
        this.resourceBundle = this.getResources(language);
    }

    public String getOptional(String key) {
        String msg = null;
        if (!this.exists(key)) {
            return null;
        }
        try {
            msg = this.get(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return msg;
    }

    public boolean exists(String key) {
        String val = null;
        try {
            val = this.getBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return val != null;
    }

    public String get(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            log.error("Missing resource for " + key, e);
            return "***" + key + "***";
        }
    }

    private ResourceBundle getBundle() {
        if (this.resourceBundle == null) {
            this.loadResources(0);
        }
        return this.resourceBundle;
    }

    public String get(String key, String ... replace) {
        String text = this.resourceBundle.getString(key);
        for (int i = 0; i < replace.length; ++i) {
            text = text.replace("{" + (i + 1) + "}", StringUtil.nullToEmpty(replace[i]));
        }
        return text;
    }
}

