/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import net.beeger.squareness.theme.DefaultSquarenessTheme;
import net.beeger.squareness.theme.SquarenessTheme;

public class PropertiesSquarenessTheme
extends SquarenessTheme {
    private ColorUIResource _desktopColor;
    private ColorUIResource _windowBackgroundColor;
    private ColorUIResource _inactiveWindowBorderColor;
    private ColorUIResource _normalBorderColor;
    private ColorUIResource _disabledBorderColor;
    private ColorUIResource _defaultButtonBorderColor;
    private ColorUIResource _normalControlBackgroundColor;
    private ColorUIResource _selectedControlBackgroundColor;
    private ColorUIResource _selectedControlBackgroundShadowColor;
    private ColorUIResource _progressBarBackgroundColor;
    private ColorUIResource _pressedScrollBarTrackBackgroundColor;
    private ColorUIResource _textInputBackgroundColor;
    private ColorUIResource _textColor;
    private String _themeName;
    private boolean _isDark;

    public PropertiesSquarenessTheme(File propertiesFile) throws LoadException {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
            this.processProperties(properties);
            if (this._themeName == null) {
                this._themeName = propertiesFile.getName();
                if (this._themeName.indexOf(46) > -1) {
                    this._themeName = this._themeName.substring(0, this._themeName.indexOf(46));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PropertiesSquarenessTheme(Properties properties) throws LoadException {
        this.processProperties(properties);
    }

    public PropertiesSquarenessTheme(ResourceBundle resourceBundle) throws LoadException {
        Properties properties = new Properties();
        Enumeration<String> keysEnumeration = resourceBundle.getKeys();
        while (keysEnumeration.hasMoreElements()) {
            String key = resourceBundle.getKeys().nextElement();
            properties.put(key, resourceBundle.getString(key));
        }
        this.processProperties(properties);
    }

    public String getName() {
        return this._themeName;
    }

    public ColorUIResource getDesktopColor() {
        return this._desktopColor;
    }

    public ColorUIResource getWindowBackgroundColor() {
        return this._windowBackgroundColor;
    }

    public ColorUIResource getInactiveWindowBorderColor() {
        return this._inactiveWindowBorderColor;
    }

    public ColorUIResource getNormalBorderColor() {
        return this._normalBorderColor;
    }

    public ColorUIResource getDisabledBorderColor() {
        return this._disabledBorderColor;
    }

    public ColorUIResource getDefaultButtonBorderColor() {
        return this._defaultButtonBorderColor;
    }

    public ColorUIResource getNormalControlBackgroundColor() {
        return this._normalControlBackgroundColor;
    }

    public ColorUIResource getSelectedControlBackgroundColor() {
        return this._selectedControlBackgroundColor;
    }

    public ColorUIResource getSelectedControlBackgroundShadowColor() {
        return this._selectedControlBackgroundShadowColor;
    }

    public ColorUIResource getProgressBarBackgroundColor() {
        return this._progressBarBackgroundColor;
    }

    public ColorUIResource getPressedScrollBarTrackBackgroundColor() {
        return this._pressedScrollBarTrackBackgroundColor;
    }

    public ColorUIResource getTextInputBackgroundColor() {
        return this._textInputBackgroundColor;
    }

    public ColorUIResource getTextColor() {
        return this._textColor;
    }

    public boolean isDark() {
        return this._isDark;
    }

    private void processProperties(Properties properties) throws LoadException {
        DefaultSquarenessTheme defaultTheme = new DefaultSquarenessTheme();
        this._desktopColor = this.getColor("desktopColor", defaultTheme.getDesktopColor(), properties);
        this._windowBackgroundColor = this.getColor("windowBackgroundColor", defaultTheme.getWindowBackgroundColor(), properties);
        this._inactiveWindowBorderColor = this.getColor("inactiveWindowBorderColor", defaultTheme.getInactiveWindowBorderColor(), properties);
        this._normalBorderColor = this.getColor("normalBorderColor", defaultTheme.getNormalBorderColor(), properties);
        this._disabledBorderColor = this.getColor("disabledBorderColor", defaultTheme.getDisabledBorderColor(), properties);
        this._defaultButtonBorderColor = this.getColor("defaultButtonBorderColor", defaultTheme.getDefaultButtonBorderColor(), properties);
        this._normalControlBackgroundColor = this.getColor("normalControlBackgroundColor", defaultTheme.getNormalControlBackgroundColor(), properties);
        this._selectedControlBackgroundColor = this.getColor("selectedControlBackgroundColor", defaultTheme.getSelectedControlBackgroundColor(), properties);
        this._selectedControlBackgroundShadowColor = this.getColor("selectedControlBackgroundShadowColor", defaultTheme.getSelectedControlBackgroundShadowColor(), properties);
        this._progressBarBackgroundColor = this.getColor("progressBarBackgroundColor", defaultTheme.getProgressBarBackgroundColor(), properties);
        this._pressedScrollBarTrackBackgroundColor = this.getColor("pressedScrollBarTrackBackgroundColor", defaultTheme.getPressedScrollBarTrackBackgroundColor(), properties);
        this._textInputBackgroundColor = this.getColor("textInputBackgroundColor", defaultTheme.getTextInputBackgroundColor(), properties);
        this._textColor = this.getColor("textColor", defaultTheme.getTextColor(), properties);
        this._themeName = properties.getProperty("themeName");
        this._isDark = Boolean.valueOf(properties.getProperty("isDark", "false"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColorUIResource getColor(String colorName, ColorUIResource defaultValue, Properties properties) throws LoadException {
        ColorUIResource result = null;
        String colorString = properties.getProperty(colorName);
        if (colorString == null) return defaultValue;
        StringTokenizer tokenizer = new StringTokenizer(colorString, ",", false);
        if (tokenizer.countTokens() != 3) throw new LoadException(colorName, "The colordefinition \"" + colorName + " = " + colorString + "\" is incorrect. " + "A colordefinition looks like \"colornamw=r,g,b\" where r, g and b " + "define the red, green and blue components of the color. Each of those " + "must be in the range from 0 to 255.");
        try {
            int red = Integer.parseInt((String)tokenizer.nextElement());
            int green = Integer.parseInt((String)tokenizer.nextElement());
            int blue = Integer.parseInt((String)tokenizer.nextElement());
            if (!this.isValidColorComponent(red)) throw new LoadException(colorName, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            if (!this.isValidColorComponent(green)) throw new LoadException(colorName, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            if (!this.isValidColorComponent(blue)) throw new LoadException(colorName, "The colordefinition contains one or more wrong color components. A colordefinition looks like \"colornamw=r,g,b\" where r, g and b define the red, green and blue components of the color. Each of those must be in the range from 0 to 255.");
            return new ColorUIResource(red, green, blue);
        }
        catch (NumberFormatException e) {
            throw new LoadException(colorName, "The colordefinition \"" + colorName + " = " + colorString + "\" is incorrect. " + "A colordefinition looks like \"colornamw=r,g,b\" where r, g and b " + "define the red, green and blue components of the color. Each of those " + "must be in the range from 0 to 255.");
        }
    }

    private boolean isValidColorComponent(int colorComponent) {
        return colorComponent >= 0 && colorComponent <= 255;
    }

    public static class LoadException
    extends Exception {
        public LoadException(String propertyEntryName, String message) {
            super("Error on loading property " + propertyEntryName + " : " + message);
        }
    }
}

