/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyButtonUI;
import de.muntjak.tinylookandfeel.TinyInternalFrameTitlePane;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import de.muntjak.tinylookandfeel.borders.TinyFrameBorder;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class TinyWindowButtonUI
extends TinyButtonUI {
    private static final HashMap cache = new HashMap();
    protected static final Dimension frameExternalButtonSize = new Dimension(21, 21);
    protected static final Dimension frameInternalButtonSize = new Dimension(17, 17);
    protected static final Dimension framePaletteButtonSize = new Dimension(13, 13);
    private int type;
    public static final int CLOSE = 0;
    public static final int MAXIMIZE = 1;
    public static final int MINIMIZE = 2;
    public static final String EXTERNAL_FRAME_BUTTON_KEY = "externalFrameButton";
    public static final String DISABLED_WINDOW_BUTTON_KEY = "disabledWindowButton";

    public static void clearCache() {
        cache.clear();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        throw new IllegalStateException("Must not be used this way.");
    }

    TinyWindowButtonUI(int n) {
        this.type = n;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setBorder(null);
        abstractButton.setFocusable(false);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = false;
        boolean bl2 = false;
        Container container = jComponent.getParent();
        if (container instanceof TinyInternalFrameTitlePane) {
            bl = ((TinyInternalFrameTitlePane)container).isFrameSelected();
            bl2 = ((TinyInternalFrameTitlePane)container).isFrameMaximized();
        } else if (container instanceof TinyTitlePane) {
            bl = ((TinyTitlePane)container).isSelected();
            bl2 = ((TinyTitlePane)container).isFrameMaximized();
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        ColorUIResource colorUIResource = null;
        colorUIResource = !bl ? (abstractButton.isEnabled() ? (abstractButton.getModel().isPressed() ? (this.type == 0 ? Theme.frameButtClosePressedColor.getColor() : Theme.frameButtPressedColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())) : (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor())) : (abstractButton.getModel().isPressed() ? (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed() ? (this.type == 0 ? Theme.frameButtClosePressedColor.getColor() : Theme.frameButtPressedColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())) : (abstractButton.getModel().isRollover() ? (this.type == 0 ? Theme.frameButtCloseRolloverColor.getColor() : Theme.frameButtRolloverColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor())));
        graphics.setColor(colorUIResource);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpButtonNoCache(graphics, abstractButton, colorUIResource, n, n2, bl, bl2);
        } else {
            this.drawXpButton(graphics, abstractButton, colorUIResource, n, n2, bl, bl2);
        }
    }

    private void drawXpButton(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl, boolean bl2) {
        ButtonKey buttonKey = new ButtonKey(color, n, this.type, abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed(), abstractButton.getModel().isPressed(), bl, bl2);
        Object v = cache.get(buttonKey);
        if (v != null) {
            graphics.drawImage((Image)v, 0, 0, abstractButton);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(graphics.getColor());
        if (abstractButton.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeButton(graphics2, abstractButton, color, n, n2, bl);
        } else {
            graphics2.fillRect(1, 1, n - 2, n2 - 2);
            if (bl) {
                graphics2.setColor(TinyInternalFrameBorder.frameUpperColor);
                graphics2.drawLine(0, 0, n - 1, 0);
                graphics2.drawLine(0, 1, 0, 1);
                graphics2.drawLine(n - 1, 1, n - 1, 1);
                graphics2.setColor(TinyInternalFrameBorder.frameLowerColor);
                graphics2.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics2.drawLine(0, n2 - 2, 0, n2 - 2);
                graphics2.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
            } else {
                graphics2.setColor(TinyInternalFrameBorder.disabledUpperColor);
                graphics2.drawLine(0, 0, n - 1, 0);
                graphics2.drawLine(0, 1, 0, 1);
                graphics2.drawLine(n - 1, 1, n - 1, 1);
                graphics2.setColor(TinyInternalFrameBorder.disabledLowerColor);
                graphics2.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics2.drawLine(0, n2 - 2, 0, n2 - 2);
                graphics2.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
            }
            Color color2 = null;
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseBorderDisabledColor.getColor() : Theme.frameButtBorderDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseBorderColor.getColor() : Theme.frameButtBorderColor.getColor());
            DrawRoutines.drawRoundedBorder(graphics2, color2, 0, 0, n, n2);
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor());
            graphics2.setColor(color2);
            graphics2.drawLine(2, 1, n - 3, 1);
            graphics2.drawLine(1, 2, 1, n2 - 3);
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? ColorRoutines.darken(Theme.frameButtCloseColor.getColor(), 20) : ColorRoutines.darken(Theme.frameButtColor.getColor(), 20));
            graphics2.setColor(color2);
            graphics2.drawLine(n - 2, 2, n - 2, n2 - 3);
            graphics2.drawLine(2, n2 - 2, n - 3, n2 - 2);
        }
        if (!abstractButton.isEnabled()) {
            if (this.type == 0) {
                graphics2.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
            } else {
                graphics2.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (this.type == 0) {
            graphics2.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            graphics2.setColor(Theme.frameSymbolColor.getColor());
        }
        this.drawXpSymbol(graphics2, abstractButton, color, n, n2, bl, bl2);
        graphics2.dispose();
        graphics.drawImage(bufferedImage, 0, 0, abstractButton);
        cache.put(buttonKey, bufferedImage);
    }

    private void drawXpButtonNoCache(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl, boolean bl2) {
        if (abstractButton.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeButton(graphics, abstractButton, color, n, n2, bl);
        } else {
            graphics.fillRect(1, 1, n - 2, n2 - 2);
            if (bl) {
                graphics.setColor(TinyInternalFrameBorder.frameUpperColor);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 1, 0, 1);
                graphics.drawLine(n - 1, 1, n - 1, 1);
                graphics.setColor(TinyInternalFrameBorder.frameLowerColor);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 2, 0, n2 - 2);
                graphics.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
            } else {
                graphics.setColor(TinyInternalFrameBorder.disabledUpperColor);
                graphics.drawLine(0, 0, n - 1, 0);
                graphics.drawLine(0, 1, 0, 1);
                graphics.drawLine(n - 1, 1, n - 1, 1);
                graphics.setColor(TinyInternalFrameBorder.disabledLowerColor);
                graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                graphics.drawLine(0, n2 - 2, 0, n2 - 2);
                graphics.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
            }
            Color color2 = null;
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseBorderDisabledColor.getColor() : Theme.frameButtBorderDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseBorderColor.getColor() : Theme.frameButtBorderColor.getColor());
            DrawRoutines.drawWindowButtonBorder(graphics, color2, 0, 0, n, n2);
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? Theme.frameButtCloseColor.getColor() : Theme.frameButtColor.getColor());
            graphics.setColor(color2);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.drawLine(1, 2, 1, n2 - 3);
            color2 = !abstractButton.isEnabled() ? (this.type == 0 ? Theme.frameButtCloseDisabledColor.getColor() : Theme.frameButtDisabledColor.getColor()) : (this.type == 0 ? ColorRoutines.darken(Theme.frameButtCloseColor.getColor(), 20) : ColorRoutines.darken(Theme.frameButtColor.getColor(), 20));
            graphics.setColor(color2);
            graphics.drawLine(n - 2, 2, n - 2, n2 - 3);
            graphics.drawLine(2, n2 - 2, n - 3, n2 - 2);
        }
        if (!abstractButton.isEnabled()) {
            if (this.type == 0) {
                graphics.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (this.type == 0) {
            graphics.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            graphics.setColor(Theme.frameSymbolColor.getColor());
        }
        this.drawXpSymbol(graphics, abstractButton, color, n, n2, bl, bl2);
    }

    private void drawXpLargeButton(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl) {
        boolean bl2;
        graphics.drawLine(1, 2, 1, n2 - 2);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.drawLine(n - 2, n2 - 2, n - 2, n2 - 2);
        boolean bl3 = bl2 = abstractButton.getClientProperty(DISABLED_WINDOW_BUTTON_KEY) == Boolean.TRUE;
        if (bl2) {
            graphics.setColor(TinyFrameBorder.buttonUpperDisabledColor);
        } else {
            graphics.setColor(TinyTitlePane.buttonUpperColor);
        }
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 1, 0, 1);
        graphics.drawLine(n - 1, 1, n - 1, 1);
        if (bl2) {
            graphics.setColor(TinyFrameBorder.buttonLowerDisabledColor);
        } else {
            graphics.setColor(TinyTitlePane.buttonLowerColor);
        }
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(0, n2 - 2, 0, n2 - 2);
        graphics.drawLine(n - 1, n2 - 2, n - 1, n2 - 2);
        if (bl2) {
            graphics.setColor(ColorRoutines.darken(color, 14));
        } else {
            graphics.setColor(ColorRoutines.darken(color, 28));
        }
        graphics.drawLine(n - 2, 2, n - 2, n2 - 3);
        graphics.drawLine(2, n2 - 2, n - 3, n2 - 2);
        int n3 = Theme.frameButtSpreadLight.getValue();
        int n4 = Theme.frameButtSpreadDark.getValue();
        if (!abstractButton.isEnabled()) {
            if (this.type == 0) {
                n3 = Theme.frameButtCloseSpreadLightDisabled.getValue();
                n4 = Theme.frameButtCloseSpreadDarkDisabled.getValue();
            } else {
                n3 = Theme.frameButtSpreadLightDisabled.getValue();
                n4 = Theme.frameButtSpreadDarkDisabled.getValue();
            }
        } else if (this.type == 0) {
            n3 = Theme.frameButtCloseSpreadLight.getValue();
            n4 = Theme.frameButtCloseSpreadDark.getValue();
        }
        float f = 10.0f * (float)n3 / (float)(n2 - 5);
        float f2 = 10.0f * (float)n4 / (float)(n2 - 5);
        int n5 = n2 / 2;
        for (int i = 2; i < n2 - 2; ++i) {
            int n6;
            if (i < n5) {
                n6 = n5 - i;
                graphics.setColor(ColorRoutines.lighten(color, (int)((float)n6 * f)));
            } else if (i == n5) {
                graphics.setColor(color);
            } else {
                n6 = i - n5;
                graphics.setColor(ColorRoutines.darken(color, (int)((float)n6 * f2)));
            }
            graphics.drawLine(2, i, n - 3, i);
        }
        if (!abstractButton.isEnabled()) {
            if (this.type == 0) {
                DrawRoutines.drawWindowButtonBorder(graphics, Theme.frameButtCloseBorderDisabledColor.getColor(), 0, 0, n, n2);
            } else {
                DrawRoutines.drawWindowButtonBorder(graphics, Theme.frameButtBorderDisabledColor.getColor(), 0, 0, n, n2);
            }
        } else if (this.type == 0) {
            DrawRoutines.drawWindowButtonBorder(graphics, Theme.frameButtCloseBorderColor.getColor(), 0, 0, n, n2);
        } else {
            DrawRoutines.drawWindowButtonBorder(graphics, Theme.frameButtBorderColor.getColor(), 0, 0, n, n2);
        }
    }

    private void drawXpSymbol(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl, boolean bl2) {
        if (abstractButton.getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            this.drawXpLargeSymbol(graphics, abstractButton, color, n, n2, bl, bl2);
            return;
        }
        if (abstractButton.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)abstractButton.getParent()).isPalette()) {
            this.drawXpSmallSymbol(graphics, abstractButton, color, n, n2, bl, bl2);
            return;
        }
        if (!bl) {
            if (abstractButton.isEnabled() && !abstractButton.getModel().isPressed()) {
                if (this.type == 0) {
                    graphics.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (abstractButton.getModel().isPressed()) {
                    graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (abstractButton.getModel().isPressed()) {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (abstractButton.getModel().isPressed() && (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed())) {
            if (this.type == 0) {
                graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            graphics.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            graphics.setColor(Theme.frameSymbolColor.getColor());
        }
        int n3 = 0;
        int n4 = 0;
        switch (this.type) {
            case 0: {
                graphics.drawLine(n3 + 4, n4 + 3, n3 + 4, n4 + 3);
                graphics.drawLine(n3 + 12, n4 + 3, n3 + 12, n4 + 3);
                graphics.drawLine(n3 + 3, n4 + 4, n3 + 5, n4 + 4);
                graphics.drawLine(n3 + 11, n4 + 4, n3 + 13, n4 + 4);
                graphics.drawLine(n3 + 4, n4 + 5, n3 + 6, n4 + 5);
                graphics.drawLine(n3 + 10, n4 + 5, n3 + 12, n4 + 5);
                graphics.drawLine(n3 + 5, n4 + 6, n3 + 7, n4 + 6);
                graphics.drawLine(n3 + 9, n4 + 6, n3 + 11, n4 + 6);
                graphics.drawLine(n3 + 6, n4 + 7, n3 + 10, n4 + 7);
                graphics.drawLine(n3 + 7, n4 + 8, n3 + 9, n4 + 8);
                graphics.drawLine(n3 + 4, n4 + 13, n3 + 4, n4 + 13);
                graphics.drawLine(n3 + 12, n4 + 13, n3 + 12, n4 + 13);
                graphics.drawLine(n3 + 3, n4 + 12, n3 + 5, n4 + 12);
                graphics.drawLine(n3 + 11, n4 + 12, n3 + 13, n4 + 12);
                graphics.drawLine(n3 + 4, n4 + 11, n3 + 6, n4 + 11);
                graphics.drawLine(n3 + 10, n4 + 11, n3 + 12, n4 + 11);
                graphics.drawLine(n3 + 5, n4 + 10, n3 + 7, n4 + 10);
                graphics.drawLine(n3 + 9, n4 + 10, n3 + 11, n4 + 10);
                graphics.drawLine(n3 + 6, n4 + 9, n3 + 10, n4 + 9);
                break;
            }
            case 1: {
                if (bl2) {
                    graphics.fillRect(n3 + 5, n4 + 3, 8, 2);
                    graphics.drawLine(n3 + 12, n4 + 5, n3 + 12, n4 + 9);
                    graphics.drawLine(n3 + 11, n4 + 9, n3 + 11, n4 + 9);
                    graphics.drawLine(n3 + 3, n4 + 6, n3 + 9, n4 + 6);
                    graphics.drawRect(n3 + 3, n4 + 7, 6, 5);
                    break;
                }
                graphics.fillRect(n3 + 3, n4 + 3, 11, 2);
                graphics.drawRect(n3 + 3, n4 + 5, 10, 8);
                break;
            }
            case 2: {
                graphics.fillRect(n3 + 3, n4 + 11, 7, 3);
            }
        }
    }

    private void drawXpSmallSymbol(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl, boolean bl2) {
        if (!bl) {
            if (abstractButton.isEnabled() && !abstractButton.getModel().isPressed()) {
                if (this.type == 0) {
                    graphics.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (abstractButton.getModel().isPressed()) {
                    graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (abstractButton.getModel().isPressed()) {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (abstractButton.getModel().isPressed() && (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed())) {
            if (this.type == 0) {
                graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            graphics.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            graphics.setColor(Theme.frameSymbolColor.getColor());
        }
        int n3 = 0;
        int n4 = 0;
        switch (this.type) {
            case 0: {
                graphics.drawLine(n3 + 3, n4 + 2, n3 + 3, n4 + 2);
                graphics.drawLine(n3 + 9, n4 + 2, n3 + 9, n4 + 2);
                graphics.drawLine(n3 + 2, n4 + 3, n3 + 4, n4 + 3);
                graphics.drawLine(n3 + 8, n4 + 3, n3 + 10, n4 + 3);
                graphics.drawLine(n3 + 3, n4 + 4, n3 + 5, n4 + 4);
                graphics.drawLine(n3 + 7, n4 + 4, n3 + 9, n4 + 4);
                graphics.drawLine(n3 + 4, n4 + 5, n3 + 8, n4 + 5);
                graphics.drawLine(n3 + 5, n4 + 6, n3 + 7, n4 + 6);
                graphics.drawLine(n3 + 4, n4 + 7, n3 + 8, n4 + 7);
                graphics.drawLine(n3 + 3, n4 + 8, n3 + 5, n4 + 8);
                graphics.drawLine(n3 + 7, n4 + 8, n3 + 9, n4 + 8);
                graphics.drawLine(n3 + 2, n4 + 9, n3 + 4, n4 + 9);
                graphics.drawLine(n3 + 8, n4 + 9, n3 + 10, n4 + 9);
                graphics.drawLine(n3 + 3, n4 + 10, n3 + 3, n4 + 10);
                graphics.drawLine(n3 + 9, n4 + 10, n3 + 9, n4 + 10);
                break;
            }
            case 1: {
                if (bl2) {
                    graphics.drawRect(n3 + 3, n4 + 6, 4, 3);
                    graphics.drawLine(n3 + 3, n4 + 5, n3 + 7, n4 + 5);
                    graphics.fillRect(n3 + 5, n4 + 2, 5, n4 + 2);
                    graphics.drawLine(n3 + 9, n4 + 4, n3 + 9, n4 + 7);
                    break;
                }
                graphics.drawLine(n3 + 3, n4 + 3, n3 + 9, n4 + 3);
                graphics.drawRect(n3 + 3, n4 + 4, 6, 5);
                break;
            }
            case 2: {
                graphics.fillRect(n3 + 3, n4 + 8, 5, 2);
            }
        }
    }

    private void drawXpLargeSymbol(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, boolean bl, boolean bl2) {
        if (!bl) {
            if (abstractButton.isEnabled() && !abstractButton.getModel().isPressed()) {
                if (this.type == 0) {
                    graphics.setColor(Theme.frameSymbolCloseColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolColor.getColor());
                }
            } else if (this.type == 0) {
                if (abstractButton.getModel().isPressed()) {
                    graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
                } else {
                    graphics.setColor(Theme.frameSymbolCloseDisabledColor.getColor());
                }
            } else if (abstractButton.getModel().isPressed()) {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolDisabledColor.getColor());
            }
        } else if (abstractButton.getModel().isPressed() && (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed())) {
            if (this.type == 0) {
                graphics.setColor(Theme.frameSymbolClosePressedColor.getColor());
            } else {
                graphics.setColor(Theme.frameSymbolPressedColor.getColor());
            }
        } else if (this.type == 0) {
            graphics.setColor(Theme.frameSymbolCloseColor.getColor());
        } else {
            graphics.setColor(Theme.frameSymbolColor.getColor());
        }
        int n3 = 0;
        int n4 = 0;
        switch (this.type) {
            case 0: {
                graphics.drawLine(n3 + 5, n4 + 5, n3 + 6, n4 + 5);
                graphics.drawLine(n3 + 14, n4 + 5, n3 + 15, n4 + 5);
                graphics.drawLine(n3 + 5, n4 + 6, n3 + 7, n4 + 6);
                graphics.drawLine(n3 + 13, n4 + 6, n3 + 15, n4 + 6);
                graphics.drawLine(n3 + 6, n4 + 7, n3 + 8, n4 + 7);
                graphics.drawLine(n3 + 12, n4 + 7, n3 + 14, n4 + 7);
                graphics.drawLine(n3 + 7, n4 + 8, n3 + 9, n4 + 8);
                graphics.drawLine(n3 + 11, n4 + 8, n3 + 13, n4 + 8);
                graphics.drawLine(n3 + 8, n4 + 9, n3 + 12, n4 + 9);
                graphics.drawLine(n3 + 9, n4 + 10, n3 + 11, n4 + 10);
                graphics.drawLine(n3 + 5, n4 + 15, n3 + 6, n4 + 15);
                graphics.drawLine(n3 + 14, n4 + 15, n3 + 15, n4 + 15);
                graphics.drawLine(n3 + 5, n4 + 14, n3 + 7, n4 + 14);
                graphics.drawLine(n3 + 13, n4 + 14, n3 + 15, n4 + 14);
                graphics.drawLine(n3 + 6, n4 + 13, n3 + 8, n4 + 13);
                graphics.drawLine(n3 + 12, n4 + 13, n3 + 14, n4 + 13);
                graphics.drawLine(n3 + 7, n4 + 12, n3 + 9, n4 + 12);
                graphics.drawLine(n3 + 11, n4 + 12, n3 + 13, n4 + 12);
                graphics.drawLine(n3 + 8, n4 + 11, n3 + 12, n4 + 11);
                break;
            }
            case 1: {
                if (bl2) {
                    graphics.drawLine(n3 + 8, n4 + 6, n3 + 13, n4 + 6);
                    graphics.drawLine(n3 + 5, n4 + 10, n3 + 10, n4 + 10);
                    break;
                }
                graphics.fillRect(n3 + 5, n4 + 6, 10, 2);
                break;
            }
            case 2: {
                graphics.fillRect(n3 + 5, n4 + 14, 6, 2);
            }
        }
        ColorUIResource colorUIResource = null;
        colorUIResource = abstractButton.isEnabled() ? Theme.frameSymbolLightColor.getColor() : Theme.frameSymbolLightDisabledColor.getColor();
        graphics.setColor(colorUIResource);
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (bl2) {
                    graphics.drawLine(n3 + 7, n4 + 6, n3 + 7, n4 + 8);
                    graphics.drawLine(n3 + 9, n4 + 7, n3 + 13, n4 + 7);
                    graphics.drawLine(n3 + 13, n4 + 8, n3 + 13, n4 + 10);
                    graphics.drawLine(n3 + 12, n4 + 12, n3 + 14, n4 + 12);
                    graphics.drawLine(n3 + 4, n4 + 10, n3 + 4, n4 + 16);
                    graphics.drawLine(n3 + 5, n4 + 16, n3 + 11, n4 + 16);
                    graphics.drawLine(n3 + 6, n4 + 11, n3 + 10, n4 + 11);
                    graphics.drawLine(n3 + 10, n4 + 12, n3 + 10, n4 + 14);
                    break;
                }
                graphics.drawLine(n3 + 4, n4 + 6, n3 + 4, n4 + 15);
                graphics.drawLine(n3 + 4, n4 + 16, n3 + 15, n4 + 16);
                graphics.drawLine(n3 + 6, n4 + 8, n3 + 13, n4 + 8);
                graphics.drawLine(n3 + 14, n4 + 8, n3 + 14, n4 + 14);
                break;
            }
            case 2: {
                graphics.drawLine(n3 + 4, n4 + 13, n3 + 4, n4 + 16);
                graphics.drawLine(n3 + 5, n4 + 16, n3 + 11, n4 + 16);
            }
        }
        colorUIResource = this.type == 0 ? (abstractButton.isEnabled() ? Theme.frameSymbolCloseDarkColor.getColor() : Theme.frameSymbolCloseDarkDisabledColor.getColor()) : (abstractButton.isEnabled() ? Theme.frameSymbolDarkColor.getColor() : Theme.frameSymbolDarkDisabledColor.getColor());
        graphics.setColor(colorUIResource);
        switch (this.type) {
            case 0: {
                graphics.drawLine(n3 + 5, n4 + 4, n3 + 6, n4 + 4);
                graphics.drawLine(n3 + 14, n4 + 4, n3 + 15, n4 + 4);
                graphics.drawLine(n3 + 7, n4 + 5, n3 + 7, n4 + 5);
                graphics.drawLine(n3 + 13, n4 + 5, n3 + 13, n4 + 5);
                graphics.drawLine(n3 + 8, n4 + 6, n3 + 8, n4 + 6);
                graphics.drawLine(n3 + 12, n4 + 6, n3 + 12, n4 + 6);
                graphics.drawLine(n3 + 9, n4 + 7, n3 + 9, n4 + 7);
                graphics.drawLine(n3 + 11, n4 + 7, n3 + 11, n4 + 7);
                graphics.drawLine(n3 + 10, n4 + 8, n3 + 10, n4 + 8);
                graphics.drawLine(n3 + 8, n4 + 10, n3 + 8, n4 + 10);
                graphics.drawLine(n3 + 12, n4 + 10, n3 + 12, n4 + 10);
                graphics.drawLine(n3 + 7, n4 + 11, n3 + 7, n4 + 11);
                graphics.drawLine(n3 + 13, n4 + 11, n3 + 13, n4 + 11);
                graphics.drawLine(n3 + 6, n4 + 12, n3 + 6, n4 + 12);
                graphics.drawLine(n3 + 14, n4 + 12, n3 + 14, n4 + 12);
                graphics.drawLine(n3 + 5, n4 + 13, n3 + 5, n4 + 13);
                graphics.drawLine(n3 + 15, n4 + 13, n3 + 15, n4 + 13);
                graphics.drawLine(n3 + 4, n4 + 14, n3 + 4, n4 + 14);
                graphics.drawLine(n3 + 16, n4 + 14, n3 + 16, n4 + 14);
                break;
            }
            case 1: {
                if (bl2) {
                    graphics.drawLine(n3 + 8, n4 + 5, n3 + 14, n4 + 5);
                    graphics.drawLine(n3 + 14, n4 + 6, n3 + 14, n4 + 11);
                    graphics.drawLine(n3 + 12, n4 + 11, n3 + 13, n4 + 11);
                    graphics.drawLine(n3 + 8, n4 + 7, n3 + 8, n4 + 8);
                    graphics.drawLine(n3 + 5, n4 + 9, n3 + 11, n4 + 9);
                    graphics.drawLine(n3 + 11, n4 + 10, n3 + 11, n4 + 15);
                    graphics.drawLine(n3 + 5, n4 + 15, n3 + 10, n4 + 15);
                    graphics.drawLine(n3 + 5, n4 + 11, n3 + 5, n4 + 14);
                    break;
                }
                graphics.drawLine(n3 + 5, n4 + 5, n3 + 14, n4 + 5);
                graphics.drawLine(n3 + 15, n4 + 5, n3 + 15, n4 + 15);
                graphics.drawLine(n3 + 5, n4 + 15, n3 + 14, n4 + 15);
                graphics.drawLine(n3 + 5, n4 + 8, n3 + 5, n4 + 14);
                break;
            }
            case 2: {
                graphics.drawLine(n3 + 5, n4 + 13, n3 + 10, n4 + 13);
                graphics.drawLine(n3 + 11, n4 + 13, n3 + 11, n4 + 15);
            }
        }
    }

    public static TinyWindowButtonUI createButtonUIForType(int n) {
        return new TinyWindowButtonUI(n);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (((AbstractButton)jComponent).getClientProperty(EXTERNAL_FRAME_BUTTON_KEY) == Boolean.TRUE) {
            return frameExternalButtonSize;
        }
        if (jComponent.getParent() instanceof TinyInternalFrameTitlePane && ((TinyInternalFrameTitlePane)jComponent.getParent()).isPalette()) {
            return framePaletteButtonSize;
        }
        return frameInternalButtonSize;
    }

    private static class ButtonKey {
        private Color background;
        private int size;
        private int type;
        private boolean rollover;
        private boolean pressed;
        private boolean frameSelected;
        private boolean frameMaximized;

        ButtonKey(Color color, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.background = color;
            this.size = n;
            this.type = n2 + 1;
            this.rollover = bl;
            this.pressed = bl2;
            this.frameSelected = bl3;
            this.frameMaximized = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ButtonKey)) {
                return false;
            }
            ButtonKey buttonKey = (ButtonKey)object;
            return this.size == buttonKey.size && this.type == buttonKey.type && this.rollover == buttonKey.rollover && this.pressed == buttonKey.pressed && this.frameSelected == buttonKey.frameSelected && this.frameMaximized == buttonKey.frameMaximized && this.background.equals(buttonKey.background);
        }

        public int hashCode() {
            return this.background.hashCode() * this.type * this.size * (this.rollover ? 2 : 1) * (this.pressed ? 8 : 4) * (this.frameSelected ? 32 : 16) * (this.frameMaximized ? 128 : 64);
        }
    }
}

