/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.BoundingArea;
import com.grum.geocalc.Point;
import com.grum.geocalc.RadianCoordinate;

public class EarthCalc {
    public static final double EARTH_DIAMETER = 6371010.0;

    public static double getDistance(Point standPoint, Point forePoint) {
        double diffLongitudes = Math.toRadians(Math.abs(forePoint.longitude - standPoint.longitude));
        double slat = Math.toRadians(standPoint.latitude);
        double flat = Math.toRadians(forePoint.latitude);
        double c = Math.acos(Math.sin(slat) * Math.sin(flat) + Math.cos(slat) * Math.cos(flat) * Math.cos(diffLongitudes));
        return 6371010.0 * c;
    }

    public static double getHarvesineDistance(Point standPoint, Point forePoint) {
        double diffLongitudes = Math.toRadians(Math.abs(forePoint.longitude - standPoint.longitude));
        double slat = Math.toRadians(standPoint.latitude);
        double flat = Math.toRadians(forePoint.latitude);
        double diffLatitudes = Math.toRadians(Math.abs(forePoint.latitude - standPoint.latitude));
        double a = Math.sin(diffLatitudes / 2.0) * Math.sin(diffLatitudes / 2.0) + Math.cos(slat) * Math.cos(flat) * Math.sin(diffLongitudes / 2.0) * Math.sin(diffLongitudes / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371010.0 * c;
    }

    private static Vincenty getVincenty(Point standPoint, Point forePoint) {
        double cos\u03bb;
        double sin\u03bb;
        double \u03bb\u02b9;
        double cos\u03c3;
        double cos2\u03c3M;
        double sin\u03c3;
        double \u03c3;
        double sin\u03b1;
        double cosSq\u03b1;
        double C;
        double \u03bb1 = Math.toRadians(standPoint.longitude);
        double \u03bb2 = Math.toRadians(forePoint.longitude);
        double \u03c61 = Math.toRadians(standPoint.latitude);
        double \u03c62 = Math.toRadians(forePoint.latitude);
        double a = 6378137.0;
        double b = 6356752.314245;
        double f = 0.0033528106647474805;
        double L = \u03bb2 - \u03bb1;
        double tanU1 = (1.0 - f) * Math.tan(\u03c61);
        double cosU1 = 1.0 / Math.sqrt(1.0 + tanU1 * tanU1);
        double sinU1 = tanU1 * cosU1;
        double tanU2 = (1.0 - f) * Math.tan(\u03c62);
        double cosU2 = 1.0 / Math.sqrt(1.0 + tanU2 * tanU2);
        double sinU2 = tanU2 * cosU2;
        double \u03bb = L;
        double iterationLimit = 100.0;
        do {
            double sinSq\u03c3;
            if ((sin\u03c3 = Math.sqrt(sinSq\u03c3 = cosU2 * (sin\u03bb = Math.sin(\u03bb)) * (cosU2 * sin\u03bb) + (cosU1 * sinU2 - sinU1 * cosU2 * (cos\u03bb = Math.cos(\u03bb))) * (cosU1 * sinU2 - sinU1 * cosU2 * cos\u03bb))) == 0.0) {
                return new Vincenty(0.0, 0.0, 0.0);
            }
            cos\u03c3 = sinU1 * sinU2 + cosU1 * cosU2 * cos\u03bb;
            \u03c3 = Math.atan2(sin\u03c3, cos\u03c3);
            sin\u03b1 = cosU1 * cosU2 * sin\u03bb / sin\u03c3;
            cosSq\u03b1 = 1.0 - sin\u03b1 * sin\u03b1;
            cos2\u03c3M = cos\u03c3 - 2.0 * sinU1 * sinU2 / cosSq\u03b1;
            if (!Double.isNaN(cos2\u03c3M)) continue;
            cos2\u03c3M = 0.0;
        } while (Math.abs((\u03bb = L + (1.0 - (C = f / 16.0 * cosSq\u03b1 * (4.0 + f * (4.0 - 3.0 * cosSq\u03b1)))) * f * sin\u03b1 * (\u03c3 + C * sin\u03c3 * (cos2\u03c3M + C * cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M)))) - (\u03bb\u02b9 = \u03bb)) > 1.0E-12 && (iterationLimit -= 1.0) > 0.0);
        if (iterationLimit == 0.0) {
            throw new IllegalStateException("Formula failed to converge");
        }
        double uSq = cosSq\u03b1 * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double \u0394\u03c3 = B * sin\u03c3 * (cos2\u03c3M + B / 4.0 * (cos\u03c3 * (-1.0 + 2.0 * cos2\u03c3M * cos2\u03c3M) - B / 6.0 * cos2\u03c3M * (-3.0 + 4.0 * sin\u03c3 * sin\u03c3) * (-3.0 + 4.0 * cos2\u03c3M * cos2\u03c3M)));
        double distance = b * A * (\u03c3 - \u0394\u03c3);
        double initialBearing = Math.atan2(cosU2 * sin\u03bb, cosU1 * sinU2 - sinU1 * cosU2 * cos\u03bb);
        initialBearing = (initialBearing + Math.PI * 2) % (Math.PI * 2);
        double finalBearing = Math.atan2(cosU1 * sin\u03bb, -sinU1 * cosU2 + cosU1 * sinU2 * cos\u03bb);
        finalBearing = (finalBearing + Math.PI * 2) % (Math.PI * 2);
        return new Vincenty(distance, Math.toDegrees(initialBearing), Math.toDegrees(finalBearing));
    }

    public static double getVincentyDistance(Point standPoint, Point forePoint) {
        return EarthCalc.getVincenty((Point)standPoint, (Point)forePoint).distance;
    }

    public static double getVincentyBearing(Point standPoint, Point forePoint) {
        return EarthCalc.getVincenty((Point)standPoint, (Point)forePoint).initialBearing;
    }

    public static double getVincentyFinalBearing(Point standPoint, Point forePoint) {
        return EarthCalc.getVincenty((Point)standPoint, (Point)forePoint).finalBearing;
    }

    public static Point pointRadialDistance(Point standPoint, double bearing, double distance) {
        double rlat1 = Math.toRadians(standPoint.latitude);
        double rlon1 = Math.toRadians(standPoint.longitude);
        double rbearing = Math.toRadians(bearing);
        double rdistance = distance / 6371010.0;
        double lat2 = Math.asin(Math.sin(rlat1) * Math.cos(rdistance) + Math.cos(rlat1) * Math.sin(rdistance) * Math.cos(rbearing));
        double lon2 = rlon1 + Math.atan2(Math.sin(rbearing) * Math.sin(rdistance) * Math.cos(rlat1), Math.cos(rdistance) - Math.sin(rlat1) * Math.sin(lat2));
        return new Point(new RadianCoordinate(lat2), new RadianCoordinate(lon2));
    }

    public static double getBearing(Point standPoint, Point forePoint) {
        double y = Math.sin(Math.toRadians(forePoint.longitude - standPoint.longitude)) * Math.cos(Math.toRadians(forePoint.latitude));
        double x = Math.cos(Math.toRadians(standPoint.latitude)) * Math.sin(Math.toRadians(forePoint.latitude)) - Math.sin(Math.toRadians(standPoint.latitude)) * Math.cos(Math.toRadians(forePoint.latitude)) * Math.cos(Math.toRadians(forePoint.longitude - standPoint.longitude));
        double bearing = (Math.atan2(y, x) + Math.PI * 2) % (Math.PI * 2);
        return Math.toDegrees(bearing);
    }

    public static BoundingArea getBoundingArea(Point standPoint, double distance) {
        Point northWest = EarthCalc.pointRadialDistance(standPoint, 45.0, distance);
        Point southEast = EarthCalc.pointRadialDistance(standPoint, 225.0, distance);
        return new BoundingArea(northWest, southEast);
    }

    private static class Vincenty {
        double distance;
        double initialBearing;
        double finalBearing;

        public Vincenty(double distance, double initialBearing, double finalBearing) {
            this.distance = distance;
            this.initialBearing = initialBearing;
            this.finalBearing = finalBearing;
        }
    }
}

