/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.DMSCoordinate;
import com.grum.geocalc.DegreeCoordinate;
import com.grum.geocalc.GPSCoordinate;
import com.grum.geocalc.RadianCoordinate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public abstract class Coordinate
implements Serializable {
    double decimalDegrees;

    public double getValue() {
        return this.decimalDegrees;
    }

    public double getDecimalDegrees() {
        return this.decimalDegrees;
    }

    public String toString() {
        return "DegreeCoordinate{decimalDegrees=" + this.decimalDegrees + " degrees}";
    }

    DMSCoordinate getDMSCoordinate() {
        double _wholeDegrees = (int)this.decimalDegrees;
        double remaining = Math.abs(this.decimalDegrees - _wholeDegrees);
        double _minutes = (int)(remaining * 60.0);
        remaining = remaining * 60.0 - _minutes;
        double _seconds = new BigDecimal(remaining * 60.0).setScale(4, RoundingMode.HALF_UP).doubleValue();
        return new DMSCoordinate(_wholeDegrees, _minutes, _seconds);
    }

    DegreeCoordinate getDegreeCoordinate() {
        return new DegreeCoordinate(this.decimalDegrees);
    }

    GPSCoordinate getGPSCoordinate() {
        double _wholeDegrees = Math.floor(this.decimalDegrees);
        double remaining = this.decimalDegrees - _wholeDegrees;
        double _minutes = Math.floor(remaining * 60.0);
        return new GPSCoordinate(_wholeDegrees, _minutes);
    }

    RadianCoordinate getRadianCoordinate() {
        return new RadianCoordinate(Math.toRadians(this.decimalDegrees));
    }
}

