/*
 * Decompiled with CFR 0.152.
 */
package com.grum.geocalc;

import com.grum.geocalc.DegreeCoordinate;
import com.grum.geocalc.Point;
import org.apache.log4j.Logger;

public class BoundingArea {
    private Logger logger = Logger.getLogger(this.getClass());
    private Point northEast;
    private Point southWest;
    private Point southEast;
    private Point northWest;

    public BoundingArea(Point northEast, Point southWest) {
        this.northEast = northEast;
        this.southWest = southWest;
        this.southEast = new Point(new DegreeCoordinate(southWest.getLatitude()), new DegreeCoordinate(northEast.getLongitude()));
        this.northWest = new Point(new DegreeCoordinate(northEast.getLatitude()), new DegreeCoordinate(southWest.getLongitude()));
    }

    @Deprecated
    public Point getBottomRight() {
        this.logger.debug((Object)"getBottomRight() is deprecated. Use getSouthWest() instead.");
        return this.southWest;
    }

    @Deprecated
    public Point getTopLeft() {
        this.logger.debug((Object)"getTopLeft() is deprecated. Use getNorthEast() instead.");
        return this.northEast;
    }

    public Point getNorthEast() {
        return this.northEast;
    }

    public Point getSouthWest() {
        return this.southWest;
    }

    public Point getSouthEast() {
        return this.southEast;
    }

    public Point getNorthWest() {
        return this.northWest;
    }

    public String toString() {
        return "BoundingArea{northEast=" + this.northEast + ", southWest=" + this.southWest + '}';
    }

    public boolean isContainedWithin(Point point) {
        boolean predicate2;
        boolean predicate1;
        boolean bl = predicate1 = point.latitude >= this.southWest.latitude && point.latitude <= this.northEast.latitude;
        if (!predicate1) {
            return false;
        }
        if (this.southWest.longitude > this.northEast.longitude) {
            boolean predicate3 = point.longitude <= this.northEast.longitude && point.longitude >= -180.0;
            boolean predicate4 = point.longitude >= this.southWest.longitude && point.longitude <= 180.0;
            predicate2 = predicate3 || predicate4;
        } else {
            predicate2 = point.longitude >= this.southWest.longitude && point.longitude <= this.northEast.longitude;
        }
        return predicate2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingArea other = (BoundingArea)obj;
        if (!(this.northEast == other.northEast || this.northEast != null && this.northEast.equals(other.northEast))) {
            return false;
        }
        return this.southWest == other.southWest || this.southWest != null && this.southWest.equals(other.southWest);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.northEast != null ? this.northEast.hashCode() : 0);
        hash = 13 * hash + (this.southWest != null ? this.southWest.hashCode() : 0);
        return hash;
    }
}

