/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.sets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationMode;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.sets.PointSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedPointSet
extends PointSet {
    int[] _index;
    List<TriangulationPoint> _constrainedPointList = null;

    public ConstrainedPointSet(List<TriangulationPoint> points, int[] index) {
        super(points);
        this._index = index;
    }

    public ConstrainedPointSet(List<TriangulationPoint> points, List<TriangulationPoint> constraints) {
        super(points);
        this._constrainedPointList = new ArrayList<TriangulationPoint>();
        this._constrainedPointList.addAll(constraints);
    }

    @Override
    public TriangulationMode getTriangulationMode() {
        return TriangulationMode.CONSTRAINED;
    }

    public int[] getEdgeIndex() {
        return this._index;
    }

    public void prepareTriangulation(TriangulationContext tcx) {
        super.prepareTriangulation(tcx);
        if (this._constrainedPointList != null) {
            Iterator<TriangulationPoint> iterator = this._constrainedPointList.iterator();
            while (iterator.hasNext()) {
                TriangulationPoint p1 = iterator.next();
                TriangulationPoint p2 = iterator.next();
                tcx.newConstraint(p1, p2);
            }
        } else {
            int i = 0;
            while (i < this._index.length) {
                tcx.newConstraint((TriangulationPoint)this._points.get(this._index[i]), (TriangulationPoint)this._points.get(this._index[i + 1]));
                i += 2;
            }
        }
    }

    public boolean isValid() {
        return true;
    }
}

