/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.geometry.polygon;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.poly2tri.geometry.polygon.PolygonPoint;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationMode;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
implements Triangulatable {
    private static final Logger logger = LoggerFactory.getLogger(Polygon.class);
    protected ArrayList<TriangulationPoint> _points = new ArrayList();
    protected ArrayList<TriangulationPoint> _steinerPoints;
    protected ArrayList<Polygon> _holes;
    protected List<DelaunayTriangle> m_triangles;
    protected PolygonPoint _last;

    public Polygon(PolygonPoint p1, PolygonPoint p2, PolygonPoint p3) {
        p1._next = p2;
        p2._next = p3;
        p3._next = p1;
        p1._previous = p3;
        p2._previous = p1;
        p3._previous = p2;
        this._points.add(p1);
        this._points.add(p2);
        this._points.add(p3);
    }

    public Polygon(List<PolygonPoint> points) {
        if (points.get(0).equals(points.get(points.size() - 1))) {
            logger.warn("Removed duplicate point");
            points.remove(points.size() - 1);
        }
        this._points.addAll(points);
    }

    public Polygon(PolygonPoint[] points) {
        this(Arrays.asList(points));
    }

    @Override
    public TriangulationMode getTriangulationMode() {
        return TriangulationMode.POLYGON;
    }

    public int pointCount() {
        int count = this._points.size();
        if (this._steinerPoints != null) {
            count += this._steinerPoints.size();
        }
        return count;
    }

    public void addSteinerPoint(TriangulationPoint point) {
        if (this._steinerPoints == null) {
            this._steinerPoints = new ArrayList();
        }
        this._steinerPoints.add(point);
    }

    public void addSteinerPoints(List<TriangulationPoint> points) {
        if (this._steinerPoints == null) {
            this._steinerPoints = new ArrayList();
        }
        this._steinerPoints.addAll(points);
    }

    public void clearSteinerPoints() {
        if (this._steinerPoints != null) {
            this._steinerPoints.clear();
        }
    }

    public void addHole(Polygon poly) {
        if (this._holes == null) {
            this._holes = new ArrayList();
        }
        this._holes.add(poly);
    }

    public void insertPointAfter(PolygonPoint a, PolygonPoint newPoint) {
        int index = this._points.indexOf(a);
        if (index == -1) {
            throw new RuntimeException("Tried to insert a point into a Polygon after a point not belonging to the Polygon");
        }
        newPoint.setNext(a.getNext());
        newPoint.setPrevious(a);
        a.getNext().setPrevious(newPoint);
        a.setNext(newPoint);
        this._points.add(index + 1, newPoint);
    }

    public void addPoints(List<PolygonPoint> list) {
        for (PolygonPoint p : list) {
            p.setPrevious(this._last);
            if (this._last != null) {
                p.setNext(this._last.getNext());
                this._last.setNext(p);
            }
            this._last = p;
            this._points.add(p);
        }
        PolygonPoint first = (PolygonPoint)this._points.get(0);
        this._last.setNext(first);
        first.setPrevious(this._last);
    }

    public void addPoint(PolygonPoint p) {
        p.setPrevious(this._last);
        p.setNext(this._last.getNext());
        this._last.setNext(p);
        this._points.add(p);
    }

    public void removePoint(PolygonPoint p) {
        PolygonPoint next = p.getNext();
        PolygonPoint prev = p.getPrevious();
        prev.setNext(next);
        next.setPrevious(prev);
        this._points.remove(p);
    }

    public PolygonPoint getPoint() {
        return this._last;
    }

    @Override
    public List<TriangulationPoint> getPoints() {
        return this._points;
    }

    @Override
    public List<DelaunayTriangle> getTriangles() {
        return this.m_triangles;
    }

    @Override
    public void addTriangle(DelaunayTriangle t) {
        this.m_triangles.add(t);
    }

    @Override
    public void addTriangles(List<DelaunayTriangle> list) {
        this.m_triangles.addAll(list);
    }

    @Override
    public void clearTriangulation() {
        if (this.m_triangles != null) {
            this.m_triangles.clear();
        }
    }

    @Override
    public void prepareTriangulation(TriangulationContext<?> tcx) {
        if (this.m_triangles == null) {
            this.m_triangles = new ArrayList<DelaunayTriangle>(this._points.size());
        } else {
            this.m_triangles.clear();
        }
        int i = 0;
        while (i < this._points.size() - 1) {
            tcx.newConstraint(this._points.get(i), this._points.get(i + 1));
            ++i;
        }
        tcx.newConstraint(this._points.get(0), this._points.get(this._points.size() - 1));
        tcx.addPoints(this._points);
        if (this._holes != null) {
            for (Polygon p : this._holes) {
                int i2 = 0;
                while (i2 < p._points.size() - 1) {
                    tcx.newConstraint(p._points.get(i2), p._points.get(i2 + 1));
                    ++i2;
                }
                tcx.newConstraint(p._points.get(0), p._points.get(p._points.size() - 1));
                tcx.addPoints(p._points);
            }
        }
        if (this._steinerPoints != null) {
            tcx.addPoints(this._steinerPoints);
        }
    }
}

