/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri;

import org.poly2tri.geometry.polygon.Polygon;
import org.poly2tri.geometry.polygon.PolygonSet;
import org.poly2tri.triangulation.Triangulatable;
import org.poly2tri.triangulation.TriangulationAlgorithm;
import org.poly2tri.triangulation.TriangulationContext;
import org.poly2tri.triangulation.TriangulationProcess;
import org.poly2tri.triangulation.delaunay.sweep.DTSweep;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepContext;
import org.poly2tri.triangulation.sets.ConstrainedPointSet;
import org.poly2tri.triangulation.sets.PointSet;
import org.poly2tri.triangulation.util.PolygonGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Poly2Tri {
    private static final Logger logger = LoggerFactory.getLogger(Poly2Tri.class);
    private static final TriangulationAlgorithm _defaultAlgorithm = TriangulationAlgorithm.DTSweep;

    public static void triangulate(PolygonSet ps) {
        TriangulationContext<?> tcx = Poly2Tri.createContext(_defaultAlgorithm);
        for (Polygon p : ps.getPolygons()) {
            tcx.prepareTriangulation(p);
            Poly2Tri.triangulate(tcx);
            tcx.clear();
        }
    }

    public static void triangulate(Polygon p) {
        Poly2Tri.triangulate(_defaultAlgorithm, p);
    }

    public static void triangulate(ConstrainedPointSet cps) {
        Poly2Tri.triangulate(_defaultAlgorithm, cps);
    }

    public static void triangulate(PointSet ps) {
        Poly2Tri.triangulate(_defaultAlgorithm, ps);
    }

    public static TriangulationContext<?> createContext(TriangulationAlgorithm algorithm) {
        switch (algorithm) {
            default: 
        }
        return new DTSweepContext();
    }

    public static void triangulate(TriangulationAlgorithm algorithm, Triangulatable t) {
        TriangulationContext<?> tcx = Poly2Tri.createContext(algorithm);
        tcx.prepareTriangulation(t);
        Poly2Tri.triangulate(tcx);
    }

    public static void triangulate(TriangulationContext<?> tcx) {
        switch (tcx.algorithm()) {
            default: 
        }
        DTSweep.triangulate((DTSweepContext)tcx);
    }

    public static void warmup() {
        Polygon poly = PolygonGenerator.RandomCircleSweep2(50.0, 50000);
        TriangulationProcess process = new TriangulationProcess();
        process.triangulate(poly);
    }
}

