/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.wrappers;

import flightsim.simconnect.data.InitPosition;
import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.data.MarkerState;
import flightsim.simconnect.data.SimConnectData;
import flightsim.simconnect.data.Waypoint;
import flightsim.simconnect.data.XYZ;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataWrapper
implements DataInput,
DataOutput {
    protected ByteBuffer dataBuffer;

    public DataWrapper(ByteBuffer bf) {
        this.dataBuffer = bf;
    }

    public DataWrapper(int size) {
        this(ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN));
    }

    protected DataWrapper() {
    }

    protected String makeString(ByteBuffer bf, int len) {
        int fZeroPos;
        byte[] tmp = new byte[len];
        bf.get(tmp);
        for (fZeroPos = 0; fZeroPos < len && tmp[fZeroPos] != 0; ++fZeroPos) {
        }
        return new String(tmp, 0, fZeroPos);
    }

    public float getFloat32(int offset) {
        return this.dataBuffer.getFloat(offset);
    }

    public double getFloat64(int offset) {
        return this.dataBuffer.getDouble(offset);
    }

    public int getInt32(int offset) {
        return this.dataBuffer.getInt(offset);
    }

    public long getInt64(int offset) {
        return this.dataBuffer.getLong(offset);
    }

    public String getString8(int offset) {
        return this.getString(offset, 8);
    }

    public String getString32(int offset) {
        return this.getString(offset, 32);
    }

    public String getString64(int offset) {
        return this.getString(offset, 64);
    }

    public String getString128(int offset) {
        return this.getString(offset, 128);
    }

    public String getString256(int offset) {
        return this.getString(offset, 256);
    }

    public String getString260(int offset) {
        return this.getString(offset, 260);
    }

    public String getString(int offset, int len) {
        this.dataBuffer.position(offset);
        return this.makeString(this.dataBuffer, len);
    }

    public String getStringV(int offset) {
        int i = 0;
        while (this.dataBuffer.hasRemaining() && this.dataBuffer.get(offset + i) != 0) {
            ++i;
        }
        return this.makeString(this.dataBuffer, i);
    }

    public <T extends SimConnectData> T getData(T data, int offset) {
        int current = this.dataBuffer.position();
        this.dataBuffer.position(offset);
        data.read(this.dataBuffer);
        this.dataBuffer.position(current);
        return data;
    }

    public InitPosition getInitPosition(int offset) {
        return this.getData(new InitPosition(), offset);
    }

    public MarkerState getMarkerState(int offset) {
        return this.getData(new MarkerState(), offset);
    }

    public Waypoint getWaypoint(int offset) {
        return this.getData(new Waypoint(), offset);
    }

    public LatLonAlt getLatLonAlt(int offset) {
        return this.getData(new LatLonAlt(), offset);
    }

    public XYZ getXYZ(int offset) {
        return this.getData(new XYZ(), offset);
    }

    public float getFloat32() {
        return this.dataBuffer.getFloat();
    }

    public double getFloat64() {
        return this.dataBuffer.getDouble();
    }

    public int getInt32() {
        return this.dataBuffer.getInt();
    }

    public long getInt64() {
        return this.dataBuffer.getLong();
    }

    public String getString8() {
        return this.getString(8);
    }

    public String getString32() {
        return this.getString(32);
    }

    public String getString64() {
        return this.getString(64);
    }

    public String getString128() {
        return this.getString(128);
    }

    public String getString256() {
        return this.getString(256);
    }

    public String getString260() {
        return this.getString(260);
    }

    public String getString(int len) {
        return this.makeString(this.dataBuffer, len);
    }

    public String getStringV() {
        int i = 0;
        int currentOffset = this.dataBuffer.position();
        while (this.dataBuffer.hasRemaining() && this.dataBuffer.get(currentOffset + i) != 0) {
            ++i;
        }
        return this.makeString(this.dataBuffer, i);
    }

    public <T extends SimConnectData> T getData(T data) {
        data.read(this.dataBuffer);
        return data;
    }

    public InitPosition getInitPosition() {
        return this.getData(new InitPosition());
    }

    public MarkerState getMarkerState() {
        return this.getData(new MarkerState());
    }

    public Waypoint getWaypoint() {
        return this.getData(new Waypoint());
    }

    public LatLonAlt getLatLonAlt() {
        return this.getData(new LatLonAlt());
    }

    public XYZ getXYZ() throws BufferUnderflowException {
        return this.getData(new XYZ());
    }

    public void reset() {
        this.dataBuffer.clear();
    }

    public boolean hasRemaining() {
        return this.dataBuffer.hasRemaining();
    }

    public int remaining() {
        return this.dataBuffer.remaining();
    }

    public void putString(String s, int len) {
        byte[] b = s.getBytes();
        this.dataBuffer.put(b, 0, Math.min(len, b.length));
        for (int i = b.length; i < len; ++i) {
            this.dataBuffer.put((byte)0);
        }
    }

    public void putString(int offset, String s, int len) {
        int sp = this.dataBuffer.position();
        this.dataBuffer.position(offset);
        byte[] b = s.getBytes();
        this.dataBuffer.put(b, 0, Math.min(len, b.length));
        for (int i = b.length; i < len; ++i) {
            this.dataBuffer.put((byte)0);
        }
        this.dataBuffer.position(sp);
    }

    public void putFloat64(double value) {
        this.dataBuffer.putDouble(value);
    }

    public void putFloat64(int index, double value) {
        this.dataBuffer.putDouble(index, value);
    }

    public void putFloat32(float value) {
        this.dataBuffer.putFloat(value);
    }

    public void putFloat32(int index, float value) {
        this.dataBuffer.putFloat(index, value);
    }

    public void putInt32(int index, int value) {
        this.dataBuffer.putInt(index, value);
    }

    public void putInt32(int value) {
        this.dataBuffer.putInt(value);
    }

    public void putInt64(int index, long value) {
        this.dataBuffer.putLong(index, value);
    }

    public void putInt64(long value) {
        this.dataBuffer.putLong(value);
    }

    public void putString8(String s) {
        this.putString(s, 8);
    }

    public void putString32(String s) {
        this.putString(s, 32);
    }

    public void putString64(String s) {
        this.putString(s, 64);
    }

    public void putString128(String s) {
        this.putString(s, 128);
    }

    public void putString256(String s) {
        this.putString(s, 256);
    }

    public void putString260(String s) {
        this.putString(s, 260);
    }

    public void putString8(int offset, String s) {
        this.putString(s, 8);
    }

    public void putString32(int offset, String s) {
        this.putString(s, 32);
    }

    public void putString64(int offset, String s) {
        this.putString(s, 64);
    }

    public void putString128(int offset, String s) {
        this.putString(s, 128);
    }

    public void putString256(int offset, String s) {
        this.putString(s, 256);
    }

    public void putString260(int offset, String s) {
        this.putString(s, 260);
    }

    public int putStringV(String s) {
        byte[] b = s.getBytes();
        this.dataBuffer.put(b);
        this.dataBuffer.put((byte)0);
        return b.length + 1;
    }

    public int putStringV(int offset, String s) {
        byte[] b = s.getBytes();
        int sp = this.dataBuffer.position();
        this.dataBuffer.position(offset);
        this.dataBuffer.put(b);
        this.dataBuffer.put((byte)0);
        this.dataBuffer.position(sp);
        return b.length + 1;
    }

    public <T extends SimConnectData> void putData(int offset, T data) {
        int sp = this.dataBuffer.position();
        this.dataBuffer.position(offset);
        data.write(this.dataBuffer);
        this.dataBuffer.position(sp);
    }

    public <T extends SimConnectData> void putData(T data) {
        data.write(this.dataBuffer);
    }

    public void putData(byte[] b) {
        this.dataBuffer.put(b);
    }

    public void putLatLonAlt(LatLonAlt data) {
        this.putData(data);
    }

    public void putInitPosition(InitPosition data) {
        this.putData(data);
    }

    public void putWaypoint(Waypoint data) {
        this.putData(data);
    }

    public void putMarkerState(MarkerState data) {
        this.putData(data);
    }

    public void putXYZ(XYZ data) {
        this.putData(data);
    }

    public void putLatLonAlt(int offset, LatLonAlt data) {
        this.putData(offset, data);
    }

    public void putInitPosition(int offset, InitPosition data) {
        this.putData(offset, data);
    }

    public void putWaypoint(int offset, Waypoint data) {
        this.putData(offset, data);
    }

    public void putMarkerState(int offset, MarkerState data) {
        this.putData(offset, data);
    }

    public void putXYZ(int offset, XYZ data) {
        this.putData(offset, data);
    }

    public byte[] bytes() {
        return this.dataBuffer.array();
    }

    public ByteBuffer getBuffer() {
        this.dataBuffer.flip();
        return this.dataBuffer;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.dataBuffer.getInt() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.dataBuffer.get();
    }

    @Override
    public char readChar() throws IOException {
        return this.dataBuffer.getChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.dataBuffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.dataBuffer.getFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.dataBuffer.get(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.dataBuffer.get(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.dataBuffer.getInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.getStringV();
    }

    @Override
    public long readLong() throws IOException {
        return this.getInt64();
    }

    @Override
    public short readShort() throws IOException {
        return this.dataBuffer.getShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readLine();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.dataBuffer.get() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.dataBuffer.getShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.dataBuffer.position(this.dataBuffer.position() + n);
        return n;
    }

    @Override
    public void write(int b) throws IOException {
        this.dataBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.dataBuffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.dataBuffer.put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dataBuffer.putInt(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dataBuffer.putInt(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.dataBuffer.put(s.getBytes());
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dataBuffer.putChar((char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] sc;
        for (char c : sc = s.toCharArray()) {
            this.writeChar(c);
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dataBuffer.putDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dataBuffer.putFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dataBuffer.putInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dataBuffer.putLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dataBuffer.putShort((short)v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.writeChars(str);
    }
}

