/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.wrappers;

import flightsim.simconnect.Messages;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.data.InitPosition;
import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.data.MarkerState;
import flightsim.simconnect.data.SimConnectData;
import flightsim.simconnect.data.Waypoint;
import flightsim.simconnect.data.XYZ;
import flightsim.simconnect.recv.RecvSimObjectData;
import flightsim.simconnect.wrappers.DataWrapper;
import flightsim.simconnect.wrappers.IllegalDataDefinition;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDefinitionWrapper
extends DataWrapper
implements Iterable<Object> {
    private final List<DataDef> dataDefs = new ArrayList<DataDef>();
    private final SimConnect sc;
    private int totalSize = 0;
    private final int datadefid;

    public DataDefinitionWrapper(SimConnect sc, int dataDefinitionID) throws IOException {
        this.sc = sc;
        this.datadefid = dataDefinitionID;
        this.clearDataDefinition();
    }

    public DataDefinitionWrapper(SimConnect sc) throws IOException {
        this(sc, (int)(Math.random() * 8192.0));
    }

    public int getDataDefinitionID() {
        return this.datadefid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDataDefinition(String variable, String units, SimConnectDataType dataType) throws IOException {
        if (dataType.size() == -1) {
            throw new IllegalArgumentException(Messages.getString("DataDefinitionWrapper.0"));
        }
        DataDefinitionWrapper dataDefinitionWrapper = this;
        synchronized (dataDefinitionWrapper) {
            this.sc.addToDataDefinition(this.datadefid, variable, units, dataType);
            DataDef dd = new DataDef(variable, this.totalSize, dataType);
            this.dataDefs.add(dd);
            this.totalSize += dataType.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataDefinition() throws IOException {
        this.dataBuffer = null;
        DataDefinitionWrapper dataDefinitionWrapper = this;
        synchronized (dataDefinitionWrapper) {
            this.sc.clearDataDefinition(this.datadefid);
            this.dataDefs.clear();
        }
    }

    public void setDataOnSimObject(int objectId) throws IOException, IllegalDataDefinition {
        if (this.dataBuffer == null) {
            throw new IllegalDataDefinition(Messages.getString("DataDefinitionWrapper.1"));
        }
        this.sc.setDataOnSimObject(this.datadefid, objectId, false, 1, this.bytes());
    }

    public void setClientData(int clientDataId) throws IOException, IllegalDataDefinition {
        if (this.dataBuffer == null) {
            throw new IllegalDataDefinition(Messages.getString("DataDefinitionWrapper.2"));
        }
        this.sc.setClientData(clientDataId, this.datadefid, 0, 1, this.totalSize, this.bytes());
    }

    int getOffset(String variable) throws IllegalDataDefinition {
        for (DataDef dd : this.dataDefs) {
            if (!dd.name.equalsIgnoreCase(variable)) continue;
            return dd.offset;
        }
        throw new IllegalDataDefinition(MessageFormat.format(Messages.getString("DataDefinitionWrapper.3"), variable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillEmptyData() {
        DataDefinitionWrapper dataDefinitionWrapper = this;
        synchronized (dataDefinitionWrapper) {
            byte[] rawData = new byte[this.totalSize];
            this.dataBuffer = ByteBuffer.wrap(rawData);
            this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillDataFrom(RecvSimObjectData simObjData) throws IllegalDataDefinition {
        if (simObjData.getDefineID() != this.datadefid) {
            throw new IllegalDataDefinition(MessageFormat.format(Messages.getString("DataDefinitionWrapper.4"), this.datadefid, simObjData.getDefineID()));
        }
        DataDefinitionWrapper dataDefinitionWrapper = this;
        synchronized (dataDefinitionWrapper) {
            byte[] rawData = simObjData.getData();
            if (rawData.length != this.totalSize) {
                throw new IllegalDataDefinition(MessageFormat.format(Messages.getString("DataDefinitionWrapper.5"), rawData.length));
            }
            this.dataBuffer = ByteBuffer.wrap(rawData);
            this.dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new DataIterator();
    }

    public <T extends SimConnectData> T getData(T data, String var) throws IllegalDataDefinition {
        return super.getData(data, this.getOffset(var));
    }

    public float getFloat32(String var) throws IllegalDataDefinition {
        return super.getFloat32(this.getOffset(var));
    }

    public double getFloat64(String var) throws IllegalDataDefinition {
        return super.getFloat64(this.getOffset(var));
    }

    public InitPosition getInitPosition(String var) throws IllegalDataDefinition {
        return super.getInitPosition(this.getOffset(var));
    }

    public int getInt32(String var) throws IllegalDataDefinition {
        return super.getInt32(this.getOffset(var));
    }

    public long getInt64(String var) throws IllegalDataDefinition {
        return super.getInt64(this.getOffset(var));
    }

    public LatLonAlt getLatLonAlt(String var) throws IllegalDataDefinition {
        return super.getLatLonAlt(this.getOffset(var));
    }

    public MarkerState getMarkerState(String var) throws IllegalDataDefinition {
        return super.getMarkerState(this.getOffset(var));
    }

    public String getString128(String var) throws IllegalDataDefinition {
        return super.getString128(this.getOffset(var));
    }

    public String getString256(String var) throws IllegalDataDefinition {
        return super.getString256(this.getOffset(var));
    }

    public String getString260(String var) throws IllegalDataDefinition {
        return super.getString260(this.getOffset(var));
    }

    public String getString32(String var) throws IllegalDataDefinition {
        return super.getString32(this.getOffset(var));
    }

    public String getString64(String var) throws IllegalDataDefinition {
        return super.getString64(this.getOffset(var));
    }

    public String getString8(String var) throws IllegalDataDefinition {
        return super.getString8(this.getOffset(var));
    }

    public Waypoint getWaypoint(String var) throws IllegalDataDefinition {
        return super.getWaypoint(this.getOffset(var));
    }

    public XYZ getXYZ(String var) throws IllegalDataDefinition {
        return super.getXYZ(this.getOffset(var));
    }

    public void putFloat32(String var, float value) throws IllegalDataDefinition {
        super.putFloat32(this.getOffset(var), value);
    }

    public void putFloat64(String var, double value) throws IllegalDataDefinition {
        super.putFloat64(this.getOffset(var), value);
    }

    public void putInitPosition(String var, InitPosition data) throws IllegalDataDefinition {
        super.putInitPosition(this.getOffset(var), data);
    }

    public void putInt32(String var, int value) throws IllegalDataDefinition {
        super.putInt32(this.getOffset(var), value);
    }

    public void putInt64(String var, long value) throws IllegalDataDefinition {
        super.putInt64(this.getOffset(var), value);
    }

    public void putLatLonAlt(String var, LatLonAlt data) throws IllegalDataDefinition {
        super.putLatLonAlt(this.getOffset(var), data);
    }

    public void putMarkerState(String var, MarkerState data) throws IllegalDataDefinition {
        super.putMarkerState(this.getOffset(var), data);
    }

    public void putString128(String var, String s) throws IllegalDataDefinition {
        super.putString128(this.getOffset(var), s);
    }

    public void putString256(String var, String s) throws IllegalDataDefinition {
        super.putString256(this.getOffset(var), s);
    }

    public void putString260(String var, String s) throws IllegalDataDefinition {
        super.putString260(this.getOffset(var), s);
    }

    public void putString32(String var, String s) throws IllegalDataDefinition {
        super.putString32(this.getOffset(var), s);
    }

    public void putString64(String var, String s) throws IllegalDataDefinition {
        super.putString64(this.getOffset(var), s);
    }

    public void putString8(String var, String s) throws IllegalDataDefinition {
        super.putString8(this.getOffset(var), s);
    }

    public void putWaypoint(String var, Waypoint data) throws IllegalDataDefinition {
        super.putWaypoint(this.getOffset(var), data);
    }

    public void putXYZ(String var, XYZ data) throws IllegalDataDefinition {
        super.putXYZ(this.getOffset(var), data);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataIterator
    implements Iterator<Object> {
        private Iterator<DataDef> ddIterator;

        private DataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.ddIterator.hasNext();
        }

        @Override
        public Object next() {
            DataDef dd = this.ddIterator.next();
            switch (dd.type) {
                case FLOAT32: {
                    return Float.valueOf(DataDefinitionWrapper.this.getFloat32(dd.offset));
                }
                case FLOAT64: {
                    return DataDefinitionWrapper.this.getFloat64(dd.offset);
                }
                case INITPOSITION: {
                    return DataDefinitionWrapper.this.getInitPosition(dd.offset);
                }
                case INT32: {
                    return DataDefinitionWrapper.this.getInt32(dd.offset);
                }
                case INT64: {
                    return DataDefinitionWrapper.this.getInt64(dd.offset);
                }
                case LATLONALT: {
                    return DataDefinitionWrapper.this.getLatLonAlt(dd.offset);
                }
                case MARKERSTATE: {
                    return DataDefinitionWrapper.this.getMarkerState(dd.offset);
                }
                case STRING128: {
                    return DataDefinitionWrapper.this.getString128(dd.offset);
                }
                case STRING256: {
                    return DataDefinitionWrapper.this.getString256(dd.offset);
                }
                case STRING260: {
                    return DataDefinitionWrapper.this.getString260(dd.offset);
                }
                case STRING32: {
                    return DataDefinitionWrapper.this.getString32(dd.offset);
                }
                case STRING64: {
                    return DataDefinitionWrapper.this.getString64(dd.offset);
                }
                case STRING8: {
                    return DataDefinitionWrapper.this.getString8(dd.offset);
                }
                case WAYPOINT: {
                    return DataDefinitionWrapper.this.getWaypoint(dd.offset);
                }
                case XYZ: {
                    return DataDefinitionWrapper.this.getXYZ(dd.offset);
                }
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataDef
    implements Comparable<DataDef> {
        String name;
        int offset;
        SimConnectDataType type;

        @Override
        public int compareTo(DataDef o) {
            return this.offset - o.offset;
        }

        DataDef(String name, int offset, SimConnectDataType type) {
            this.name = name;
            this.offset = offset;
            this.type = type;
        }
    }
}

