/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.wrappers;

import flightsim.simconnect.DataType;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimConnectPeriod;
import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.data.MarkerState;
import flightsim.simconnect.data.Waypoint;
import flightsim.simconnect.data.XYZ;
import flightsim.simconnect.recv.RecvSimObjectData;
import flightsim.simconnect.wrappers.DataWrapper;
import flightsim.simconnect.wrappers.FlightSimData;
import flightsim.simconnect.wrappers.IllegalDataDefinition;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationWrapper {
    private Map<Class<?>, Integer> definitionIds = new HashMap();
    private SimConnect simConnect;
    private int definitionID;
    private int requestID;

    public AnnotationWrapper(SimConnect sc) {
        this(sc, 0, 0);
    }

    public AnnotationWrapper(SimConnect sc, int startDefID, int startReqID) {
        if (sc == null) {
            throw new NullPointerException("Simconnect cannot be null");
        }
        this.simConnect = sc;
        this.setStartDefinitionID(startDefID);
        this.setStartRequestID(startReqID);
    }

    public void setStartDefinitionID(int startID) {
        this.definitionID = startID;
    }

    public void setStartRequestID(int startID) {
        this.requestID = startID;
    }

    public int registerClass(Class<?> c) throws IOException, IllegalDataDefinition {
        return this.registerClass(++this.definitionID, c);
    }

    public int registerClass(Enum dataDefID, Class<?> c) throws IOException, IllegalDataDefinition {
        return this.registerClass(dataDefID.ordinal(), c);
    }

    public int registerClass(int dataDefID, Class<?> c) throws IOException, IllegalDataDefinition {
        if (this.definitionIds.containsKey(c)) {
            return this.definitionIds.get(c);
        }
        int fieldAdded = 0;
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(FlightSimData.class)) continue;
            FlightSimData fsd = f.getAnnotation(FlightSimData.class);
            String variable = fsd.variable();
            String units = fsd.units();
            SimConnectDataType type = SimConnectDataType.INVALID;
            if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
                type = SimConnectDataType.FLOAT32;
            } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
                type = SimConnectDataType.FLOAT64;
            } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                type = SimConnectDataType.INT32;
            } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                type = SimConnectDataType.INT64;
            } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                type = SimConnectDataType.INT32;
            } else if (f.getType().equals(Short.class) || f.getType().equals(Short.TYPE)) {
                type = SimConnectDataType.INT32;
            } else if (f.getType().equals(LatLonAlt.class)) {
                type = SimConnectDataType.LATLONALT;
            } else if (f.getType().equals(XYZ.class)) {
                type = SimConnectDataType.XYZ;
            } else if (f.getType().equals(Waypoint.class)) {
                type = SimConnectDataType.WAYPOINT;
            } else if (f.getType().equals(MarkerState.class)) {
                type = SimConnectDataType.MARKERSTATE;
            } else if (f.getType().equals(String.class)) {
                int len = fsd.stringWidth();
                switch (len) {
                    case 8: {
                        type = SimConnectDataType.STRING8;
                        break;
                    }
                    case 32: {
                        type = SimConnectDataType.STRING32;
                        break;
                    }
                    case 64: {
                        type = SimConnectDataType.STRING64;
                        break;
                    }
                    case 128: {
                        type = SimConnectDataType.STRING128;
                        break;
                    }
                    case 256: {
                        type = SimConnectDataType.STRING256;
                        break;
                    }
                    case 260: {
                        type = SimConnectDataType.STRING260;
                        break;
                    }
                    default: {
                        throw new IllegalDataDefinition("Invalid string length (" + len + ")");
                    }
                }
            }
            if (type == SimConnectDataType.INVALID) {
                throw new IllegalDataDefinition("Invalid field type (" + f.getType().getName() + ")");
            }
            this.simConnect.addToDataDefinition(dataDefID, variable, units, type);
            ++fieldAdded;
        }
        if (fieldAdded > 0) {
            this.definitionIds.put(c, dataDefID);
        }
        return this.requestID;
    }

    public int requestSimObjectData(Class<?> cl, int objectId, SimConnectPeriod period, boolean onlyWhenChanged) throws IOException, IllegalDataDefinition {
        return this.requestSimObjectData(cl, ++this.requestID, objectId, period, onlyWhenChanged);
    }

    public int requestSimObjectData(Class<?> cl, Enum requestId, int objectId, SimConnectPeriod period, boolean onlyWhenChanged) throws IOException, IllegalDataDefinition {
        return this.requestSimObjectData(cl, requestId.ordinal(), objectId, period, onlyWhenChanged);
    }

    public int requestSimObjectData(Class<?> cl, int requestId, int objectId, SimConnectPeriod period, boolean onlyWhenChanged) throws IOException, IllegalDataDefinition {
        if (!this.definitionIds.containsKey(cl)) {
            throw new IllegalDataDefinition("Class not defined. call registerClass() first");
        }
        int defId = this.definitionIds.get(cl);
        int flags = onlyWhenChanged ? 1 : 0;
        this.simConnect.requestDataOnSimObject(requestId, defId, objectId, period, flags, 0, 0, 0);
        return requestId;
    }

    public <T> void setSimObjectData(T data, int objectId) throws IOException, IllegalDataDefinition {
        Class<?> cl = data.getClass();
        if (!this.definitionIds.containsKey(cl)) {
            throw new IllegalDataDefinition("Class not defined in this wrapper.");
        }
        int dataLen = this.classDataSize(cl);
        DataWrapper dw = new DataWrapper(dataLen);
        this.wrap(data, dw);
        int defId = this.definitionIds.get(cl);
        this.simConnect.setDataOnSimObject(defId, objectId, false, 1, dw);
    }

    public Object unwrap(RecvSimObjectData dataPacket) {
        int defId = dataPacket.getDefineID();
        for (Map.Entry<Class<?>, Integer> me : this.definitionIds.entrySet()) {
            if (me.getValue() != defId) continue;
            try {
                return this.unwrap(me.getKey(), dataPacket);
            }
            catch (IllegalDataDefinition e) {
                return null;
            }
        }
        return null;
    }

    public <T> T unwrap(Class<T> cl, RecvSimObjectData data) throws IllegalDataDefinition {
        T o;
        if (!this.definitionIds.containsKey(cl)) {
            throw new IllegalDataDefinition("Class not defined in this wrapper.");
        }
        try {
            o = cl.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return (T)this.unwrapToObject(o, data);
    }

    public Object unwrapToObject(Object o, RecvSimObjectData data) throws IllegalDataDefinition {
        Class<?> cl = o.getClass();
        if (!this.definitionIds.containsKey(cl)) {
            throw new IllegalDataDefinition("Class not defined in this wrapper.");
        }
        for (Field f : cl.getDeclaredFields()) {
            if (!f.isAnnotationPresent(FlightSimData.class)) continue;
            try {
                this.unwrapField(o, f, data);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return o;
    }

    private void unwrapField(Object o, Field f, RecvSimObjectData ro) throws IllegalArgumentException, IllegalAccessException {
        FlightSimData fsd = f.getAnnotation(FlightSimData.class);
        boolean accStatus = f.isAccessible();
        f.setAccessible(true);
        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
            Float val = new Float(ro.getDataFloat32());
            f.set(o, val);
        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
            Double val = new Double(ro.getDataFloat64());
            f.set(o, val);
        } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
            Integer val = new Integer(ro.getDataInt32());
            f.set(o, val);
        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
            Long val = new Long(ro.getDataInt64());
            f.set(o, val);
        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
            Boolean val = new Boolean(ro.getDataInt32() != 0);
            f.set(o, val);
        } else if (f.getType().equals(Short.class) || f.getType().equals(Short.TYPE)) {
            Short val = new Short((short)ro.getDataInt32());
            f.set(o, val);
        } else if (f.getType().equals(LatLonAlt.class)) {
            LatLonAlt val = ro.getLatLonAlt();
            f.set(o, val);
        } else if (f.getType().equals(XYZ.class)) {
            XYZ val = ro.getXYZ();
            f.set(o, val);
        } else if (f.getType().equals(Waypoint.class)) {
            Waypoint val = ro.getWaypoint();
            f.set(o, val);
        } else if (f.getType().equals(MarkerState.class)) {
            MarkerState val = ro.getMarkerState();
            f.set(o, val);
        } else if (f.getType().equals(String.class)) {
            int len = fsd.stringWidth();
            String val = null;
            switch (len) {
                case 8: {
                    val = ro.getDataString8();
                    break;
                }
                case 32: {
                    val = ro.getDataString32();
                    break;
                }
                case 64: {
                    val = ro.getDataString64();
                    break;
                }
                case 128: {
                    val = ro.getDataString128();
                    break;
                }
                case 256: {
                    val = ro.getDataString256();
                    break;
                }
                case 260: {
                    val = ro.getDataString260();
                }
            }
            f.set(o, val);
        }
        f.setAccessible(accStatus);
    }

    private int classDataSize(Class<?> cl) {
        int len = 0;
        for (Field f : cl.getDeclaredFields()) {
            if (!f.isAnnotationPresent(FlightSimData.class)) continue;
            len += this.fieldSize(f);
        }
        return len;
    }

    private int fieldSize(Field f) {
        FlightSimData fsd = f.getAnnotation(FlightSimData.class);
        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE) || f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE) || f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE) || f.getType().equals(Short.class) || f.getType().equals(Short.TYPE)) {
            return 4;
        }
        if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE) || f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
            return 8;
        }
        if (f.getType().equals(XYZ.class)) {
            return DataType.XYZ.size();
        }
        if (f.getType().equals(MarkerState.class)) {
            return DataType.MARKERSTATE.size();
        }
        if (f.getType().equals(Waypoint.class)) {
            return DataType.WAYPOINT.size();
        }
        if (f.getType().equals(LatLonAlt.class)) {
            return DataType.LATLONALT.size();
        }
        if (f.getType().equals(String.class)) {
            int len = fsd.stringWidth();
            return len;
        }
        return 0;
    }

    private void wrap(Object o, DataWrapper dw) throws IllegalDataDefinition {
        Class<?> cl = o.getClass();
        if (!this.definitionIds.containsKey(cl)) {
            throw new IllegalDataDefinition("Class not defined in this wrapper.");
        }
        for (Field f : cl.getDeclaredFields()) {
            if (!f.isAnnotationPresent(FlightSimData.class)) continue;
            try {
                this.wrapField(o, f, dw);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private void wrapField(Object o, Field f, DataWrapper dw) throws IllegalDataDefinition, IllegalAccessException {
        FlightSimData fsd = f.getAnnotation(FlightSimData.class);
        boolean accStatus = f.isAccessible();
        f.setAccessible(true);
        if (f.getType().equals(Float.class) || f.getType().equals(Float.TYPE)) {
            Float val = (Float)f.get(o);
            dw.putFloat32(val.floatValue());
        } else if (f.getType().equals(Double.class) || f.getType().equals(Double.TYPE)) {
            Double val = (Double)f.get(o);
            dw.putFloat64(val);
        } else if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
            Integer val = (Integer)f.get(o);
            dw.putInt32(val);
        } else if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
            Long val = (Long)f.get(o);
            dw.putInt64(val);
        } else if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
            Boolean val = (Boolean)f.get(o);
            dw.putInt32(val != false ? 1 : 0);
        } else if (f.getType().equals(Short.class) || f.getType().equals(Short.TYPE)) {
            Short val = (Short)f.get(o);
            dw.putInt32(val.intValue());
        } else if (f.getType().equals(LatLonAlt.class)) {
            LatLonAlt val = (LatLonAlt)f.get(o);
            dw.putData(val);
        } else if (f.getType().equals(XYZ.class)) {
            XYZ val = (XYZ)f.get(o);
            dw.putData(val);
        } else if (f.getType().equals(Waypoint.class)) {
            Waypoint val = (Waypoint)f.get(o);
            dw.putData(val);
        } else if (f.getType().equals(MarkerState.class)) {
            MarkerState val = (MarkerState)f.get(o);
            dw.putData(val);
        } else if (f.getType().equals(String.class)) {
            String s = (String)f.get(o);
            if (s == null) {
                s = "";
            }
            int len = fsd.stringWidth();
            dw.putString(s, len);
        }
        f.setAccessible(accStatus);
    }
}

