/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.recv;

import flightsim.simconnect.recv.RecvEvent;
import flightsim.simconnect.recv.RecvID;
import flightsim.simconnect.wrappers.GUID;
import java.nio.ByteBuffer;

public class RecvEventRaceEnd
extends RecvEvent {
    private int racerNumber;
    private int numberRacers;
    private GUID missionGUID;
    private String playerName;
    private String sessionType;
    private String aircraft;
    private String playerRole;
    private double totalTime;
    private double penaltyTime;
    private boolean disqualified;

    RecvEventRaceEnd(ByteBuffer bf) {
        super(bf, RecvID.ID_EVENT_RACE_END);
        this.racerNumber = bf.getInt();
        this.numberRacers = bf.getInt();
        this.missionGUID = new GUID();
        this.missionGUID.read(bf);
        this.playerName = this.makeString(bf, 260);
        this.sessionType = this.makeString(bf, 260);
        this.aircraft = this.makeString(bf, 260);
        this.playerRole = this.makeString(bf, 260);
        this.totalTime = bf.getDouble();
        this.penaltyTime = bf.getDouble();
        this.disqualified = bf.getInt() == 1;
    }

    public String getAircraft() {
        return this.aircraft;
    }

    public boolean isDisqualified() {
        return this.disqualified;
    }

    public GUID getMissionGUID() {
        return this.missionGUID;
    }

    public int getNumberRacers() {
        return this.numberRacers;
    }

    public double getPenaltyTime() {
        return this.penaltyTime;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getPlayerRole() {
        return this.playerRole;
    }

    public int getRacerNumber() {
        return this.racerNumber;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public double getTotalTime() {
        return this.totalTime;
    }
}

