/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.recv;

import java.nio.ByteBuffer;

public class FacilityAirport {
    private String icao;
    private double latitude;
    private double longitude;
    private double altitude;

    FacilityAirport(ByteBuffer bf) {
        this.icao = this.makeString(bf, 9);
        this.latitude = bf.getDouble();
        this.longitude = bf.getDouble();
        this.altitude = bf.getDouble();
    }

    public FacilityAirport(String icao, double latitude, double longitude, double altitude) {
        this.icao = icao;
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public String getIcao() {
        return this.icao;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    String makeString(ByteBuffer bf, int len) {
        int fZeroPos;
        byte[] tmp = new byte[len];
        bf.get(tmp);
        for (fZeroPos = 0; fZeroPos < len && tmp[fZeroPos] != 0; ++fZeroPos) {
        }
        return new String(tmp, 0, fZeroPos);
    }

    public String toString() {
        return this.icao + " (" + this.latitude + ", " + this.longitude + ", " + this.altitude + ")";
    }
}

