/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.recv;

import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.recv.AssignedObjectHandler;
import flightsim.simconnect.recv.ClientDataHandler;
import flightsim.simconnect.recv.CloudStateHandler;
import flightsim.simconnect.recv.CustomActionHandler;
import flightsim.simconnect.recv.EventFilenameHandler;
import flightsim.simconnect.recv.EventFrameHandler;
import flightsim.simconnect.recv.EventHandler;
import flightsim.simconnect.recv.EventObjectHandler;
import flightsim.simconnect.recv.EventWeatherModeHandler;
import flightsim.simconnect.recv.ExceptionHandler;
import flightsim.simconnect.recv.FacilitiesListHandler;
import flightsim.simconnect.recv.MultiplayerClientStartedHandler;
import flightsim.simconnect.recv.MultiplayerServerStartedHandler;
import flightsim.simconnect.recv.MultiplayerSessionEndedHandler;
import flightsim.simconnect.recv.OpenHandler;
import flightsim.simconnect.recv.QuitHandler;
import flightsim.simconnect.recv.RaceEndHandler;
import flightsim.simconnect.recv.RaceLapHandler;
import flightsim.simconnect.recv.RecvAirportList;
import flightsim.simconnect.recv.RecvAssignedObjectID;
import flightsim.simconnect.recv.RecvClientData;
import flightsim.simconnect.recv.RecvCloudState;
import flightsim.simconnect.recv.RecvCustomAction;
import flightsim.simconnect.recv.RecvEvent;
import flightsim.simconnect.recv.RecvEventAddRemove;
import flightsim.simconnect.recv.RecvEventFilename;
import flightsim.simconnect.recv.RecvEventFrame;
import flightsim.simconnect.recv.RecvEventMultiplayerClientStarted;
import flightsim.simconnect.recv.RecvEventMultiplayerServerStarted;
import flightsim.simconnect.recv.RecvEventMultiplayerSessionEnded;
import flightsim.simconnect.recv.RecvEventRaceEnd;
import flightsim.simconnect.recv.RecvEventRaceLap;
import flightsim.simconnect.recv.RecvEventWeatherMode;
import flightsim.simconnect.recv.RecvException;
import flightsim.simconnect.recv.RecvID;
import flightsim.simconnect.recv.RecvNDBList;
import flightsim.simconnect.recv.RecvOpen;
import flightsim.simconnect.recv.RecvQuit;
import flightsim.simconnect.recv.RecvReservedKey;
import flightsim.simconnect.recv.RecvSimObjectData;
import flightsim.simconnect.recv.RecvSimObjectDataByType;
import flightsim.simconnect.recv.RecvSystemState;
import flightsim.simconnect.recv.RecvVORList;
import flightsim.simconnect.recv.RecvWaypointList;
import flightsim.simconnect.recv.RecvWeatherObservation;
import flightsim.simconnect.recv.ReservedKeyHandler;
import flightsim.simconnect.recv.SimObjectDataHandler;
import flightsim.simconnect.recv.SimObjectDataTypeHandler;
import flightsim.simconnect.recv.SystemStateHandler;
import flightsim.simconnect.recv.WeatherObservationHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class DispatcherTask
implements Runnable,
Dispatcher {
    protected final SimConnect sc;
    private boolean cont = true;
    private int nListeners = 0;
    private List<AssignedObjectHandler> AssignedObjectHandlerList;
    private List<ClientDataHandler> ClientDataHandlerList;
    private List<CloudStateHandler> CloudStateHandlerList;
    private List<CustomActionHandler> CustomActionHandlerList;
    private List<EventFilenameHandler> EventFilenameHandlerList;
    private List<EventFrameHandler> EventFrameHandlerList;
    private List<EventHandler> EventHandlerList;
    private List<EventObjectHandler> EventObjectHandlerList;
    private List<ExceptionHandler> ExceptionHandlerList;
    private List<OpenHandler> OpenHandlerList;
    private List<QuitHandler> QuitHandlerList;
    private List<ReservedKeyHandler> ReservedKeyHandlerList;
    private List<SimObjectDataHandler> SimObjectDataHandlerList;
    private List<SimObjectDataTypeHandler> SimObjectDataTypeHandlerList;
    private List<SystemStateHandler> SystemStateHandlerList;
    private List<WeatherObservationHandler> WeatherObservationHandlerList;
    private List<EventWeatherModeHandler> EventWeatherModeList;
    private List<FacilitiesListHandler> FacilitiesListHandlerList;
    private List<MultiplayerClientStartedHandler> MultiplayerClientStartedHandlerList;
    private List<MultiplayerServerStartedHandler> MultiplayerServerStartedHandlerList;
    private List<MultiplayerSessionEndedHandler> MultiplayerSessionEndedHandlerList;
    private List<RaceEndHandler> RaceEndHandlerList;
    private List<RaceLapHandler> RaceLapHandlerList;
    private Queue<LateProcessItem> queueds = new LinkedList<LateProcessItem>();

    public int getListenersCount() {
        return this.nListeners;
    }

    public DispatcherTask(SimConnect sc) {
        this.sc = sc;
    }

    public void run() {
        this.cont = true;
        while (this.cont) {
            try {
                this.sc.callDispatch(this);
            }
            catch (IOException e) {
                this.cont = false;
            }
        }
    }

    public void tryStop() {
        this.cont = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(SimConnect simConnect, ByteBuffer data) {
        int id = data.getInt(8);
        RecvID rid = RecvID.type(id);
        this.processQueuedListeners();
        switch (rid) {
            case ID_EVENT: {
                if (this.EventHandlerList == null || this.EventHandlerList.size() <= 0) break;
                List<EventHandler> list = this.EventHandlerList;
                synchronized (list) {
                    RecvEvent re = new RecvEvent(data);
                    for (EventHandler ev : this.EventHandlerList) {
                        ev.handleEvent(simConnect, re);
                    }
                    break;
                }
            }
            case ID_EXCEPTION: {
                if (this.ExceptionHandlerList == null || this.ExceptionHandlerList.size() <= 0) break;
                List<ExceptionHandler> list = this.ExceptionHandlerList;
                synchronized (list) {
                    RecvException rx = new RecvException(data);
                    for (ExceptionHandler ev : this.ExceptionHandlerList) {
                        ev.handleException(simConnect, rx);
                    }
                    break;
                }
            }
            case ID_OPEN: {
                if (this.OpenHandlerList == null || this.OpenHandlerList.size() <= 0) break;
                List<OpenHandler> list = this.OpenHandlerList;
                synchronized (list) {
                    RecvOpen ro = new RecvOpen(data);
                    for (OpenHandler ev : this.OpenHandlerList) {
                        ev.handleOpen(simConnect, ro);
                    }
                    break;
                }
            }
            case ID_EVENT_FILENAME: {
                if (this.EventFilenameHandlerList == null || this.EventFilenameHandlerList.size() <= 0) break;
                List<EventFilenameHandler> list = this.EventFilenameHandlerList;
                synchronized (list) {
                    RecvEventFilename ref = new RecvEventFilename(data);
                    for (EventFilenameHandler ev : this.EventFilenameHandlerList) {
                        ev.handleFilename(simConnect, ref);
                    }
                    break;
                }
            }
            case ID_CUSTOM_ACTION: {
                if (this.CustomActionHandlerList == null || this.CustomActionHandlerList.size() <= 0) break;
                List<CustomActionHandler> list = this.CustomActionHandlerList;
                synchronized (list) {
                    RecvCustomAction rca = new RecvCustomAction(data);
                    for (CustomActionHandler ev : this.CustomActionHandlerList) {
                        ev.handleCustomAction(simConnect, rca);
                    }
                    break;
                }
            }
            case ID_EVENT_FRAME: {
                if (this.EventFrameHandlerList == null || this.EventFrameHandlerList.size() <= 0) break;
                List<EventFrameHandler> list = this.EventFrameHandlerList;
                synchronized (list) {
                    RecvEventFrame rf = new RecvEventFrame(data);
                    for (EventFrameHandler ev : this.EventFrameHandlerList) {
                        ev.handleEventFrame(simConnect, rf);
                    }
                    break;
                }
            }
            case ID_SIMOBJECT_DATA: {
                if (this.SimObjectDataHandlerList == null || this.SimObjectDataHandlerList.size() <= 0) break;
                List<SimObjectDataHandler> list = this.SimObjectDataHandlerList;
                synchronized (list) {
                    RecvSimObjectData rod = new RecvSimObjectData(data);
                    for (SimObjectDataHandler ev : this.SimObjectDataHandlerList) {
                        ev.handleSimObject(simConnect, rod);
                        rod.reset();
                    }
                    break;
                }
            }
            case ID_EVENT_OBJECT_ADDREMOVE: {
                if (this.EventObjectHandlerList == null || this.EventObjectHandlerList.size() <= 0) break;
                List<EventObjectHandler> list = this.EventObjectHandlerList;
                synchronized (list) {
                    RecvEventAddRemove rear = new RecvEventAddRemove(data);
                    for (EventObjectHandler ev : this.EventObjectHandlerList) {
                        ev.handleEventObject(simConnect, rear);
                    }
                    break;
                }
            }
            case ID_SIMOBJECT_DATA_BYTYPE: {
                if (this.SimObjectDataTypeHandlerList == null || this.SimObjectDataTypeHandlerList.size() <= 0) break;
                RecvSimObjectDataByType rot = new RecvSimObjectDataByType(data);
                for (SimObjectDataTypeHandler ev : this.SimObjectDataTypeHandlerList) {
                    ev.handleSimObjectType(simConnect, rot);
                    rot.reset();
                }
                break;
            }
            case ID_QUIT: {
                if (this.QuitHandlerList == null || this.QuitHandlerList.size() <= 0) break;
                RecvQuit rq = new RecvQuit(data);
                for (QuitHandler ev : this.QuitHandlerList) {
                    ev.handleQuit(simConnect, rq);
                }
                break;
            }
            case ID_SYSTEM_STATE: {
                if (this.SystemStateHandlerList == null || this.SystemStateHandlerList.size() <= 0) break;
                RecvSystemState ry = new RecvSystemState(data);
                for (SystemStateHandler ev : this.SystemStateHandlerList) {
                    ev.handleSystemState(simConnect, ry);
                }
                break;
            }
            case ID_CLIENT_DATA: {
                if (this.ClientDataHandlerList == null || this.ClientDataHandlerList.size() <= 0) break;
                RecvClientData rcd = new RecvClientData(data);
                for (ClientDataHandler ev : this.ClientDataHandlerList) {
                    ev.handleClientData(simConnect, rcd);
                    rcd.reset();
                }
                break;
            }
            case ID_ASSIGNED_OBJECT_ID: {
                if (this.AssignedObjectHandlerList == null || this.AssignedObjectHandlerList.size() <= 0) break;
                List<AssignedObjectHandler> list = this.AssignedObjectHandlerList;
                synchronized (list) {
                    RecvAssignedObjectID rai = new RecvAssignedObjectID(data);
                    for (AssignedObjectHandler ev : this.AssignedObjectHandlerList) {
                        ev.handleAssignedObject(simConnect, rai);
                    }
                    break;
                }
            }
            case ID_CLOUD_STATE: {
                if (this.CloudStateHandlerList == null || this.CloudStateHandlerList.size() <= 0) break;
                List<CloudStateHandler> list = this.CloudStateHandlerList;
                synchronized (list) {
                    RecvCloudState rcl = new RecvCloudState(data);
                    for (CloudStateHandler ev : this.CloudStateHandlerList) {
                        ev.handleCloudState(simConnect, rcl);
                    }
                    break;
                }
            }
            case ID_RESERVED_KEY: {
                if (this.ReservedKeyHandlerList == null || this.ReservedKeyHandlerList.size() <= 0) break;
                List<ReservedKeyHandler> list = this.ReservedKeyHandlerList;
                synchronized (list) {
                    RecvReservedKey rrk = new RecvReservedKey(data);
                    for (ReservedKeyHandler ev : this.ReservedKeyHandlerList) {
                        ev.handleReservedKey(simConnect, rrk);
                    }
                    break;
                }
            }
            case ID_WEATHER_OBSERVATION: {
                if (this.WeatherObservationHandlerList == null || this.WeatherObservationHandlerList.size() <= 0) break;
                List<WeatherObservationHandler> list = this.WeatherObservationHandlerList;
                synchronized (list) {
                    RecvWeatherObservation rwo = new RecvWeatherObservation(data);
                    for (WeatherObservationHandler ev : this.WeatherObservationHandlerList) {
                        ev.handleWeatherObservation(simConnect, rwo);
                    }
                    break;
                }
            }
            case ID_EVENT_WEATHER_MODE: {
                if (this.EventWeatherModeList == null || this.EventWeatherModeList.size() <= 0) break;
                List<EventWeatherModeHandler> list = this.EventWeatherModeList;
                synchronized (list) {
                    RecvEventWeatherMode ev = new RecvEventWeatherMode(data);
                    for (EventWeatherModeHandler hndler : this.EventWeatherModeList) {
                        hndler.handleWeatherMode(simConnect, ev);
                    }
                    break;
                }
            }
            case ID_AIRPORT_LIST: {
                if (this.FacilitiesListHandlerList == null || this.FacilitiesListHandlerList.size() <= 0) break;
                List<FacilitiesListHandler> list = this.FacilitiesListHandlerList;
                synchronized (list) {
                    RecvAirportList list2 = new RecvAirportList(data);
                    for (FacilitiesListHandler hndle : this.FacilitiesListHandlerList) {
                        hndle.handleAirportList(simConnect, list2);
                    }
                    break;
                }
            }
            case ID_VOR_LIST: {
                if (this.FacilitiesListHandlerList == null || this.FacilitiesListHandlerList.size() <= 0) break;
                List<FacilitiesListHandler> list = this.FacilitiesListHandlerList;
                synchronized (list) {
                    RecvVORList list3 = new RecvVORList(data);
                    for (FacilitiesListHandler hndle : this.FacilitiesListHandlerList) {
                        hndle.handleVORList(simConnect, list3);
                    }
                    break;
                }
            }
            case ID_NDB_LIST: {
                if (this.FacilitiesListHandlerList == null || this.FacilitiesListHandlerList.size() <= 0) break;
                List<FacilitiesListHandler> list = this.FacilitiesListHandlerList;
                synchronized (list) {
                    RecvNDBList list4 = new RecvNDBList(data);
                    for (FacilitiesListHandler hndle : this.FacilitiesListHandlerList) {
                        hndle.handleNDBList(simConnect, list4);
                    }
                    break;
                }
            }
            case ID_WAYPOINT_LIST: {
                if (this.FacilitiesListHandlerList == null || this.FacilitiesListHandlerList.size() <= 0) break;
                List<FacilitiesListHandler> list = this.FacilitiesListHandlerList;
                synchronized (list) {
                    RecvWaypointList list5 = new RecvWaypointList(data);
                    for (FacilitiesListHandler hndle : this.FacilitiesListHandlerList) {
                        hndle.handleWaypointList(simConnect, list5);
                    }
                    break;
                }
            }
            case ID_EVENT_MULTIPLAYER_CLIENT_STARTED: {
                if (this.MultiplayerClientStartedHandlerList == null || this.MultiplayerClientStartedHandlerList.size() <= 0) break;
                List<MultiplayerClientStartedHandler> list = this.MultiplayerClientStartedHandlerList;
                synchronized (list) {
                    RecvEventMultiplayerClientStarted ev = new RecvEventMultiplayerClientStarted(data);
                    for (MultiplayerClientStartedHandler hndle : this.MultiplayerClientStartedHandlerList) {
                        hndle.handleMultiplayerClientStarted(simConnect, ev);
                    }
                    break;
                }
            }
            case ID_EVENT_MULTIPLAYER_SERVER_STARTED: {
                if (this.MultiplayerServerStartedHandlerList == null || this.MultiplayerServerStartedHandlerList.size() <= 0) break;
                List<MultiplayerServerStartedHandler> list = this.MultiplayerServerStartedHandlerList;
                synchronized (list) {
                    RecvEventMultiplayerServerStarted ev = new RecvEventMultiplayerServerStarted(data);
                    for (MultiplayerServerStartedHandler hndle : this.MultiplayerServerStartedHandlerList) {
                        hndle.handleMultiplayerServerStarted(simConnect, ev);
                    }
                    break;
                }
            }
            case ID_EVENT_MULTIPLAYER_SESSION_ENDED: {
                if (this.MultiplayerSessionEndedHandlerList == null || this.MultiplayerSessionEndedHandlerList.size() <= 0) break;
                List<MultiplayerSessionEndedHandler> list = this.MultiplayerSessionEndedHandlerList;
                synchronized (list) {
                    RecvEventMultiplayerSessionEnded ev = new RecvEventMultiplayerSessionEnded(data);
                    for (MultiplayerSessionEndedHandler hndle : this.MultiplayerSessionEndedHandlerList) {
                        hndle.handleMultiplayerSessionEnded(simConnect, ev);
                    }
                    break;
                }
            }
            case ID_EVENT_RACE_END: {
                if (this.RaceEndHandlerList == null || this.RaceEndHandlerList.size() <= 0) break;
                List<RaceEndHandler> list = this.RaceEndHandlerList;
                synchronized (list) {
                    RecvEventRaceEnd ev = new RecvEventRaceEnd(data);
                    for (RaceEndHandler hndle : this.RaceEndHandlerList) {
                        hndle.handleRaceEnd(simConnect, ev);
                    }
                    break;
                }
            }
            case ID_EVENT_RACE_LAP: {
                if (this.RaceLapHandlerList == null || this.RaceLapHandlerList.size() <= 0) break;
                List<RaceLapHandler> list = this.RaceLapHandlerList;
                synchronized (list) {
                    RecvEventRaceLap ev = new RecvEventRaceLap(data);
                    for (RaceLapHandler hndle : this.RaceLapHandlerList) {
                        hndle.handleRaceLap(simConnect, ev);
                    }
                    break;
                }
            }
        }
        this.processQueuedListeners();
    }

    public void addAssignedObjectHandler(AssignedObjectHandler ev) {
        if (this.AssignedObjectHandlerList == null) {
            this.AssignedObjectHandlerList = new ArrayList<AssignedObjectHandler>();
        }
        this.queueds.add(new LateAdd<AssignedObjectHandler>(this.AssignedObjectHandlerList, ev));
    }

    public void removeAssignedObjectHandler(AssignedObjectHandler ev) {
        this.queueds.add(new LateRemoval<AssignedObjectHandler>(this.AssignedObjectHandlerList, ev));
    }

    public void addClientDataHandler(ClientDataHandler ev) {
        if (this.ClientDataHandlerList == null) {
            this.ClientDataHandlerList = new ArrayList<ClientDataHandler>();
        }
        this.queueds.add(new LateAdd<ClientDataHandler>(this.ClientDataHandlerList, ev));
    }

    public void removeClientDataHandler(ClientDataHandler ev) {
        this.queueds.add(new LateRemoval<ClientDataHandler>(this.ClientDataHandlerList, ev));
    }

    public void addCloudStateHandler(CloudStateHandler ev) {
        if (this.CloudStateHandlerList == null) {
            this.CloudStateHandlerList = new ArrayList<CloudStateHandler>();
        }
        this.queueds.add(new LateAdd<CloudStateHandler>(this.CloudStateHandlerList, ev));
    }

    public void removeCloudStateHandler(CloudStateHandler ev) {
        this.queueds.add(new LateRemoval<CloudStateHandler>(this.CloudStateHandlerList, ev));
    }

    public void addCustomActionHandler(CustomActionHandler ev) {
        if (this.CustomActionHandlerList == null) {
            this.CustomActionHandlerList = new ArrayList<CustomActionHandler>();
        }
        this.queueds.add(new LateAdd<CustomActionHandler>(this.CustomActionHandlerList, ev));
    }

    public void removeCustomActionHandler(CustomActionHandler ev) {
        this.queueds.add(new LateRemoval<CustomActionHandler>(this.CustomActionHandlerList, ev));
    }

    public void addEventFilenameHandler(EventFilenameHandler ev) {
        if (this.EventFilenameHandlerList == null) {
            this.EventFilenameHandlerList = new ArrayList<EventFilenameHandler>();
        }
        this.queueds.add(new LateAdd<EventFilenameHandler>(this.EventFilenameHandlerList, ev));
    }

    public void removeEventFilenameHandler(EventFilenameHandler ev) {
        this.queueds.add(new LateRemoval<EventFilenameHandler>(this.EventFilenameHandlerList, ev));
    }

    public void addEventFrameHandler(EventFrameHandler ev) {
        if (this.EventFrameHandlerList == null) {
            this.EventFrameHandlerList = new ArrayList<EventFrameHandler>();
        }
        this.queueds.add(new LateAdd<EventFrameHandler>(this.EventFrameHandlerList, ev));
    }

    public void removeEventFrameHandler(EventFrameHandler ev) {
        this.queueds.add(new LateRemoval<EventFrameHandler>(this.EventFrameHandlerList, ev));
    }

    public void addEventHandler(EventHandler ev) {
        if (this.EventHandlerList == null) {
            this.EventHandlerList = new ArrayList<EventHandler>();
        }
        this.queueds.add(new LateAdd<EventHandler>(this.EventHandlerList, ev));
    }

    public void removeEventHandler(EventHandler ev) {
        this.queueds.add(new LateRemoval<EventHandler>(this.EventHandlerList, ev));
    }

    public void addEventObjectHandler(EventObjectHandler ev) {
        if (this.EventObjectHandlerList == null) {
            this.EventObjectHandlerList = new ArrayList<EventObjectHandler>();
        }
        this.queueds.add(new LateAdd<EventObjectHandler>(this.EventObjectHandlerList, ev));
    }

    public void removeEventObjectHandler(EventObjectHandler ev) {
        this.queueds.add(new LateRemoval<EventObjectHandler>(this.EventObjectHandlerList, ev));
    }

    public void addExceptionHandler(ExceptionHandler ev) {
        if (this.ExceptionHandlerList == null) {
            this.ExceptionHandlerList = new ArrayList<ExceptionHandler>();
        }
        this.queueds.add(new LateAdd<ExceptionHandler>(this.ExceptionHandlerList, ev));
    }

    public void removeExceptionHandler(ExceptionHandler ev) {
        this.queueds.add(new LateRemoval<ExceptionHandler>(this.ExceptionHandlerList, ev));
    }

    public void addOpenHandler(OpenHandler ev) {
        if (this.OpenHandlerList == null) {
            this.OpenHandlerList = new ArrayList<OpenHandler>();
        }
        this.queueds.add(new LateAdd<OpenHandler>(this.OpenHandlerList, ev));
    }

    public void removeOpenHandler(OpenHandler ev) {
        this.queueds.add(new LateRemoval<OpenHandler>(this.OpenHandlerList, ev));
    }

    public void addQuitHandler(QuitHandler ev) {
        if (this.QuitHandlerList == null) {
            this.QuitHandlerList = new ArrayList<QuitHandler>();
        }
        this.queueds.add(new LateAdd<QuitHandler>(this.QuitHandlerList, ev));
    }

    public void removeQuitHandler(QuitHandler ev) {
        this.queueds.add(new LateRemoval<QuitHandler>(this.QuitHandlerList, ev));
    }

    public void addReservedKeyHandler(ReservedKeyHandler ev) {
        if (this.ReservedKeyHandlerList == null) {
            this.ReservedKeyHandlerList = new ArrayList<ReservedKeyHandler>();
        }
        this.queueds.add(new LateAdd<ReservedKeyHandler>(this.ReservedKeyHandlerList, ev));
    }

    public void removeReservedKeyHandler(ReservedKeyHandler ev) {
        this.queueds.add(new LateRemoval<ReservedKeyHandler>(this.ReservedKeyHandlerList, ev));
    }

    public void addSimObjectDataHandler(SimObjectDataHandler ev) {
        if (this.SimObjectDataHandlerList == null) {
            this.SimObjectDataHandlerList = new ArrayList<SimObjectDataHandler>();
        }
        this.queueds.add(new LateAdd<SimObjectDataHandler>(this.SimObjectDataHandlerList, ev));
    }

    public void removeSimObjectDataHandler(SimObjectDataHandler ev) {
        this.queueds.add(new LateRemoval<SimObjectDataHandler>(this.SimObjectDataHandlerList, ev));
    }

    public void addSimObjectDataTypeHandler(SimObjectDataTypeHandler ev) {
        if (this.SimObjectDataTypeHandlerList == null) {
            this.SimObjectDataTypeHandlerList = new ArrayList<SimObjectDataTypeHandler>();
        }
        this.queueds.add(new LateAdd<SimObjectDataTypeHandler>(this.SimObjectDataTypeHandlerList, ev));
    }

    public void removeSimObjectDataTypeHandler(SimObjectDataTypeHandler ev) {
        this.queueds.add(new LateRemoval<SimObjectDataTypeHandler>(this.SimObjectDataTypeHandlerList, ev));
    }

    public void addSystemStateHandler(SystemStateHandler ev) {
        if (this.SystemStateHandlerList == null) {
            this.SystemStateHandlerList = new ArrayList<SystemStateHandler>();
        }
        this.queueds.add(new LateAdd<SystemStateHandler>(this.SystemStateHandlerList, ev));
    }

    public void removeSystemStateHandler(SystemStateHandler ev) {
        this.queueds.add(new LateRemoval<SystemStateHandler>(this.SystemStateHandlerList, ev));
    }

    public void addWeatherObservationHandler(WeatherObservationHandler ev) {
        if (this.WeatherObservationHandlerList == null) {
            this.WeatherObservationHandlerList = new ArrayList<WeatherObservationHandler>();
        }
        this.queueds.add(new LateAdd<WeatherObservationHandler>(this.WeatherObservationHandlerList, ev));
    }

    public void removeWeatherObservationHandler(WeatherObservationHandler ev) {
        this.queueds.add(new LateRemoval<WeatherObservationHandler>(this.WeatherObservationHandlerList, ev));
    }

    public void addEventWeatherModeHandler(EventWeatherModeHandler ev) {
        if (this.EventWeatherModeList == null) {
            this.EventWeatherModeList = new ArrayList<EventWeatherModeHandler>();
        }
        this.queueds.add(new LateAdd<EventWeatherModeHandler>(this.EventWeatherModeList, ev));
    }

    public void removeEventWeatherModeHandler(EventWeatherModeHandler ev) {
        this.queueds.add(new LateRemoval<EventWeatherModeHandler>(this.EventWeatherModeList, ev));
    }

    public void addFacilitiesListHandler(FacilitiesListHandler ev) {
        if (this.FacilitiesListHandlerList == null) {
            this.FacilitiesListHandlerList = new ArrayList<FacilitiesListHandler>();
        }
        this.queueds.add(new LateAdd<FacilitiesListHandler>(this.FacilitiesListHandlerList, ev));
    }

    public void removeFacilitiesListHandler(FacilitiesListHandler ev) {
        this.queueds.add(new LateRemoval<FacilitiesListHandler>(this.FacilitiesListHandlerList, ev));
    }

    public void addMultiplayerClientStartedHandler(MultiplayerClientStartedHandler ev) {
        if (this.MultiplayerClientStartedHandlerList == null) {
            this.MultiplayerClientStartedHandlerList = new ArrayList<MultiplayerClientStartedHandler>();
        }
        this.queueds.add(new LateAdd<MultiplayerClientStartedHandler>(this.MultiplayerClientStartedHandlerList, ev));
    }

    public void removeMultiplayerClientStartedHandler(MultiplayerClientStartedHandler ev) {
        this.queueds.add(new LateRemoval<MultiplayerClientStartedHandler>(this.MultiplayerClientStartedHandlerList, ev));
    }

    public void addMultiplayerServerStartedHandler(MultiplayerServerStartedHandler ev) {
        if (this.MultiplayerServerStartedHandlerList == null) {
            this.MultiplayerServerStartedHandlerList = new ArrayList<MultiplayerServerStartedHandler>();
        }
        this.queueds.add(new LateAdd<MultiplayerServerStartedHandler>(this.MultiplayerServerStartedHandlerList, ev));
    }

    public void removeMultiplayerServerStartedHandler(MultiplayerServerStartedHandler ev) {
        this.queueds.add(new LateRemoval<MultiplayerServerStartedHandler>(this.MultiplayerServerStartedHandlerList, ev));
    }

    public void addMultiplayerSessionEndedHandler(MultiplayerSessionEndedHandler ev) {
        if (this.MultiplayerSessionEndedHandlerList == null) {
            this.MultiplayerSessionEndedHandlerList = new ArrayList<MultiplayerSessionEndedHandler>();
        }
        this.queueds.add(new LateAdd<MultiplayerSessionEndedHandler>(this.MultiplayerSessionEndedHandlerList, ev));
    }

    public void removeMultiplayerSessionEndedHandler(MultiplayerSessionEndedHandler ev) {
        this.queueds.add(new LateRemoval<MultiplayerSessionEndedHandler>(this.MultiplayerSessionEndedHandlerList, ev));
    }

    public void addRaceLapHandler(RaceLapHandler ev) {
        if (this.RaceLapHandlerList == null) {
            this.RaceLapHandlerList = new ArrayList<RaceLapHandler>();
        }
        this.queueds.add(new LateAdd<RaceLapHandler>(this.RaceLapHandlerList, ev));
    }

    public void removeRaceLapHandler(RaceLapHandler ev) {
        this.queueds.add(new LateRemoval<RaceLapHandler>(this.RaceLapHandlerList, ev));
    }

    public void addRaceEndHandler(RaceEndHandler ev) {
        if (this.RaceEndHandlerList == null) {
            this.RaceEndHandlerList = new ArrayList<RaceEndHandler>();
        }
        this.queueds.add(new LateAdd<RaceEndHandler>(this.RaceEndHandlerList, ev));
    }

    public void removeRaceEndHandler(RaceEndHandler ev) {
        this.queueds.add(new LateRemoval<RaceEndHandler>(this.RaceEndHandlerList, ev));
    }

    public Thread createThread() {
        Thread t = new Thread(this);
        t.setName("SimConnect dispatcher thread");
        return t;
    }

    protected synchronized void processQueuedListeners() {
        while (!this.queueds.isEmpty()) {
            LateProcessItem ri = this.queueds.poll();
            if (ri == null) continue;
            ri.doJob();
        }
    }

    public void removeHandlers(Object o) {
        if (o instanceof AssignedObjectHandler) {
            this.removeAssignedObjectHandler((AssignedObjectHandler)o);
        }
        if (o instanceof ClientDataHandler) {
            this.removeClientDataHandler((ClientDataHandler)o);
        }
        if (o instanceof CloudStateHandler) {
            this.removeCloudStateHandler((CloudStateHandler)o);
        }
        if (o instanceof CustomActionHandler) {
            this.removeCustomActionHandler((CustomActionHandler)o);
        }
        if (o instanceof EventFilenameHandler) {
            this.removeEventFilenameHandler((EventFilenameHandler)o);
        }
        if (o instanceof EventFrameHandler) {
            this.removeEventFrameHandler((EventFrameHandler)o);
        }
        if (o instanceof EventHandler) {
            this.removeEventHandler((EventHandler)o);
        }
        if (o instanceof EventObjectHandler) {
            this.removeEventObjectHandler((EventObjectHandler)o);
        }
        if (o instanceof EventWeatherModeHandler) {
            this.removeEventWeatherModeHandler((EventWeatherModeHandler)o);
        }
        if (o instanceof ExceptionHandler) {
            this.removeExceptionHandler((ExceptionHandler)o);
        }
        if (o instanceof OpenHandler) {
            this.removeOpenHandler((OpenHandler)o);
        }
        if (o instanceof QuitHandler) {
            this.removeQuitHandler((QuitHandler)o);
        }
        if (o instanceof ReservedKeyHandler) {
            this.removeReservedKeyHandler((ReservedKeyHandler)o);
        }
        if (o instanceof SimObjectDataHandler) {
            this.removeSimObjectDataHandler((SimObjectDataHandler)o);
        }
        if (o instanceof SimObjectDataTypeHandler) {
            this.removeSimObjectDataTypeHandler((SimObjectDataTypeHandler)o);
        }
        if (o instanceof SystemStateHandler) {
            this.removeSystemStateHandler((SystemStateHandler)o);
        }
        if (o instanceof WeatherObservationHandler) {
            this.removeWeatherObservationHandler((WeatherObservationHandler)o);
        }
        if (o instanceof FacilitiesListHandler) {
            this.removeFacilitiesListHandler((FacilitiesListHandler)o);
        }
        if (o instanceof MultiplayerClientStartedHandler) {
            this.removeMultiplayerClientStartedHandler((MultiplayerClientStartedHandler)o);
        }
        if (o instanceof MultiplayerServerStartedHandler) {
            this.removeMultiplayerServerStartedHandler((MultiplayerServerStartedHandler)o);
        }
        if (o instanceof MultiplayerSessionEndedHandler) {
            this.removeMultiplayerSessionEndedHandler((MultiplayerSessionEndedHandler)o);
        }
        if (o instanceof RaceLapHandler) {
            this.removeRaceLapHandler((RaceLapHandler)o);
        }
        if (o instanceof RaceEndHandler) {
            this.removeRaceEndHandler((RaceEndHandler)o);
        }
    }

    public void addHandlers(Object o) {
        if (o instanceof AssignedObjectHandler) {
            this.addAssignedObjectHandler((AssignedObjectHandler)o);
        }
        if (o instanceof ClientDataHandler) {
            this.addClientDataHandler((ClientDataHandler)o);
        }
        if (o instanceof CloudStateHandler) {
            this.addCloudStateHandler((CloudStateHandler)o);
        }
        if (o instanceof CustomActionHandler) {
            this.addCustomActionHandler((CustomActionHandler)o);
        }
        if (o instanceof EventFilenameHandler) {
            this.addEventFilenameHandler((EventFilenameHandler)o);
        }
        if (o instanceof EventFrameHandler) {
            this.addEventFrameHandler((EventFrameHandler)o);
        }
        if (o instanceof EventHandler) {
            this.addEventHandler((EventHandler)o);
        }
        if (o instanceof EventObjectHandler) {
            this.addEventObjectHandler((EventObjectHandler)o);
        }
        if (o instanceof EventWeatherModeHandler) {
            this.addEventWeatherModeHandler((EventWeatherModeHandler)o);
        }
        if (o instanceof ExceptionHandler) {
            this.addExceptionHandler((ExceptionHandler)o);
        }
        if (o instanceof OpenHandler) {
            this.addOpenHandler((OpenHandler)o);
        }
        if (o instanceof QuitHandler) {
            this.addQuitHandler((QuitHandler)o);
        }
        if (o instanceof ReservedKeyHandler) {
            this.addReservedKeyHandler((ReservedKeyHandler)o);
        }
        if (o instanceof SimObjectDataHandler) {
            this.addSimObjectDataHandler((SimObjectDataHandler)o);
        }
        if (o instanceof SimObjectDataTypeHandler) {
            this.addSimObjectDataTypeHandler((SimObjectDataTypeHandler)o);
        }
        if (o instanceof SystemStateHandler) {
            this.addSystemStateHandler((SystemStateHandler)o);
        }
        if (o instanceof WeatherObservationHandler) {
            this.addWeatherObservationHandler((WeatherObservationHandler)o);
        }
        if (o instanceof FacilitiesListHandler) {
            this.addFacilitiesListHandler((FacilitiesListHandler)o);
        }
        if (o instanceof MultiplayerClientStartedHandler) {
            this.removeMultiplayerClientStartedHandler((MultiplayerClientStartedHandler)o);
        }
        if (o instanceof MultiplayerServerStartedHandler) {
            this.removeMultiplayerServerStartedHandler((MultiplayerServerStartedHandler)o);
        }
        if (o instanceof MultiplayerSessionEndedHandler) {
            this.removeMultiplayerSessionEndedHandler((MultiplayerSessionEndedHandler)o);
        }
        if (o instanceof RaceEndHandler) {
            this.removeRaceEndHandler((RaceEndHandler)o);
        }
        if (o instanceof RaceLapHandler) {
            this.removeRaceLapHandler((RaceLapHandler)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LateAdd<T>
    extends LateProcessItem<T> {
        protected LateAdd(List<T> l, T item) {
            super(l, item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doJob() {
            if (this.l != null) {
                List list = this.l;
                synchronized (list) {
                    this.l.add(this.item);
                    DispatcherTask.this.nListeners++;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LateRemoval<T>
    extends LateProcessItem<T> {
        protected LateRemoval(List<T> l, T item) {
            super(l, item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doJob() {
            if (this.l != null) {
                List list = this.l;
                synchronized (list) {
                    if (this.l.remove(this.item)) {
                        DispatcherTask.this.nListeners--;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class LateProcessItem<T> {
        protected List<T> l;
        protected T item;

        protected LateProcessItem(List<T> l, T item) {
            this.l = l;
            this.item = item;
        }

        protected abstract void doJob();
    }
}

