/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.recv;

import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.SimConnect;
import flightsim.simconnect.recv.RecvAirportList;
import flightsim.simconnect.recv.RecvAssignedObjectID;
import flightsim.simconnect.recv.RecvClientData;
import flightsim.simconnect.recv.RecvCloudState;
import flightsim.simconnect.recv.RecvCustomAction;
import flightsim.simconnect.recv.RecvEvent;
import flightsim.simconnect.recv.RecvEventAddRemove;
import flightsim.simconnect.recv.RecvEventFilename;
import flightsim.simconnect.recv.RecvEventFrame;
import flightsim.simconnect.recv.RecvEventMultiplayerClientStarted;
import flightsim.simconnect.recv.RecvEventMultiplayerServerStarted;
import flightsim.simconnect.recv.RecvEventMultiplayerSessionEnded;
import flightsim.simconnect.recv.RecvEventRaceEnd;
import flightsim.simconnect.recv.RecvEventRaceLap;
import flightsim.simconnect.recv.RecvEventWeatherMode;
import flightsim.simconnect.recv.RecvException;
import flightsim.simconnect.recv.RecvID;
import flightsim.simconnect.recv.RecvNDBList;
import flightsim.simconnect.recv.RecvOpen;
import flightsim.simconnect.recv.RecvPacket;
import flightsim.simconnect.recv.RecvQuit;
import flightsim.simconnect.recv.RecvReservedKey;
import flightsim.simconnect.recv.RecvSimObjectData;
import flightsim.simconnect.recv.RecvSimObjectDataByType;
import flightsim.simconnect.recv.RecvSystemState;
import flightsim.simconnect.recv.RecvVORList;
import flightsim.simconnect.recv.RecvWaypointList;
import flightsim.simconnect.recv.RecvWeatherObservation;
import java.nio.ByteBuffer;

public abstract class AbstractDispatcher
implements Dispatcher {
    public abstract void onDispatch(SimConnect var1, RecvPacket var2);

    private static RecvPacket buildCustomPacket(ByteBuffer data) {
        RecvPacket packet = null;
        int id = data.getInt(8);
        RecvID rid = RecvID.type(id);
        switch (rid) {
            case ID_EVENT: {
                packet = new RecvEvent(data);
                break;
            }
            case ID_EXCEPTION: {
                packet = new RecvException(data);
                break;
            }
            case ID_OPEN: {
                packet = new RecvOpen(data);
                break;
            }
            case ID_EVENT_FILENAME: {
                packet = new RecvEventFilename(data);
                break;
            }
            case ID_CUSTOM_ACTION: {
                packet = new RecvCustomAction(data);
                break;
            }
            case ID_EVENT_FRAME: {
                packet = new RecvEventFrame(data);
                break;
            }
            case ID_SIMOBJECT_DATA: {
                packet = new RecvSimObjectData(data);
                break;
            }
            case ID_EVENT_OBJECT_ADDREMOVE: {
                packet = new RecvEventAddRemove(data);
                break;
            }
            case ID_SIMOBJECT_DATA_BYTYPE: {
                packet = new RecvSimObjectDataByType(data);
                break;
            }
            case ID_QUIT: {
                packet = new RecvQuit(data);
                break;
            }
            case ID_SYSTEM_STATE: {
                packet = new RecvSystemState(data);
                break;
            }
            case ID_CLIENT_DATA: {
                packet = new RecvClientData(data);
                break;
            }
            case ID_ASSIGNED_OBJECT_ID: {
                packet = new RecvAssignedObjectID(data);
                break;
            }
            case ID_CLOUD_STATE: {
                packet = new RecvCloudState(data);
                break;
            }
            case ID_RESERVED_KEY: {
                packet = new RecvReservedKey(data);
                break;
            }
            case ID_WEATHER_OBSERVATION: {
                packet = new RecvWeatherObservation(data);
                break;
            }
            case ID_EVENT_WEATHER_MODE: {
                packet = new RecvEventWeatherMode(data);
                break;
            }
            case ID_AIRPORT_LIST: {
                packet = new RecvAirportList(data);
                break;
            }
            case ID_NDB_LIST: {
                packet = new RecvNDBList(data);
                break;
            }
            case ID_VOR_LIST: {
                packet = new RecvVORList(data);
                break;
            }
            case ID_WAYPOINT_LIST: {
                packet = new RecvWaypointList(data);
                break;
            }
            case ID_EVENT_MULTIPLAYER_CLIENT_STARTED: {
                packet = new RecvEventMultiplayerClientStarted(data);
                break;
            }
            case ID_EVENT_MULTIPLAYER_SERVER_STARTED: {
                packet = new RecvEventMultiplayerServerStarted(data);
                break;
            }
            case ID_EVENT_MULTIPLAYER_SESSION_ENDED: {
                packet = new RecvEventMultiplayerSessionEnded(data);
                break;
            }
            case ID_EVENT_RACE_END: {
                packet = new RecvEventRaceEnd(data);
                break;
            }
            case ID_EVENT_RACE_LAP: {
                packet = new RecvEventRaceLap(data);
                break;
            }
            default: {
                packet = new RecvPacket(data);
            }
        }
        return packet;
    }

    public void dispatch(SimConnect simConnect, ByteBuffer data) {
        RecvPacket packet = AbstractDispatcher.buildCustomPacket(data);
        this.onDispatch(simConnect, packet);
    }
}

