/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.data;

import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.data.SimConnectData;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class XYZ
implements SimConnectData,
Serializable {
    private static final long serialVersionUID = -2922269039547967440L;
    public double x;
    public double y;
    public double z;

    public XYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public XYZ() {
    }

    public void read(ByteBuffer buffer) {
        this.x = buffer.getDouble();
        this.y = buffer.getDouble();
        this.z = buffer.getDouble();
    }

    public void write(ByteBuffer buffer) {
        buffer.putDouble(this.x);
        buffer.putDouble(this.y);
        buffer.putDouble(this.z);
    }

    double get(int index) {
        if (index == 0) {
            return this.x;
        }
        if (index == 1) {
            return this.y;
        }
        if (index == 2) {
            return this.z;
        }
        return -1.0;
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public void setFromSpherical(double lat, double lon, double alt) {
        this.x = alt * Math.sin(lat) * Math.cos(lon);
        this.y = alt * Math.sin(lat) * Math.sin(lon);
        this.z = alt * Math.cos(lat);
    }

    public void setFromSpherical(LatLonAlt lla, double earthRadius) {
        double lat = Math.toRadians(lla.latitude);
        double lon = Math.toRadians(lla.longitude);
        double alt = earthRadius + lla.altitude;
        this.x = alt * Math.sin(lat) * Math.cos(lon);
        this.y = alt * Math.sin(lat) * Math.sin(lon);
        this.z = alt * Math.cos(lat);
    }

    public double dist() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double dist(double dx, double dy, double dz) {
        return Math.sqrt((this.x - dx) * (this.x - dx) + (this.y - dy) * (this.y - dy) + (this.z - dz) * (this.z - dz));
    }

    public double dist(XYZ p) {
        return this.dist(p.x, p.y, p.z);
    }

    public void translate(double xx, double yy, double zz) {
        this.x += xx;
        this.y += yy;
        this.z += zz;
    }

    public void rotateX(double a) {
        double newx = this.x;
        double newy = Math.cos(a) * this.y - Math.sin(a) * this.z;
        double newz = Math.sin(a) * this.y + Math.cos(a) * this.z;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public void rotateY(double a) {
        double newx = Math.cos(a) * this.x + Math.sin(a) * this.z;
        double newy = this.y;
        double newz = -Math.sin(a) * this.x + Math.cos(a) * this.z;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public void rotateZ(double a) {
        double newx = Math.cos(a) * this.x - Math.sin(a) * this.y;
        double newy = Math.sin(a) * this.x + Math.cos(a) * this.y;
        double newz = this.z;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public void projectionFrustum(double l, double r, double b, double t, double n, double f) {
        double newx = 2.0 * n / (r - l) * this.x + (r + l) / (r - l) * this.z;
        double newy = 2.0 * n / (t - b) * this.y + (t + b) / (t - b) * this.z;
        double newz = -(f + n) / (f - n) * this.z;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public void projection2(double xf, double yf, double xzf, double yzf) {
        double newx = xf * this.x + xzf * this.z;
        double newy = yf * this.y + yzf * this.z;
        double newz = this.z;
        this.x = newx;
        this.y = newy;
        this.z = newz;
    }

    public XYZ clone() {
        return new XYZ(this.x, this.y, this.z);
    }
}

