/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.data;

import flightsim.simconnect.SimConnectConstants;
import flightsim.simconnect.data.LatLonAlt;
import flightsim.simconnect.data.SimConnectData;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class Waypoint
implements SimConnectData,
Serializable,
SimConnectConstants {
    private static final long serialVersionUID = 6165789235638978423L;
    public double latitude;
    public double longitude;
    public double altitude;
    public int flags;
    public double speed;
    public double throttle;

    public Waypoint(double latitude, double longitude, double altitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
    }

    public Waypoint(double latitude, double longitude, double altitude, int flags, double speed, double throttle) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.flags = flags;
        this.speed = speed;
        this.throttle = throttle;
    }

    public Waypoint() {
    }

    public void read(ByteBuffer buffer) {
        this.latitude = buffer.getDouble();
        this.longitude = buffer.getDouble();
        this.altitude = buffer.getDouble();
        this.flags = buffer.getInt();
        this.speed = buffer.getDouble();
        this.throttle = buffer.getDouble();
    }

    public void write(ByteBuffer buffer) {
        buffer.putDouble(this.latitude);
        buffer.putDouble(this.longitude);
        buffer.putDouble(this.altitude);
        buffer.putInt(this.flags);
        buffer.putDouble(this.speed);
        buffer.putDouble(this.throttle);
    }

    public void setLatLonAlt(LatLonAlt lla) {
        this.latitude = lla.latitude;
        this.longitude = lla.longitude;
        this.altitude = lla.altitude / 0.3048;
    }
}

