/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.config;

import flightsim.simconnect.config.Configuration;
import flightsim.simconnect.config.ConfigurationNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;

public class ConfigurationManager {
    private static Vector<Configuration> configs = new Vector();
    private static boolean inited = false;
    private static final Pattern HDR_PATTERN = Pattern.compile("^\\s*\\[SimConnect(.(\\d+))?\\].*", 2);
    private static final Pattern LINE_PATTERN = Pattern.compile("^\\s*([^#]*)=([^#]*).*", 2);

    private static void readConfiguration() {
        if (inited) {
            return;
        }
        File f = new File("SimConnect.cfg");
        if (f.exists()) {
            try {
                ConfigurationManager.parse(f);
                inited = true;
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if ((f = new File(System.getProperty("user.home"), "SimConnect.cfg")).exists()) {
            try {
                ConfigurationManager.parse(f);
                inited = true;
                return;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if ((f = new File(FileSystemView.getFileSystemView().getDefaultDirectory(), "SimConnect.cfg")).exists()) {
            try {
                ConfigurationManager.parse(f);
                inited = true;
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void parse(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        Configuration current = null;
        while ((line = br.readLine()) != null) {
            Matcher m = HDR_PATTERN.matcher(line);
            if (m.matches()) {
                current = new Configuration();
                try {
                    int cfgNo = 0;
                    if (m.group(2) != null) {
                        cfgNo = Integer.parseInt(m.group(2));
                    }
                    if (configs.size() - 1 < cfgNo) {
                        configs.setSize(cfgNo + 1);
                    }
                    configs.set(cfgNo, current);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if (!(m = LINE_PATTERN.matcher(line)).matches() || current == null) continue;
            String key = m.group(1).trim().toLowerCase();
            String val = m.group(2).trim();
            current.put(key, val);
        }
        fr.close();
    }

    public static Configuration getConfiguration(int number) throws ConfigurationNotFoundException {
        if (!inited) {
            ConfigurationManager.readConfiguration();
        }
        if (number > configs.size()) {
            throw new ConfigurationNotFoundException(number);
        }
        Configuration cfg = configs.get(number);
        if (cfg == null) {
            throw new ConfigurationNotFoundException(number);
        }
        return cfg;
    }
}

