/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
extends Hashtable<String, String> {
    private static final long serialVersionUID = 4120183786070819349L;
    public static final String ADDRESS = "Address";
    public static final String PROTOCOL = "Protocol";
    public static final String PROTOCOL_IPv4 = "IPv4";
    public static final String PROTOCOL_IPv6 = "IPv6";
    public static final String PORT = "Port";
    public static final String MAX_RECEIVE_SIZE = "MaxReceiveSize";
    public static final String DISABLE_NAGLE = "DisableNagle";

    public String get(String key, String def) {
        String s = this.get(key.toLowerCase());
        if (s == null) {
            return def;
        }
        return s;
    }

    public String get(String key) {
        return (String)super.get(key.toLowerCase());
    }

    public int getInt(String key, int def) {
        String s = this.get(key.toLowerCase());
        if (s == null) {
            return def;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return def;
        }
    }

    public boolean getBoolean(String key, boolean def) {
        int val = this.getInt(key, def ? 1 : 0);
        return val == 1;
    }

    @Override
    public synchronized String put(String key, String value) {
        return super.put(key.toLowerCase(), value);
    }

    public void setAddress(String address) {
        this.put(ADDRESS, address);
    }

    public void setPort(int port) {
        this.put(PORT, Integer.toString(port));
    }

    public void setProtocol(int protocol) {
        if (protocol != 4 && protocol != 6) {
            throw new IllegalArgumentException("Bad protocol version (" + protocol + ")");
        }
        this.put(PROTOCOL, protocol == 4 ? PROTOCOL_IPv4 : PROTOCOL_IPv6);
    }

    public static int findSimConnectPortIPv4() {
        return Configuration.readRegistryValue("SimConnect_Port_IPv4");
    }

    public static int findSimConnectPortIPv6() {
        return Configuration.readRegistryValue("SimConnect_Port_IPv6");
    }

    public static int findSimConnectPort() {
        int port4 = Configuration.findSimConnectPortIPv4();
        if (port4 <= 0) {
            return Configuration.findSimConnectPortIPv6();
        }
        return port4;
    }

    private static int readRegistryValue(String key) {
        try {
            String line;
            Process p = Runtime.getRuntime().exec("reg query \"HKCU\\Software\\Microsoft\\Microsoft Games\\Flight Simulator\" /v " + key);
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                StringTokenizer toker = new StringTokenizer(line);
                try {
                    String regKey = toker.nextToken().trim();
                    String regType = toker.nextToken().trim();
                    String regValue = toker.nextToken().trim();
                    if (!regKey.equalsIgnoreCase(key) || !"REG_SZ".equalsIgnoreCase(regType)) continue;
                    return Integer.parseInt(regValue);
                }
                catch (NoSuchElementException nse) {
                }
                catch (NumberFormatException nfe) {
                }
            }
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }
}

