/*
 * Decompiled with CFR 0.152.
 */
package flightsim.simconnect;

import flightsim.simconnect.ClientDataPeriod;
import flightsim.simconnect.Dispatcher;
import flightsim.simconnect.FacilityListType;
import flightsim.simconnect.Messages;
import flightsim.simconnect.NotificationPriority;
import flightsim.simconnect.SimConnectConstants;
import flightsim.simconnect.SimConnectDataType;
import flightsim.simconnect.SimConnectPeriod;
import flightsim.simconnect.SimObjectType;
import flightsim.simconnect.TextType;
import flightsim.simconnect.config.Configuration;
import flightsim.simconnect.config.ConfigurationManager;
import flightsim.simconnect.config.ConfigurationNotFoundException;
import flightsim.simconnect.data.InitPosition;
import flightsim.simconnect.data.SimConnectData;
import flightsim.simconnect.wrappers.DataWrapper;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SocketChannel;

public class SimConnect
implements SimConnectConstants {
    private SocketChannel sc;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final String appName;
    private final int bufferSize;
    private final InetSocketAddress remoteAddress;
    private final int ourProtocol;
    private int currentIndex = 1;
    private int packetsReceived = 0;
    private int packetsSent = 0;
    private int bytesReceived = 0;
    private int bytesSent = 0;
    private static final int SIMCONNECT_BUILD_SP0 = 60905;
    private static final int SIMCONNECT_BUILD_SP1 = 61355;
    private static final int SIMCONNECT_BUILD_SP2_XPACK = 61259;

    public SimConnect(String appName) throws IOException {
        this(appName, SimConnect.makeAutoConfiguration());
    }

    private static Configuration makeAutoConfiguration() {
        String host;
        Configuration cfg = null;
        try {
            cfg = ConfigurationManager.getConfiguration(0);
        }
        catch (ConfigurationNotFoundException cnfe) {
            cfg = new Configuration();
        }
        int port = cfg.getInt("Port", -1);
        if (port == -1) {
            port = Configuration.findSimConnectPortIPv4();
            if (port <= 0) {
                port = Configuration.findSimConnectPortIPv6();
                cfg.setProtocol(6);
            } else {
                cfg.setProtocol(4);
            }
            cfg.setPort(port);
        }
        if ((host = cfg.get("Address", null)) == null) {
            if (cfg.getInt("Protocol", 4) == 6) {
                cfg.setAddress("::1");
            } else {
                cfg.setAddress("localhost");
            }
        }
        return cfg;
    }

    public SimConnect(String appName, Configuration config, int simConnectProtocol) throws IOException {
        this.appName = appName;
        InetAddress inAddr = null;
        String host = config.get("Address", "localhost");
        InetAddress[] addrs = InetAddress.getAllByName(host);
        String proto = config.get("Protocol", "");
        for (InetAddress in : addrs) {
            if ("IPv6".equalsIgnoreCase(proto) && in instanceof Inet6Address) {
                inAddr = in;
            }
            if ("IPv6".equalsIgnoreCase(proto) || !(in instanceof Inet4Address)) continue;
            inAddr = in;
        }
        if (inAddr == null && addrs.length > 0) {
            inAddr = addrs[0];
        }
        if (inAddr == null) {
            throw new IOException(Messages.get("SimConnect.Unknown_host"));
        }
        int port = config.getInt("Port", 8002);
        this.remoteAddress = new InetSocketAddress(host, port);
        this.bufferSize = config.getInt("MaxReceiveSize", 65536);
        this.ourProtocol = simConnectProtocol;
        if (this.ourProtocol != 2 && this.ourProtocol != 3 && this.ourProtocol != 4) {
            throw new IllegalArgumentException(Messages.getString("SimConnect.VersionMismatch"));
        }
        this.openNetworkConnection();
        if (config.getBoolean("DisableNagle", false)) {
            this.sc.socket().setTcpNoDelay(false);
        }
        this.open();
    }

    public SimConnect(String appName, Configuration config) throws IOException {
        this(appName, config, config.getInt("SimConnect", 4));
    }

    public SimConnect(String appName, String host, int port, int simConnectProtocol) throws IOException {
        this(appName, SimConnect.buildConfiguration(host, port), simConnectProtocol);
    }

    public SimConnect(String appName, String host, int port) throws IOException {
        this(appName, SimConnect.buildConfiguration(host, port), 4);
    }

    public SimConnect(String appName, int configNumber, int simConnectProtocol) throws IOException, ConfigurationNotFoundException {
        this(appName, ConfigurationManager.getConfiguration(configNumber), simConnectProtocol);
    }

    public SimConnect(String appName, int configNumber) throws IOException, ConfigurationNotFoundException {
        this(appName, ConfigurationManager.getConfiguration(configNumber), 4);
    }

    private static Configuration buildConfiguration(String host, int port) {
        Configuration c = new Configuration();
        c.put("Address", host);
        c.put("Port", Integer.toString(port));
        return c;
    }

    private void openNetworkConnection() throws IOException {
        this.sc = SocketChannel.open(this.remoteAddress);
        this.readBuffer = ByteBuffer.allocateDirect(65536);
        this.readBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.writeBuffer = ByteBuffer.allocateDirect(65536);
        this.writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void close() throws IOException {
        this.sc.close();
    }

    public boolean isClosed() {
        return !this.sc.isConnected();
    }

    public SocketAddress remoteAddress() {
        return this.sc.socket().getRemoteSocketAddress();
    }

    public SocketAddress localAddress() {
        return this.sc.socket().getLocalSocketAddress();
    }

    private synchronized void sendPacket(int type) throws IOException {
        int packetSize = this.writeBuffer.position();
        this.writeBuffer.putInt(0, packetSize);
        this.writeBuffer.putInt(4, this.ourProtocol);
        this.writeBuffer.putInt(8, 0xF0000000 | type);
        this.writeBuffer.putInt(12, this.currentIndex++);
        this.writeBuffer.flip();
        this.sc.write(this.writeBuffer);
        ++this.packetsSent;
        this.bytesSent += packetSize;
    }

    private void clean(ByteBuffer bf) {
        bf.clear();
        this.writeBuffer.position(16);
    }

    private void putString(ByteBuffer bf, String s, int fixed) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes();
        bf.put(b, 0, Math.min(b.length, fixed));
        if (b.length < fixed) {
            for (int i = 0; i < fixed - b.length; ++i) {
                bf.put((byte)0);
            }
        }
    }

    private synchronized void open() throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, this.appName, 256);
        this.writeBuffer.putInt(0);
        this.writeBuffer.put((byte)0);
        this.writeBuffer.put((byte)88);
        this.writeBuffer.put((byte)83);
        this.writeBuffer.put((byte)70);
        if (this.ourProtocol == 2) {
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(60905);
            this.writeBuffer.putInt(0);
        } else if (this.ourProtocol == 3) {
            this.writeBuffer.putInt(10);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(61355);
            this.writeBuffer.putInt(0);
        } else if (this.ourProtocol == 4) {
            this.writeBuffer.putInt(10);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(61259);
            this.writeBuffer.putInt(0);
        } else {
            throw new IllegalArgumentException(Messages.getString("SimConnect.InvalidProtocol"));
        }
        this.sendPacket(1);
    }

    public synchronized void addToDataDefinition(int dataDefinitionId, String datumName, String unitsName, SimConnectDataType dataType) throws IOException {
        this.addToDataDefinition(dataDefinitionId, datumName, unitsName, dataType, 0.0f, -1);
    }

    public synchronized void addToDataDefinition(Enum dataDefinitionId, String datumName, String unitsName, SimConnectDataType dataType) throws IOException {
        this.addToDataDefinition(dataDefinitionId.ordinal(), datumName, unitsName, dataType);
    }

    public synchronized void addToDataDefinition(int dataDefinitionId, String datumName, String unitsName, SimConnectDataType dataType, float epsilon, int datumId) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionId);
        this.putString(this.writeBuffer, datumName, 256);
        this.putString(this.writeBuffer, unitsName, 256);
        this.writeBuffer.putInt(dataType.ordinal());
        this.writeBuffer.putFloat(epsilon);
        this.writeBuffer.putInt(datumId);
        this.sendPacket(12);
    }

    public synchronized void addToDataDefinition(Enum dataDefinitionId, String datumName, String unitsName, SimConnectDataType dataType, float epsilon, int datumId) throws IOException {
        this.addToDataDefinition(dataDefinitionId.ordinal(), datumName, unitsName, dataType, epsilon, datumId);
    }

    public synchronized void requestDataOnSimObject(int dataRequestId, int dataDefinitionId, int objectId, SimConnectPeriod period) throws IOException {
        this.requestDataOnSimObject(dataRequestId, dataDefinitionId, objectId, period, 0, 0, 0, 0);
    }

    public synchronized void requestDataOnSimObject(Enum dataRequestId, Enum dataDefinitionId, int objectId, SimConnectPeriod period) throws IOException {
        this.requestDataOnSimObject(dataRequestId.ordinal(), dataDefinitionId.ordinal(), objectId, period);
    }

    public synchronized void requestDataOnSimObject(int dataRequestId, int dataDefinitionId, int objectId, SimConnectPeriod period, int flags, int origin, int interval, int limit) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestId);
        this.writeBuffer.putInt(dataDefinitionId);
        this.writeBuffer.putInt(objectId);
        this.writeBuffer.putInt(period.ordinal());
        this.writeBuffer.putInt(flags);
        this.writeBuffer.putInt(origin);
        this.writeBuffer.putInt(interval);
        this.writeBuffer.putInt(limit);
        this.sendPacket(14);
    }

    public synchronized void requestDataOnSimObject(Enum dataRequestId, Enum dataDefinitionId, int objectId, SimConnectPeriod period, int flags, int origin, int interval, int limit) throws IOException {
        this.requestDataOnSimObject(dataRequestId.ordinal(), dataDefinitionId.ordinal(), objectId, period, flags, origin, interval, limit);
    }

    public synchronized void clearDataDefinition(int dataDefinitionId) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionId);
        this.sendPacket(13);
    }

    public synchronized void clearDataDefinition(Enum dataDefinitionId) throws IOException {
        this.clearDataDefinition(dataDefinitionId.ordinal());
    }

    public synchronized void requestDataOnSimObjectType(int dataRequestId, int dataDefinitionId, int radiusMeters, SimObjectType type) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestId);
        this.writeBuffer.putInt(dataDefinitionId);
        this.writeBuffer.putInt(radiusMeters);
        this.writeBuffer.putInt(type.ordinal());
        this.sendPacket(15);
    }

    public synchronized void requestDataOnSimObjectType(Enum dataRequestId, Enum dataDefinitionId, int radiusMeters, SimObjectType type) throws IOException {
        this.requestDataOnSimObjectType(dataRequestId.ordinal(), dataDefinitionId.ordinal(), radiusMeters, type);
    }

    public synchronized void subscribeToSystemEvent(int clientEventID, String eventName) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientEventID);
        this.putString(this.writeBuffer, eventName, 256);
        this.sendPacket(23);
    }

    public synchronized void subscribeToSystemEvent(Enum clientEventID, String eventName) throws IOException {
        this.subscribeToSystemEvent(clientEventID.ordinal(), eventName);
    }

    public synchronized void unsubscribeFromSystemEvent(int clientEventID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientEventID);
        this.sendPacket(24);
    }

    public synchronized void unsubscribeFromSystemEvent(Enum clientEventID) throws IOException {
        this.unsubscribeFromSystemEvent(clientEventID.ordinal());
    }

    public synchronized void requestSystemState(int dataRequestID, String state) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.putString(this.writeBuffer, state, 256);
        this.sendPacket(53);
    }

    public synchronized void requestSystemState(Enum dataRequestID, String state) throws IOException {
        this.requestSystemState(dataRequestID.ordinal(), state);
    }

    public synchronized void setSystemState(String state, int paramInt, float paramFloat, String paramString) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, state, 256);
        this.writeBuffer.putInt(paramInt);
        this.writeBuffer.putFloat(paramFloat);
        this.putString(this.writeBuffer, paramString, 256);
        this.writeBuffer.putInt(0);
        this.sendPacket(54);
    }

    public synchronized void addClientEventToNotificationGroup(int notificationGroupID, int clientEventID) throws IOException {
        this.addClientEventToNotificationGroup(notificationGroupID, clientEventID, false);
    }

    public synchronized void addClientEventToNotificationGroup(Enum notificationGroupID, Enum clientEventID) throws IOException {
        this.addClientEventToNotificationGroup(notificationGroupID.ordinal(), clientEventID.ordinal(), false);
    }

    public synchronized void addClientEventToNotificationGroup(int notificationGroupID, int clientEventID, boolean maskable) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(notificationGroupID);
        this.writeBuffer.putInt(clientEventID);
        this.writeBuffer.putInt(maskable ? 1 : 0);
        this.sendPacket(7);
    }

    public synchronized void addClientEventToNotificationGroup(Enum notificationGroupID, Enum clientEventID, boolean maskable) throws IOException {
        this.addClientEventToNotificationGroup(notificationGroupID.ordinal(), clientEventID.ordinal(), maskable);
    }

    public synchronized void mapClientEventToSimEvent(int clientEventId) throws IOException {
        this.mapClientEventToSimEvent(clientEventId, "");
    }

    public synchronized void mapClientEventToSimEvent(Enum clientEventId) throws IOException {
        this.mapClientEventToSimEvent(clientEventId.ordinal(), "");
    }

    public synchronized void mapClientEventToSimEvent(int clientEventId, String eventName) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientEventId);
        this.putString(this.writeBuffer, eventName, 256);
        this.sendPacket(4);
    }

    public synchronized void mapClientEventToSimEvent(Enum clientEventId, String eventName) throws IOException {
        this.mapClientEventToSimEvent(clientEventId.ordinal(), eventName);
    }

    public synchronized void transmitClientEvent(int objectID, int eventID, int data, int groupID, int flags) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(eventID);
        this.writeBuffer.putInt(data);
        this.writeBuffer.putInt(groupID);
        this.writeBuffer.putInt(flags);
        this.sendPacket(5);
    }

    public synchronized void transmitClientEvent(int objectID, Enum eventID, int data, Enum groupID, int flags) throws IOException {
        this.transmitClientEvent(objectID, eventID.ordinal(), data, groupID.ordinal(), flags);
    }

    public synchronized void setSystemEventState(int eventID, boolean state) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(eventID);
        this.writeBuffer.putInt(state ? 1 : 0);
        this.sendPacket(6);
    }

    public synchronized void setSystemEventState(Enum eventID, boolean state) throws IOException {
        this.setSystemEventState(eventID.ordinal(), state);
    }

    public synchronized void removeClientEvent(int groupID, int eventID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(eventID);
        this.writeBuffer.putInt(eventID);
        this.sendPacket(8);
    }

    public synchronized void removeClientEvent(Enum groupID, Enum eventID) throws IOException {
        this.removeClientEvent(groupID.ordinal(), eventID.ordinal());
    }

    public synchronized void setNotificationGroupPriority(int groupID, NotificationPriority priority) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(groupID);
        this.writeBuffer.putInt(priority.value());
        this.sendPacket(9);
    }

    public synchronized void setNotificationGroupPriority(Enum groupID, NotificationPriority priority) throws IOException {
        this.setNotificationGroupPriority(groupID.ordinal(), priority);
    }

    public synchronized void clearNotificationGroup(int groupID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(groupID);
        this.sendPacket(10);
    }

    public synchronized void requestNotificationGroup(int groupID) throws IOException {
        this.requestNotificationGroup(groupID, 0, 0);
    }

    public synchronized void requestNotificationGroup(int groupID, int reserved, int flags) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(groupID);
        this.writeBuffer.putInt(reserved);
        this.writeBuffer.putInt(flags);
        this.sendPacket(11);
    }

    public synchronized void setDataOnSimObject(int dataDefinitionID, int objectID, boolean tagged, int arrayCount, byte[] data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionID);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(tagged ? 1 : 0);
        if (arrayCount == 0) {
            arrayCount = 1;
        }
        this.writeBuffer.putInt(arrayCount);
        this.writeBuffer.putInt(data.length);
        this.writeBuffer.put(data);
        this.sendPacket(16);
    }

    public synchronized void setDataOnSimObject(Enum dataDefinitionID, int objectID, boolean tagged, int arrayCount, byte[] data) throws IOException {
        this.setDataOnSimObject(dataDefinitionID.ordinal(), objectID, tagged, arrayCount, data);
    }

    public synchronized void setDataOnSimObject(int dataDefinitionID, int objectID, boolean tagged, int arrayCount, ByteBuffer data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionID);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(tagged ? 1 : 0);
        if (arrayCount == 0) {
            arrayCount = 1;
        }
        this.writeBuffer.putInt(arrayCount);
        this.writeBuffer.putInt(data.remaining());
        this.writeBuffer.put(data);
        this.sendPacket(16);
    }

    public synchronized void setDataOnSimObject(int dataDefinitionID, int objectID, SimConnectData[] data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionID);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(data.length);
        this.writeBuffer.putInt(0);
        for (SimConnectData sd : data) {
            sd.write(this.writeBuffer);
        }
        this.writeBuffer.putInt(32, this.writeBuffer.position() - 36);
        this.sendPacket(16);
    }

    public synchronized void setDataOnSimObject(Enum dataDefinitionID, int objectID, double ... data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionID.ordinal());
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(8 * data.length);
        for (double d : data) {
            this.writeBuffer.putDouble(d);
        }
        this.sendPacket(16);
    }

    public synchronized void setDataOnSimObject(int dataDefinitionID, int objectID, double ... data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefinitionID);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(8 * data.length);
        for (double d : data) {
            this.writeBuffer.putDouble(d);
        }
        this.sendPacket(16);
    }

    public synchronized void setDataOnSimObject(Enum dataDefinitionID, int objectID, SimConnectData[] data) throws IOException {
        this.setDataOnSimObject(dataDefinitionID.ordinal(), objectID, data);
    }

    public synchronized void setDataOnSimObject(int dataDefinitionID, int objectID, boolean tagged, int arrayCount, DataWrapper data) throws IOException {
        this.setDataOnSimObject(dataDefinitionID, objectID, tagged, arrayCount, data.getBuffer());
    }

    public synchronized void setDataOnSimObject(Enum dataDefinitionID, int objectID, boolean tagged, int arrayCount, DataWrapper data) throws IOException {
        this.setDataOnSimObject(dataDefinitionID.ordinal(), objectID, tagged, arrayCount, data.getBuffer());
    }

    public synchronized void mapInputEventToClientEvent(int inputGroupID, String inputDefinition, int clientEventDownID) throws IOException {
        this.mapInputEventToClientEvent(inputGroupID, inputDefinition, clientEventDownID, 0, -1, 0, false);
    }

    public synchronized void mapInputEventToClientEvent(Enum inputGroupID, String inputDefinition, Enum clientEventDownID) throws IOException {
        this.mapInputEventToClientEvent(inputGroupID.ordinal(), inputDefinition, clientEventDownID.ordinal(), 0, -1, 0, false);
    }

    public synchronized void mapInputEventToClientEvent(int inputGroupID, String inputDefinition, int clientEventDownID, int downValue, int clientEventUpID, int UpValue, boolean maskable) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(inputGroupID);
        this.putString(this.writeBuffer, inputDefinition, 256);
        this.writeBuffer.putInt(clientEventDownID);
        this.writeBuffer.putInt(downValue);
        this.writeBuffer.putInt(clientEventUpID);
        this.writeBuffer.putInt(UpValue);
        this.writeBuffer.putInt(maskable ? 1 : 0);
        this.sendPacket(17);
    }

    public synchronized void mapInputEventToClientEvent(Enum inputGroupID, String inputDefinition, Enum clientEventDownID, int downValue, Enum clientEventUpID, int UpValue, boolean maskable) throws IOException {
        this.mapInputEventToClientEvent(inputGroupID.ordinal(), inputDefinition, clientEventDownID.ordinal(), downValue, clientEventUpID.ordinal(), UpValue, maskable);
    }

    public synchronized void setInputGroupPriority(int inputGroupID, NotificationPriority priority) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(inputGroupID);
        this.writeBuffer.putInt(priority.value());
        this.sendPacket(18);
    }

    public synchronized void setInputGroupPriority(Enum inputGroupID, NotificationPriority priority) throws IOException {
        this.setInputGroupPriority(inputGroupID.ordinal(), priority);
    }

    public synchronized void removeInputEvent(int inputGroupID, String inputDefinition) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(inputGroupID);
        this.putString(this.writeBuffer, inputDefinition, 256);
        this.sendPacket(19);
    }

    public synchronized void removeInputEvent(Enum inputGroupID, String inputDefinition) throws IOException {
        this.removeInputEvent(inputGroupID.ordinal(), inputDefinition);
    }

    public synchronized void clearInputGroup(int inputGroupID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(inputGroupID);
        this.sendPacket(20);
    }

    public synchronized void clearInputGroup(Enum inputGroupID) throws IOException {
        this.clearInputGroup(inputGroupID.ordinal());
    }

    public synchronized void setInputGroupState(int inputGroupID, boolean state) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(inputGroupID);
        this.writeBuffer.putInt(state ? 1 : 0);
        this.sendPacket(21);
    }

    public synchronized void setInputGroupState(Enum inputGroupID, boolean state) throws IOException {
        this.setInputGroupState(inputGroupID.ordinal(), state);
    }

    public synchronized void requestReservedKey(int eventID, String keyChoice1) throws IOException {
        this.requestReservedKey(eventID, keyChoice1, "", "");
    }

    public synchronized void requestReservedKey(int eventID, String keyChoice1, String keyChoice2) throws IOException {
        this.requestReservedKey(eventID, keyChoice1, keyChoice2, "");
    }

    public synchronized void requestReservedKey(int eventID, String keyChoice1, String keyChoice2, String keyChoice3) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(eventID);
        this.putString(this.writeBuffer, keyChoice1 == null ? "" : keyChoice1, 30);
        this.putString(this.writeBuffer, keyChoice2 == null ? "" : keyChoice2, 30);
        this.putString(this.writeBuffer, keyChoice3 == null ? "" : keyChoice3, 30);
        this.sendPacket(22);
    }

    public synchronized void weatherRequestInterpolatedObservation(int dataRequestID, float lat, float lon, float alt) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putFloat(lat);
        this.writeBuffer.putFloat(lon);
        this.writeBuffer.putFloat(alt);
        this.sendPacket(25);
    }

    public synchronized void weatherRequestObservationAtStation(int dataRequestID, String ICAO) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.putString(this.writeBuffer, ICAO, 5);
        this.sendPacket(26);
    }

    public synchronized void weatherRequestObservationAtNearestStation(int dataRequestID, float lat, float lon) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putFloat(lat);
        this.writeBuffer.putFloat(lon);
        this.sendPacket(27);
    }

    public synchronized void weatherRequestObservationAtNearestStation(Enum dataRequestID, float lat, float lon) throws IOException {
        this.weatherRequestObservationAtNearestStation(dataRequestID.ordinal(), lat, lon);
    }

    public synchronized void weatherCreateStation(int dataRequestID, String ICAO, String name, float lat, float lon, float alt) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.putString(this.writeBuffer, ICAO, 5);
        this.putString(this.writeBuffer, name, 256);
        this.writeBuffer.putFloat(lat);
        this.writeBuffer.putFloat(lon);
        this.writeBuffer.putFloat(alt);
        this.sendPacket(28);
    }

    public synchronized void weatherRemoveStation(int dataRequestID, String ICAO) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.putString(this.writeBuffer, ICAO, 5);
        this.sendPacket(29);
    }

    public synchronized void weatherSetObservation(int seconds, String metar) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(seconds);
        byte[] metarData = metar.getBytes();
        this.writeBuffer.put(metarData);
        this.writeBuffer.put((byte)0);
        this.sendPacket(30);
    }

    public synchronized void weatherSetModeServer(int port, int seconds) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(port);
        this.writeBuffer.putInt(seconds);
        this.sendPacket(31);
    }

    public synchronized void weatherSetModeTheme(String themeName) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, themeName, 256);
        this.sendPacket(32);
    }

    public synchronized void weatherSetModeGlobal() throws IOException {
        this.clean(this.writeBuffer);
        this.sendPacket(33);
    }

    public synchronized void weatherSetModeCustom() throws IOException {
        this.clean(this.writeBuffer);
        this.sendPacket(34);
    }

    public synchronized void weatherSetDynamicUpdateRate(int rate) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(rate);
        this.sendPacket(35);
    }

    public synchronized void weatherRequestCloudState(int dataRequestID, float minLat, float minLon, float minAlt, float maxLat, float maxLon, float maxAlt, int flags) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putFloat(minLat);
        this.writeBuffer.putFloat(minLon);
        this.writeBuffer.putFloat(minAlt);
        this.writeBuffer.putFloat(maxLat);
        this.writeBuffer.putFloat(maxLon);
        this.writeBuffer.putFloat(maxAlt);
        this.writeBuffer.putInt(flags);
        this.sendPacket(36);
    }

    public synchronized void weatherRequestCloudState(int dataRequestID, float minLat, float minLon, float minAlt, float maxLat, float maxLon, float maxAlt) throws IOException {
        this.weatherRequestCloudState(dataRequestID, minLat, minLon, minAlt, maxLat, maxLon, maxAlt, 0);
    }

    public synchronized void weatherCreateThermal(int dataRequestID, float lat, float lon, float alt, float radius, float height) throws IOException {
        this.weatherCreateThermal(dataRequestID, lat, lon, alt, radius, height, 3.0f, 0.05f, 3.0f, 0.2f, 0.4f, 0.1f, 0.4f, 0.1f);
    }

    public synchronized void weatherCreateThermal(int dataRequestID, float lat, float lon, float alt, float radius, float height, float coreRate, float coreTurbulence, float sinkRate, float sinkTurbulence, float coreSize, float coreTransitionSize, float sinkLayerSize, float sinkTransitionSize) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putFloat(lat);
        this.writeBuffer.putFloat(lon);
        this.writeBuffer.putFloat(alt);
        this.writeBuffer.putFloat(radius);
        this.writeBuffer.putFloat(height);
        this.writeBuffer.putFloat(coreRate);
        this.writeBuffer.putFloat(coreTurbulence);
        this.writeBuffer.putFloat(sinkRate);
        this.writeBuffer.putFloat(sinkTurbulence);
        this.writeBuffer.putFloat(coreSize);
        this.writeBuffer.putFloat(coreTransitionSize);
        this.writeBuffer.putFloat(sinkLayerSize);
        this.writeBuffer.putFloat(sinkTransitionSize);
        this.sendPacket(37);
    }

    public synchronized void weatherRemoveThermal(int objectID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(objectID);
        this.sendPacket(38);
    }

    public synchronized void aICreateParkedATCAircraft(String containerTitle, String tailNumber, String airportID, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, containerTitle, 256);
        this.putString(this.writeBuffer, tailNumber, 12);
        this.putString(this.writeBuffer, airportID, 5);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(39);
    }

    public synchronized void aICreateEnrouteATCAircraft(String containerTitle, String tailNumber, int flightNumber, String flightPlanPath, double flightPlanPosition, boolean touchAndGo, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, containerTitle, 256);
        this.putString(this.writeBuffer, tailNumber, 12);
        this.writeBuffer.putInt(flightNumber);
        this.putString(this.writeBuffer, flightPlanPath, 260);
        this.writeBuffer.putDouble(flightPlanPosition);
        this.writeBuffer.putInt(touchAndGo ? 1 : 0);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(40);
    }

    public synchronized void aICreateNonATCAircraft(String containerTitle, String tailNumber, InitPosition initPos, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, containerTitle, 256);
        this.putString(this.writeBuffer, tailNumber, 12);
        initPos.write(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(41);
    }

    public synchronized void aICreateNonATCAircraft(String containerTitle, String tailNumber, InitPosition initPos, Enum dataRequestID) throws IOException {
        this.aICreateNonATCAircraft(containerTitle, tailNumber, initPos, dataRequestID.ordinal());
    }

    public synchronized void aICreateSimulatedObject(String containerTitle, InitPosition initPos, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, containerTitle, 256);
        initPos.write(this.writeBuffer);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(42);
    }

    public synchronized void aICreateSimulatedObject(String containerTitle, InitPosition initPos, Enum dataRequestID) throws IOException {
        this.aICreateSimulatedObject(containerTitle, initPos, dataRequestID.ordinal());
    }

    public synchronized void aIReleaseControl(int objectID, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(43);
    }

    public synchronized void aIReleaseControl(int objectID, Enum dataRequestID) throws IOException {
        this.aIReleaseControl(objectID, dataRequestID.ordinal());
    }

    public synchronized void aIRemoveObject(int objectID, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(objectID);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(44);
    }

    public synchronized void aIRemoveObject(int objectID, Enum dataRequestID) throws IOException {
        this.aIRemoveObject(objectID, dataRequestID.ordinal());
    }

    public synchronized void aISetAircraftFlightPlan(int objectID, String flightPlanPath, int dataRequestID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(objectID);
        this.putString(this.writeBuffer, flightPlanPath, 260);
        this.writeBuffer.putInt(dataRequestID);
        this.sendPacket(45);
    }

    public synchronized void executeMissionAction(byte[] guidInstanceId) throws IOException {
        if (guidInstanceId.length != 16) {
            throw new IllegalArgumentException(Messages.get("SimConnect.GUID_invalid_size"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.put(guidInstanceId);
        this.sendPacket(46);
    }

    public synchronized void completeCustomMissionAction(byte[] guidInstanceId) throws IOException {
        if (guidInstanceId.length != 16) {
            throw new IllegalArgumentException(Messages.get("SimConnect.GUID_invalid_size"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.put(guidInstanceId);
        this.sendPacket(47);
    }

    public synchronized int getLastSentPacketID() {
        return this.currentIndex - 1;
    }

    public synchronized float[] requestResponseTimes(int nCount) throws IOException {
        throw new UnsupportedOperationException(Messages.get("SimConnect.Unimplemented"));
    }

    public synchronized void cameraSetRelative6DOF(float deltaX, float deltaY, float deltaZ, float pitchDeg, float bankDeg, float headingDeg) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putFloat(deltaX);
        this.writeBuffer.putFloat(deltaY);
        this.writeBuffer.putFloat(deltaZ);
        this.writeBuffer.putFloat(pitchDeg);
        this.writeBuffer.putFloat(bankDeg);
        this.writeBuffer.putFloat(headingDeg);
        this.sendPacket(48);
    }

    public synchronized void menuAddItem(String menuItem, int clientMenuEventID, int data) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, menuItem, 256);
        this.writeBuffer.putInt(clientMenuEventID);
        this.writeBuffer.putInt(data);
        this.sendPacket(49);
    }

    public synchronized void menuAddItem(String menuItem, Enum clientMenuEventID, int data) throws IOException {
        this.menuAddItem(menuItem, clientMenuEventID.ordinal(), data);
    }

    public synchronized void menuDeleteItem(int clientMenuEventID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientMenuEventID);
        this.sendPacket(50);
    }

    public synchronized void menuDeleteItem(Enum clientMenuEventID) throws IOException {
        this.menuDeleteItem(clientMenuEventID.ordinal());
    }

    public synchronized void menuAddSubItem(int clientMenuEventID, String menuItem, int clientSubMenuEventID, int data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientMenuEventID);
        this.putString(this.writeBuffer, menuItem, 256);
        this.writeBuffer.putInt(clientSubMenuEventID);
        this.writeBuffer.putInt(data);
        this.sendPacket(51);
    }

    public synchronized void menuAddSubItem(Enum clientMenuEventID, String menuItem, Enum clientSubMenuEventID, int data) throws IOException {
        this.menuAddSubItem(clientMenuEventID.ordinal(), menuItem, clientSubMenuEventID.ordinal(), data);
    }

    public synchronized void menuDeleteSubItem(int clientMenuEventID, int clientSubMenuEventID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientMenuEventID);
        this.writeBuffer.putInt(clientSubMenuEventID);
        this.sendPacket(52);
    }

    public synchronized void menuDeleteSubItem(Enum clientMenuEventID, Enum clientSubMenuEventID) throws IOException {
        this.menuDeleteSubItem(clientMenuEventID.ordinal(), clientSubMenuEventID.ordinal());
    }

    public synchronized void mapClientDataNameToID(String clientDataName, int clientDataID) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, clientDataName, 256);
        this.writeBuffer.putInt(clientDataID);
        this.sendPacket(55);
    }

    public synchronized void mapClientDataNameToID(String clientDataName, Enum clientDataID) throws IOException {
        this.mapClientDataNameToID(clientDataName, clientDataID.ordinal());
    }

    public synchronized void createClientData(int clientDataID, int size, boolean readOnly) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(size);
        this.writeBuffer.putInt(readOnly ? 1 : 0);
        this.sendPacket(56);
    }

    public synchronized void createClientData(Enum clientDataID, int size, boolean readOnly) throws IOException {
        this.createClientData(clientDataID.ordinal(), size, readOnly);
    }

    public synchronized void addToClientDataDefinition(int dataDefineID, int offset, int size) throws IOException {
        this.addToClientDataDefinition(dataDefineID, offset, size, 0);
    }

    public synchronized void addToClientDataDefinition(int dataDefineID, int offset, int size, int reserved) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefineID);
        this.writeBuffer.putInt(offset);
        this.writeBuffer.putInt(size);
        this.writeBuffer.putInt(reserved);
        if (this.ourProtocol > 3) {
            this.writeBuffer.putInt(-1);
        }
        this.sendPacket(57);
    }

    public synchronized void addToClientDataDefinition(int dataDefineID, int offset, int sizeOrType, float epsilon, int datumId) throws IOException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefineID);
        this.writeBuffer.putInt(offset);
        this.writeBuffer.putInt(sizeOrType);
        this.writeBuffer.putFloat(epsilon);
        this.writeBuffer.putInt(datumId);
        this.sendPacket(57);
    }

    public synchronized void addToClientDataDefinition(Enum dataDefineID, int offset, int sizeOrType, float epsilon, int datumId) throws IOException {
        this.addToClientDataDefinition(dataDefineID.ordinal(), offset, sizeOrType, epsilon, datumId);
    }

    public synchronized void addToClientDataDefinition(Enum dataDefineID, int sizeOrType) throws IOException {
        this.addToClientDataDefinition(dataDefineID.ordinal(), -1, sizeOrType, 0.0f, 0);
    }

    public synchronized void clearClientDataDefinition(int dataDefineID) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(dataDefineID);
        this.sendPacket(58);
    }

    public synchronized void requestClientData(int clientDataID, int dataRequestID, int clientDataDefineID) throws IOException {
        this.requestClientData(clientDataID, dataRequestID, clientDataDefineID, -1, 0);
    }

    public synchronized void requestClientData(int clientDataID, int dataRequestID, int clientDataDefineID, int reserved1, int reserved2) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putInt(clientDataDefineID);
        if (this.ourProtocol >= 3) {
            this.writeBuffer.putInt(SimConnectPeriod.ONCE.ordinal());
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(0);
            this.writeBuffer.putInt(0);
        } else {
            this.writeBuffer.putInt(reserved1);
            this.writeBuffer.putInt(reserved2);
        }
        this.sendPacket(59);
    }

    public synchronized void requestClientData(int clientDataID, int dataRequestID, int clientDataDefineID, ClientDataPeriod period, int flags, int origin, int interval, int limit) throws IOException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(dataRequestID);
        this.writeBuffer.putInt(clientDataDefineID);
        this.writeBuffer.putInt(period.ordinal());
        this.writeBuffer.putInt(flags);
        this.writeBuffer.putInt(origin);
        this.writeBuffer.putInt(interval);
        this.writeBuffer.putInt(limit);
        this.sendPacket(59);
    }

    public synchronized void requestClientData(Enum clientDataID, Enum dataRequestID, Enum clientDataDefineID, ClientDataPeriod period, int flags, int origin, int interval, int limit) throws IOException {
        this.requestClientData(clientDataID.ordinal(), dataRequestID.ordinal(), clientDataDefineID.ordinal(), period, flags, origin, interval, limit);
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, int reserved, int arrayCount, int unitSize, byte[] data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(clientDataDefineID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(unitSize);
        this.writeBuffer.put(data);
        this.sendPacket(60);
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, byte[] data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(clientDataDefineID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(data.length);
        this.writeBuffer.put(data);
        this.sendPacket(60);
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, int reserved, int arrayCount, int unitSize, ByteBuffer data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(clientDataDefineID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(unitSize);
        this.writeBuffer.put(data);
        this.sendPacket(60);
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, int reserved, int arrayCount, int unitSize, DataWrapper data) throws IOException {
        this.setClientData(clientDataID, clientDataDefineID, reserved, arrayCount, unitSize, data.getBuffer());
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, ByteBuffer data) throws IOException {
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(clientDataID);
        this.writeBuffer.putInt(clientDataDefineID);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(1);
        this.writeBuffer.putInt(data.remaining());
        this.writeBuffer.put(data);
        this.sendPacket(60);
    }

    public synchronized void setClientData(int clientDataID, int clientDataDefineID, DataWrapper data) throws IOException {
        this.setClientData(clientDataID, clientDataDefineID, data.getBuffer());
    }

    public synchronized void flightLoad(String fileName) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, fileName, 260);
        this.sendPacket(61);
    }

    public synchronized void flightSave(String fileName, String description, int flags) throws IOException {
        if (this.ourProtocol >= 4) {
            this.flightSave(fileName, fileName, description, flags);
        } else {
            this.clean(this.writeBuffer);
            this.putString(this.writeBuffer, fileName, 260);
            this.putString(this.writeBuffer, description, 2048);
            this.writeBuffer.putInt(-1);
            this.sendPacket(62);
        }
    }

    public synchronized void flightSave(String fileName, String title, String description, int flags) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 4) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        if (title == null) {
            title = fileName;
        }
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, fileName, 260);
        this.putString(this.writeBuffer, title, 260);
        this.putString(this.writeBuffer, description, 2048);
        this.writeBuffer.putInt(-1);
        this.sendPacket(62);
    }

    public synchronized void flightPlanLoad(String fileName) throws IOException {
        this.clean(this.writeBuffer);
        this.putString(this.writeBuffer, fileName, 260);
        this.sendPacket(63);
    }

    public synchronized void text(int type, float timeSeconds, int eventId, String message) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(type);
        this.writeBuffer.putFloat(timeSeconds);
        this.writeBuffer.putInt(eventId);
        if (message != null && message.length() > 0) {
            byte[] messageBytes = message.getBytes();
            this.writeBuffer.putInt(messageBytes.length + 1);
            this.writeBuffer.put(messageBytes);
        } else {
            this.writeBuffer.putInt(1);
        }
        this.writeBuffer.put((byte)0);
        this.sendPacket(64);
    }

    public synchronized void text(TextType type, float timeSeconds, int eventId, String message) throws IOException, UnsupportedOperationException {
        this.text(type.value(), timeSeconds, eventId, message);
    }

    public synchronized void text(TextType type, float timeSeconds, Enum eventId, String message) throws IOException, UnsupportedOperationException {
        this.text(type.value(), timeSeconds, eventId.ordinal(), message);
    }

    public synchronized void menu(float timeSeconds, int eventId, String title, String prompt, String ... items) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(TextType.MENU.value());
        this.writeBuffer.putFloat(timeSeconds);
        this.writeBuffer.putInt(eventId);
        this.writeBuffer.putInt(0);
        if (title == null && prompt == null && items == null) {
            this.writeBuffer.put((byte)0);
        } else {
            this.writeBuffer.put(title.getBytes());
            this.writeBuffer.put((byte)0);
            this.writeBuffer.put(prompt.getBytes());
            this.writeBuffer.put((byte)0);
            for (String s : items) {
                if (s == null) continue;
                byte[] itemBytes = s.getBytes();
                this.writeBuffer.put(itemBytes);
                this.writeBuffer.put((byte)0);
            }
        }
        this.writeBuffer.putInt(28, this.writeBuffer.position() - 32);
        this.sendPacket(64);
    }

    public synchronized void menu(float timeSeconds, Enum eventId, String title, String prompt, String ... items) throws IOException, UnsupportedOperationException {
        this.menu(timeSeconds, eventId.ordinal(), title, prompt, items);
    }

    public synchronized void requestFacilitiesList(FacilityListType type, int eventId) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(type.ordinal());
        this.writeBuffer.putInt(eventId);
        this.sendPacket(67);
    }

    public synchronized void requestFacilitiesList(FacilityListType type, Enum eventId) throws IOException, UnsupportedOperationException {
        this.requestFacilitiesList(type, eventId.ordinal());
    }

    public synchronized void subscribeToFacilities(FacilityListType type, int eventId) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(type.ordinal());
        this.writeBuffer.putInt(eventId);
        this.sendPacket(65);
    }

    public synchronized void subscribeToFacilities(FacilityListType type, Enum eventId) throws IOException, UnsupportedOperationException {
        this.subscribeToFacilities(type, eventId.ordinal());
    }

    public synchronized void unSubscribeToFacilities(FacilityListType type) throws IOException, UnsupportedOperationException {
        if (this.ourProtocol < 3) {
            throw new UnsupportedOperationException(Messages.getString("SimConnect.badversion"));
        }
        this.clean(this.writeBuffer);
        this.writeBuffer.putInt(type.ordinal());
        this.sendPacket(66);
    }

    public void callDispatch(Dispatcher dispatcher) throws IOException {
        this.pumpNextData();
        dispatcher.dispatch(this, this.readBuffer);
    }

    private void pumpNextData() throws IOException {
        this.readBuffer.clear();
        this.readBuffer.limit(4);
        int rlen = this.sc.read(this.readBuffer);
        if (rlen != 4) {
            throw new IOException(Messages.get("SimConnect.Invalid_read"));
        }
        int dlen = this.readBuffer.getInt(0);
        if (dlen > this.readBuffer.capacity()) {
            throw new IOException(Messages.getString("SimConnect.PacketTooLarge"));
        }
        this.readBuffer.position(4);
        this.readBuffer.limit(dlen);
        for (rlen = 4; rlen < dlen; rlen += this.sc.read(this.readBuffer)) {
        }
        ++this.packetsReceived;
        this.bytesReceived += dlen;
        if (rlen != dlen) {
            throw new IOException(Messages.get("SimConnect.Short_read") + " (" + Messages.get("SimConnect.expected") + " " + dlen + " " + Messages.get("SimConnect.got") + " " + rlen + ")");
        }
        this.readBuffer.position(0);
    }

    public ByteBuffer getNextData() throws IOException {
        this.pumpNextData();
        return this.readBuffer;
    }

    protected void finalize() throws Throwable {
        if (this.sc.isConnected()) {
            this.sc.close();
        }
    }

    public int getReceivedBytes() {
        return this.bytesReceived;
    }

    public int getSentBytes() {
        return this.bytesSent;
    }

    public int getReceivedPackets() {
        return this.packetsReceived;
    }

    public int getSentPackets() {
        return this.packetsSent;
    }

    public int getProtocolVersion() {
        return this.ourProtocol;
    }
}

